/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.plugins.CoverGrabber.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jmp3renamer.DataManager;
import net.sf.jmp3renamer.DataSet;
import net.sf.jmp3renamer.FileManager;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.Main;
import net.sf.jmp3renamer.plugins.CoverGrabber.CoverGrabber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CoverGrabberPanel
extends JPanel
implements ActionListener,
Runnable,
Observer {
    private static transient Logger logger = LoggerFactory.getLogger((Class)(class$net$sf$jmp3renamer$plugins$CoverGrabber$gui$CoverGrabberPanel == null ? (class$net$sf$jmp3renamer$plugins$CoverGrabber$gui$CoverGrabberPanel = CoverGrabberPanel.class$("net.sf.jmp3renamer.plugins.CoverGrabber.gui.CoverGrabberPanel")) : class$net$sf$jmp3renamer$plugins$CoverGrabber$gui$CoverGrabberPanel));
    private JLabel lAlbum = new JLabel(I18N.translate((String)"album"));
    private JLabel lArtist = new JLabel(I18N.translate((String)"artist"));
    private JTextField tAlbum = new JTextField();
    private JTextField tArtist = new JTextField();
    private JButton getCoverButton;
    private JButton nextButton = new JButton(">");
    private JButton prevButton = new JButton("<");
    private JButton saveCoverButton = new JButton(I18N.translate((String)"save"));
    private JProgressBar progress = new JProgressBar(0, 100);
    private JLabel coverPreview = new JLabel();
    private String url = "";
    private ArrayList images = new ArrayList();
    private int currentIndex = 0;
    private TitledBorder titledBorder = BorderFactory.createTitledBorder(I18N.translate((String)"preview"));
    private File cover;
    static /* synthetic */ Class class$net$sf$jmp3renamer$plugins$CoverGrabber$gui$CoverGrabberPanel;

    public CoverGrabberPanel() {
        this.initGUI();
        FileManager.getInstance().addObserver((Observer)this);
        DataManager.getInstance().addObserver((Observer)this);
    }

    private void initGUI() {
        this.getCoverButton = new JButton(I18N.translate((String)"get_cover"));
        this.getCoverButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lArtist, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.tArtist, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lAlbum, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.tAlbum, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.progress, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.getCoverButton, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.coverPreview, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.prevButton, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.nextButton, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.saveCoverButton, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.progress.setVisible(false);
        this.progress.setStringPainted(true);
        this.coverPreview.setBorder(this.titledBorder);
        this.coverPreview.setVisible(false);
        this.nextButton.setVisible(false);
        this.saveCoverButton.setVisible(false);
        this.nextButton.addActionListener(this);
        this.prevButton.setVisible(false);
        this.prevButton.addActionListener(this);
        this.saveCoverButton.addActionListener(this);
        this.tAlbum.addActionListener(this);
        this.tArtist.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getCoverButton) {
            this.getCovers();
        } else if (e.getSource() == this.nextButton) {
            if (this.currentIndex < this.images.size() - 1) {
                ++this.currentIndex;
                this.saveCoverButton.setVisible(true);
                this.showCover((ImageIcon)this.images.get(this.currentIndex));
            }
        } else if (e.getSource() == this.prevButton) {
            if (this.currentIndex > 0) {
                --this.currentIndex;
                this.saveCoverButton.setVisible(true);
                this.showCover((ImageIcon)this.images.get(this.currentIndex));
            }
        } else if (e.getSource() == this.saveCoverButton) {
            this.saveCover();
        } else if (e.getSource() == this.tAlbum || e.getSource() == this.tArtist) {
            this.getCovers();
        }
    }

    private void getCovers() {
        String query = this.tArtist.getText() + " " + this.tAlbum.getText();
        try {
            query = URLEncoder.encode(query, "ISO-8859-1");
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.url = CoverGrabber.getProperty("url");
        this.url = this.url.replaceAll("\\$\\{query\\}", query);
        logger.debug(this.url);
        Thread t = new Thread(this);
        t.start();
    }

    private void saveCover() {
        if (FileManager.getInstance().getFiles().size() > 0) {
            File mp3 = (File)FileManager.getInstance().getFiles().get(0);
            File dir = mp3.getParentFile();
            File cover = new File(dir, CoverGrabber.getProperty("filename"));
            if (cover.exists()) {
                String msg = I18N.translate((String)"cover_exists");
                logger.warn(msg);
                int selection = JOptionPane.showConfirmDialog((Component)Main.getGUI(), msg);
                if (selection == 0) {
                    boolean deleted = cover.delete();
                    if (!deleted) {
                        logger.error(I18N.translate((String)"couldnt_delete"));
                        return;
                    }
                } else {
                    return;
                }
            }
            ImageIcon icon = (ImageIcon)this.images.get(this.currentIndex);
            BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 1);
            icon.paintIcon(null, image.createGraphics(), 0, 0);
            try {
                ImageIO.write((RenderedImage)image, "JPG", cover);
            }
            catch (IOException e) {
                logger.error("Couldn't save image", (Throwable)e);
            }
            FileManager.getInstance().addAdditionalFile(cover);
        } else {
            logger.error(I18N.translate((String)"no_dir_selected"));
        }
    }

    private void showCover(ImageIcon cover) {
        Image tmp = cover.getImage();
        ImageIcon preview = new ImageIcon(tmp.getScaledInstance(250, 250, 4));
        this.coverPreview.setIcon(preview);
        this.coverPreview.setVisible(true);
        this.titledBorder.setTitle(I18N.translate((String)"preview") + " (" + (this.currentIndex + 1) + "/" + this.images.size() + ") " + cover.getIconWidth() + "x" + cover.getIconHeight());
    }

    private void showExistingCover(File coverFile) {
        ImageIcon cover = this.loadCover(coverFile);
        if (cover != null) {
            this.showCover(cover);
            this.titledBorder.setTitle(I18N.translate((String)"current_cover"));
        }
    }

    private ImageIcon loadCover(File coverFile) {
        ImageIcon cover = null;
        try {
            cover = new ImageIcon(coverFile.toURI().toURL());
        }
        catch (Exception e) {
            logger.error("Couldn't load existing cover", (Throwable)e);
        }
        return cover;
    }

    public void run() {
        this.tArtist.setEnabled(false);
        this.tAlbum.setEnabled(false);
        this.progress.setValue(0);
        this.getCoverButton.setVisible(false);
        this.progress.setVisible(true);
        Main.getGUI().setCursor(new Cursor(3));
        try {
            logger.info("Searching for covers...");
            ArrayList<String> coverURLs = new ArrayList<String>();
            HttpURLConnection http = (HttpURLConnection)new URL(this.url).openConnection();
            InputStream in = http.getInputStream();
            DocumentBuilder docbuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docbuilder.parse(in);
            NodeList imageSets = doc.getElementsByTagName("ImageSets");
            Element primaryImageSet = null;
            for (int i = 0; i < imageSets.getLength(); ++i) {
                Element imageSet = (Element)imageSets.item(i);
                for (int j = 0; j < imageSet.getChildNodes().getLength(); ++j) {
                    Element elem = (Element)imageSet.getChildNodes().item(j);
                    if (!"ImageSet".equalsIgnoreCase(elem.getNodeName()) || !"primary".equalsIgnoreCase(elem.getAttribute("Category"))) continue;
                    primaryImageSet = elem;
                }
                if (primaryImageSet == null) continue;
                Node imageNode = null;
                if (primaryImageSet.getElementsByTagName("LargeImage").getLength() > 0) {
                    imageNode = primaryImageSet.getElementsByTagName("LargeImage").item(0);
                } else if (primaryImageSet.getElementsByTagName("MediumImage").getLength() > 0) {
                    imageNode = primaryImageSet.getElementsByTagName("MediumImage").item(0);
                } else if (primaryImageSet.getElementsByTagName("SmallImage").getLength() > 0) {
                    imageNode = primaryImageSet.getElementsByTagName("SmallImage").item(0);
                }
                if (imageNode == null || !imageNode.hasChildNodes()) continue;
                Node url = imageNode.getFirstChild();
                NodeList childs = url.getChildNodes();
                for (int j = 0; j < childs.getLength(); ++j) {
                    if (childs.item(j).getNodeType() != 3) continue;
                    String imageUrl = childs.item(j).getNodeValue();
                    logger.debug("Adding " + imageUrl);
                    coverURLs.add(imageUrl);
                }
            }
            logger.info("Downloading possible covers...");
            this.images = new ArrayList();
            int counter = 0;
            Iterator iter = coverURLs.iterator();
            while (iter.hasNext()) {
                String element = (String)iter.next();
                logger.debug("Fetching {}", (Object)element);
                http = (HttpURLConnection)new URL(element).openConnection();
                in = http.getInputStream();
                int length = -1;
                byte[] buffer = new byte[1024];
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                while ((length = in.read(buffer)) > 0) {
                    bos.write(buffer, 0, length);
                }
                http.disconnect();
                ImageIcon cover = new ImageIcon(bos.toByteArray());
                if (cover.getIconWidth() > 50 && cover.getIconWidth() > 50) {
                    this.images.add(cover);
                    logger.debug("Adding cover: {}", (Object)element);
                } else {
                    logger.debug("Skipping cover with too small resolution");
                }
                int prog = (int)((double)counter / (double)coverURLs.size() * 100.0);
                this.progress.setValue(prog);
                ++counter;
            }
            if (this.images.size() > 0) {
                this.currentIndex = 0;
                this.showCover((ImageIcon)this.images.get(0));
                this.coverPreview.setVisible(true);
                this.nextButton.setVisible(true);
                this.prevButton.setVisible(true);
                this.saveCoverButton.setVisible(true);
            } else {
                String mesg = I18N.translate((String)"no_covers_found");
                logger.info(mesg);
                JOptionPane.showMessageDialog((Component)Main.getGUI(), mesg);
            }
        }
        catch (Exception e) {
            logger.error("Couldn't load covers", (Throwable)e);
        }
        Main.getGUI().setCursor(new Cursor(0));
        this.getCoverButton.setVisible(true);
        this.progress.setVisible(false);
        this.tArtist.setEnabled(true);
        this.tAlbum.setEnabled(true);
    }

    public void update(Observable arg0, Object obj) {
        if (arg0 == FileManager.getInstance()) {
            this.nextButton.setVisible(false);
            this.prevButton.setVisible(false);
            this.saveCoverButton.setVisible(false);
            Vector vector = (Vector)obj;
            if (vector.size() > 0) {
                File file = (File)vector.elementAt(0);
                File dir = file.getParentFile();
                this.cover = new File(dir, CoverGrabber.getProperty("filename"));
                if (this.cover.exists()) {
                    FileManager.getInstance().addAdditionalFile(this.cover);
                    this.showExistingCover(this.cover);
                } else {
                    this.coverPreview.setVisible(false);
                    this.coverPreview.setIcon(null);
                }
            }
        } else if (arg0 == DataManager.getInstance()) {
            Vector datasets = (Vector)obj;
            Iterator iter = datasets.iterator();
            while (iter.hasNext()) {
                DataSet dataset = (DataSet)iter.next();
                if (!"".equals(dataset.getArtist())) {
                    this.tArtist.setText(dataset.getArtist());
                }
                if ("".equals(dataset.getAlbum())) continue;
                this.tAlbum.setText(dataset.getAlbum());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

