/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.plugins.Ogg;

import entagged.audioformats.AudioFile;
import entagged.audioformats.AudioFileIO;
import entagged.audioformats.Tag;
import entagged.audioformats.exceptions.CannotReadException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import net.sf.jmp3renamer.AbstractTranslatablePlugin;
import net.sf.jmp3renamer.DataSet;
import net.sf.jmp3renamer.FilePlugin;
import net.sf.jmp3renamer.gui.PluginConfigGUI;
import net.sf.jmp3renamer.plugins.Ogg.OggFileFilter;
import net.sf.jmp3renamer.plugins.Ogg.gui.OggConfigGui;
import net.sf.jmp3renamer.util.ExtendedFileFilter;
import net.sf.jmp3renamer.util.MyFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ogg
extends AbstractTranslatablePlugin
implements FilePlugin {
    private static final String VERSION = "0.7";
    private static final String AUTHOR = "Henrik Niehaus, hampelratte@users.sf.net";
    private static final String NAME = "Ogg Files";
    private static final String DESCRIPTION = "The Ogg Files plugin makes JMP3Renamer understand the ogg file format. JMP3Renamer will be able to read and write Ogg-Comments";
    private OggFileFilter filter = new OggFileFilter();
    private static Properties props = new Properties();
    private static transient Logger logger = LoggerFactory.getLogger((Class)(class$net$sf$jmp3renamer$plugins$Ogg$Ogg == null ? (class$net$sf$jmp3renamer$plugins$Ogg$Ogg = Ogg.class$("net.sf.jmp3renamer.plugins.Ogg.Ogg")) : class$net$sf$jmp3renamer$plugins$Ogg$Ogg));
    private boolean propsLoaded = false;
    private OggConfigGui configGui;
    static /* synthetic */ Class class$net$sf$jmp3renamer$plugins$Ogg$Ogg;

    public void init() {
        this.loadConfig();
        this.loadLanguage();
        this.configGui = new OggConfigGui(this);
    }

    public String getVersion() {
        return VERSION;
    }

    public String getAuthor() {
        return AUTHOR;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    private void loadConfig() {
        props.setProperty("rename_comment", "true");
        if (!this.propsLoaded) {
            String file = System.getProperty("user.home") + System.getProperty("file.separator") + ".jmp3renamer" + System.getProperty("file.separator") + "ogg.props";
            try {
                File conffile;
                File confdir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jmp3renamer");
                if (!confdir.exists()) {
                    confdir.mkdir();
                }
                if (!(conffile = new File(file)).exists()) {
                    conffile.createNewFile();
                }
                FileInputStream fin = new FileInputStream(file);
                props.load(fin);
                this.propsLoaded = true;
            }
            catch (Exception e) {
                logger.error("Couldn't load settings", (Throwable)e);
            }
        }
    }

    public int getType() {
        return 1;
    }

    public String getName() {
        return NAME;
    }

    public PluginConfigGUI getConfigGUI() {
        return this.configGui;
    }

    public Properties getConfig() {
        return props;
    }

    public static String getProperty(String key) {
        return props.getProperty(key);
    }

    public static void setProperty(String key, String value) {
        props.setProperty(key, value);
    }

    public void saveConfig() {
        String file = System.getProperty("user.home") + System.getProperty("file.separator") + ".jmp3renamer" + System.getProperty("file.separator") + "ogg.props";
        try {
            FileOutputStream fout = new FileOutputStream(file);
            props.store(fout, "Ogg Properties");
            logger.info("{}: Saving properties: done", (Object)NAME);
        }
        catch (Exception e) {
            logger.error("Ogg Files: Saving properties: failed", (Throwable)e);
        }
    }

    public DataSet getMetaData(File file) {
        DataSet dataset = new DataSet();
        try {
            AudioFile af = AudioFileIO.read((File)file);
            Tag tag = af.getTag();
            dataset.setAlbum(tag.getFirstAlbum());
            dataset.setArtist(tag.getFirstArtist());
            dataset.setTitle(tag.getFirstTitle());
            dataset.setComment(tag.getFirstComment());
            dataset.setTrack(tag.getFirstTrack());
            dataset.setYear(tag.getFirstYear());
            dataset.setGenre(tag.getFirstGenre());
        }
        catch (CannotReadException e) {
            logger.error("Couldn't read tag from file", (Throwable)e);
        }
        return dataset;
    }

    public void setMetaData(MyFile file, DataSet dataset) throws Exception {
        if (Boolean.TRUE.toString().equalsIgnoreCase(Ogg.getProperty("rename_comment"))) {
            AudioFile af = AudioFileIO.read((File)file);
            AudioFileIO.delete((AudioFile)af);
            Tag tag = af.getTag();
            tag.setTitle(dataset.getTitle());
            tag.setTrack(dataset.getTrack());
            tag.setArtist(dataset.getArtist());
            tag.setAlbum(dataset.getAlbum());
            tag.setComment(dataset.getComment());
            tag.setYear(dataset.getYear());
            tag.setGenre(dataset.getGenre());
            AudioFileIO.write((AudioFile)af);
        }
    }

    public ExtendedFileFilter getFileFilter() {
        return this.filter;
    }

    public String toString() {
        return this.getName();
    }

    public void coreStarted() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

