/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.plugins.MusicBrainz;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import net.sf.jmp3renamer.AbstractTranslatablePlugin;
import net.sf.jmp3renamer.DataPlugin;
import net.sf.jmp3renamer.gui.PluginConfigGUI;
import net.sf.jmp3renamer.plugins.MusicBrainz.gui.MusicBrainzConfigPanel;
import net.sf.jmp3renamer.plugins.MusicBrainz.gui.MusicBrainzPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MusicBrainz
extends AbstractTranslatablePlugin
implements DataPlugin {
    private static final String VERSION = "0.8";
    private static final String AUTHOR = "Henrik Niehaus, hampelratte@users.sf.net";
    private static final String NAME = "MusicBrainz Client";
    private static final String DESCRIPTION = "The MusicBrainz Client connects to one of the MusicBrainz project servers to get all needed data. You just have to enter the artist and the album and MusicBrainz Client will query MusicBrainz. ";
    private static Properties props = new Properties();
    private static transient Logger logger = LoggerFactory.getLogger((Class)(class$net$sf$jmp3renamer$plugins$MusicBrainz$MusicBrainz == null ? (class$net$sf$jmp3renamer$plugins$MusicBrainz$MusicBrainz = MusicBrainz.class$("net.sf.jmp3renamer.plugins.MusicBrainz.MusicBrainz")) : class$net$sf$jmp3renamer$plugins$MusicBrainz$MusicBrainz));
    private boolean propsLoaded = false;
    private MusicBrainzPanel gui;
    private MusicBrainzConfigPanel configGui;
    private String file = System.getProperty("user.home") + System.getProperty("file.separator") + ".jmp3renamer" + System.getProperty("file.separator") + "musicbrainz.props";
    private File conffile = new File(this.file);
    static /* synthetic */ Class class$net$sf$jmp3renamer$plugins$MusicBrainz$MusicBrainz;

    public String getVersion() {
        return VERSION;
    }

    public String getAuthor() {
        return AUTHOR;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public void init() {
        this.loadConfig();
        this.loadLanguage();
        this.gui = new MusicBrainzPanel();
        this.configGui = new MusicBrainzConfigPanel();
    }

    private void loadConfig() {
        props.setProperty("url", "http://mm.musicbrainz.org");
        props.setProperty("cgi_path", "/cgi-bin/mq_2_1.pl");
        if (!this.propsLoaded) {
            try {
                File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jmp3renamer");
                if (!file.exists()) {
                    file.mkdir();
                }
                if (!this.conffile.exists()) {
                    this.conffile.createNewFile();
                }
                FileInputStream fileInputStream = new FileInputStream(this.file);
                props.load(fileInputStream);
                this.propsLoaded = true;
            }
            catch (Exception exception) {
                logger.error("Couldn't load settings", (Throwable)exception);
            }
        }
    }

    public int getType() {
        return 0;
    }

    public String getName() {
        return NAME;
    }

    public JComponent getGUI() {
        return this.gui;
    }

    public PluginConfigGUI getConfigGUI() {
        return this.configGui;
    }

    public Properties getConfig() {
        return props;
    }

    public static String getProperty(String string) {
        return props.getProperty(string);
    }

    public static void setProperty(String string, String string2) {
        props.setProperty(string, string2);
    }

    public void saveConfig() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            props.store(fileOutputStream, "MusicBrainz Properties");
            logger.info("{}: Saving properties: done", (Object)NAME);
        }
        catch (Exception exception) {
            logger.error("MusicBrainz Client: Saving properties: failed", (Throwable)exception);
        }
    }

    public String toString() {
        return this.getName();
    }

    public Icon getIcon() {
        ImageIcon imageIcon = null;
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("icons/icon32.png");
        int n = -1;
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            imageIcon = new ImageIcon(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            logger.warn("Couldn't load icon", (Throwable)iOException);
        }
        return imageIcon;
    }

    public void coreStarted() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

