/*
 * Decompiled with CFR 0.152.
 */
package com.wet.wired.jsr.converter;

import com.wet.wired.jsr.converter.FrameDecompressor;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;

public class RecordingStream {
    private Rectangle area;
    private Rectangle outputArea;
    private FrameDecompressor decompressor;
    private long frameTime;
    private boolean finished = false;

    public RecordingStream(InputStream iStream, int width, int height) {
        this(iStream);
        this.outputArea = new Rectangle(width, height);
    }

    public RecordingStream(InputStream iStream) {
        try {
            int width = iStream.read();
            width <<= 8;
            int height = iStream.read();
            height <<= 8;
            this.outputArea = this.area = new Rectangle(width += iStream.read(), height += iStream.read());
            this.decompressor = new FrameDecompressor(iStream, width * height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BufferedImage readFrame() throws IOException {
        FrameDecompressor.FramePacket frame = this.decompressor.unpack();
        this.frameTime = frame.getTimeStamp();
        int result = frame.getResult();
        if (result == 0) {
            return null;
        }
        if (result == -1) {
            this.finished = true;
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(this.area.width, this.area.height, 1);
        bufferedImage.setRGB(0, 0, this.area.width, this.area.height, frame.getData(), 0, this.area.width);
        return bufferedImage;
    }

    public Rectangle getArea() {
        return this.outputArea;
    }

    public long getFrameTime() {
        return this.frameTime;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

