/*
 * Decompiled with CFR 0.152.
 */
package com.wet.wired.jsr.player;

import com.wet.wired.jsr.player.FileExtensionFilter;
import com.wet.wired.jsr.player.ScreenPlayer;
import com.wet.wired.jsr.player.ScreenPlayerListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class JPlayer
extends JFrame
implements ScreenPlayerListener,
ActionListener {
    private ScreenPlayer screenPlayer;
    private ImageIcon icon;
    private JButton open;
    private JButton reset;
    private JButton play;
    private JButton fastForward;
    private JButton pause;
    private JButton stop;
    private JLabel text;
    private JLabel frameLabel;
    private String target;
    private int frameCount;
    private long startTime;
    private Color activeButtonColor = new Color(248, 229, 179);

    public JPlayer() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 6));
        this.setTitle("Screen Player");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (JPlayer.this.screenPlayer != null) {
                    JPlayer.this.screenPlayer.stop();
                }
                JPlayer.this.dispose();
            }
        });
        this.open = new JButton("Open Recording");
        this.open.setActionCommand("open");
        this.open.addActionListener(this);
        this.reset = new JButton("Reset");
        this.reset.setActionCommand("reset");
        this.reset.setEnabled(false);
        this.reset.addActionListener(this);
        this.play = new JButton("Play");
        this.play.setActionCommand("play");
        this.play.setEnabled(false);
        this.play.addActionListener(this);
        this.fastForward = new JButton("Fast Forward");
        this.fastForward.setActionCommand("fastForward");
        this.fastForward.setEnabled(false);
        this.fastForward.addActionListener(this);
        this.pause = new JButton("Pause");
        this.pause.setActionCommand("pause");
        this.pause.setEnabled(false);
        this.pause.addActionListener(this);
        this.stop = new JButton("Stop");
        this.stop.setActionCommand("stop");
        this.stop.setEnabled(false);
        this.stop.addActionListener(this);
        panel.add(this.open);
        panel.add(this.reset);
        panel.add(this.play);
        panel.add(this.fastForward);
        panel.add(this.pause);
        panel.add(this.stop);
        panel.doLayout();
        this.getContentPane().add((Component)panel, "North");
        panel = new JPanel();
        panel.setLayout(new GridLayout(1, 2));
        panel.setBackground(Color.black);
        this.frameLabel = new JLabel("Frame: 0 Time: 0");
        this.frameLabel.setBackground(Color.black);
        this.frameLabel.setForeground(Color.red);
        this.text = new JLabel("No recording selected");
        this.text.setBackground(Color.black);
        this.text.setForeground(Color.red);
        panel.add(this.text);
        panel.add(this.frameLabel);
        this.getContentPane().add((Component)panel, "South");
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("open")) {
            UIManager.put("FileChooser.readOnly", true);
            JFileChooser fileChooser = new JFileChooser();
            FileExtensionFilter filter = new FileExtensionFilter();
            filter = new FileExtensionFilter();
            filter.addExtension("cap");
            filter.setDescription("Screen Capture File");
            if (this.target != null) {
                fileChooser.setSelectedFile(new File(this.target));
            }
            fileChooser.setFileFilter(filter);
            fileChooser.showOpenDialog(this);
            if (fileChooser.getSelectedFile() != null) {
                this.target = fileChooser.getSelectedFile().getAbsolutePath();
                this.open();
            }
        } else if (ev.getActionCommand().equals("play")) {
            this.play();
        } else if (ev.getActionCommand().equals("reset")) {
            this.reset();
        } else if (ev.getActionCommand().equals("fastForward")) {
            this.fastForward();
        } else if (ev.getActionCommand().equals("pause")) {
            this.pause();
        } else if (ev.getActionCommand().equals("stop")) {
            this.stop();
        }
    }

    @Override
    public void playerPaused() {
        this.open.setEnabled(false);
        this.open.setBackground(null);
        this.reset.setEnabled(true);
        this.reset.setBackground(null);
        this.play.setEnabled(false);
        this.play.setBackground(null);
        this.fastForward.setEnabled(false);
        this.fastForward.setBackground(null);
        this.pause.setEnabled(false);
        this.pause.setBackground(null);
        this.stop.setEnabled(true);
        this.stop.setBackground(null);
        this.text.setText("Finished playing " + this.target);
    }

    @Override
    public void playerStopped() {
        this.stop();
    }

    @Override
    public void showNewImage(Image image) {
        if (this.icon == null) {
            this.icon = new ImageIcon(image);
            JLabel label = new JLabel(this.icon);
            JScrollPane scrollPane = new JScrollPane(label);
            scrollPane.setSize(image.getWidth(this), image.getHeight(this));
            this.getContentPane().add((Component)scrollPane, "Center");
            this.pack();
            this.setVisible(true);
        } else {
            this.icon.setImage(image);
        }
        this.repaint(0L);
    }

    @Override
    public void newFrame() {
        ++this.frameCount;
        long time = System.currentTimeMillis() - this.startTime;
        String seconds = "" + time / 1000L;
        String milliseconds = String.format("%04d", time % 1000L);
        this.frameLabel.setText("Frame: " + this.frameCount + " Time: " + seconds + "." + milliseconds);
    }

    public static void main(String[] args) {
        JPlayer viewer = new JPlayer();
        if (args.length == 1) {
            viewer.target = new File(args[0]).getAbsolutePath();
            viewer.open();
        }
    }

    public boolean open() {
        if (this.target != null) {
            try {
                this.screenPlayer = new ScreenPlayer(this.target, this);
                this.frameCount = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        this.open.setEnabled(false);
        this.open.setBackground(null);
        this.reset.setEnabled(true);
        this.reset.setBackground(null);
        this.play.setEnabled(true);
        this.play.setBackground(null);
        this.fastForward.setEnabled(true);
        this.fastForward.setBackground(null);
        this.pause.setEnabled(true);
        this.pause.setBackground(null);
        this.stop.setEnabled(true);
        this.stop.setBackground(null);
        this.text.setText("Ready to play " + this.target);
        return true;
    }

    public void reset() {
        this.open.setEnabled(false);
        this.open.setBackground(null);
        this.reset.setEnabled(true);
        this.reset.setBackground(null);
        this.play.setEnabled(true);
        this.play.setBackground(null);
        this.fastForward.setEnabled(true);
        this.fastForward.setBackground(null);
        this.pause.setEnabled(true);
        this.pause.setBackground(null);
        this.stop.setEnabled(true);
        this.stop.setBackground(null);
        this.frameCount = 0;
        this.startTime = System.currentTimeMillis();
        this.screenPlayer.reset();
        this.text.setText("Ready to play " + this.target);
    }

    public void play() {
        this.open.setEnabled(false);
        this.open.setBackground(null);
        this.reset.setEnabled(true);
        this.reset.setBackground(null);
        this.play.setEnabled(false);
        this.play.setBackground(this.activeButtonColor);
        this.fastForward.setEnabled(true);
        this.fastForward.setBackground(null);
        this.pause.setEnabled(true);
        this.pause.setBackground(null);
        this.stop.setEnabled(true);
        this.stop.setBackground(null);
        this.screenPlayer.play();
        this.startTime = System.currentTimeMillis();
        this.text.setText("Playing " + this.target);
    }

    public void fastForward() {
        this.open.setEnabled(false);
        this.open.setBackground(null);
        this.reset.setEnabled(false);
        this.reset.setBackground(null);
        this.play.setEnabled(true);
        this.play.setBackground(null);
        this.fastForward.setEnabled(false);
        this.fastForward.setBackground(this.activeButtonColor);
        this.pause.setEnabled(true);
        this.pause.setBackground(null);
        this.stop.setEnabled(true);
        this.stop.setBackground(null);
        this.screenPlayer.fastforward();
        this.text.setText("Fast Forward " + this.target);
    }

    public void pause() {
        this.open.setEnabled(false);
        this.open.setBackground(null);
        this.reset.setEnabled(true);
        this.reset.setBackground(null);
        this.play.setEnabled(true);
        this.play.setBackground(null);
        this.fastForward.setEnabled(true);
        this.fastForward.setBackground(null);
        this.pause.setEnabled(false);
        this.pause.setBackground(this.activeButtonColor);
        this.stop.setEnabled(true);
        this.stop.setBackground(null);
        this.screenPlayer.pause();
        this.text.setText("Paused " + this.target);
    }

    public void stop() {
        this.open.setEnabled(true);
        this.open.setBackground(null);
        this.reset.setEnabled(false);
        this.reset.setBackground(null);
        this.play.setEnabled(false);
        this.play.setBackground(null);
        this.fastForward.setEnabled(false);
        this.fastForward.setBackground(null);
        this.pause.setEnabled(false);
        this.pause.setBackground(null);
        this.stop.setEnabled(false);
        this.stop.setBackground(null);
        this.screenPlayer.stop();
        this.text.setText("No recording selected");
    }
}

