/*
 * Decompiled with CFR 0.152.
 */
package com.wet.wired.jsr.recorder;

import com.wet.wired.jsr.recorder.ScreenRecorder;
import com.wet.wired.jsr.recorder.ScreenRecorderListener;
import java.awt.AWTException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.net.URL;
import javax.imageio.ImageIO;

public class DesktopScreenRecorder
extends ScreenRecorder {
    public static boolean useWhiteCursor;
    private Robot robot;
    private BufferedImage mouseCursor;

    public DesktopScreenRecorder(OutputStream oStream, ScreenRecorderListener listener) {
        super(oStream, listener);
        try {
            String mouseCursorFile = useWhiteCursor ? "white_cursor.png" : "black_cursor.png";
            URL cursorURL = this.getClass().getClassLoader().getResource("mouse_cursors/" + mouseCursorFile);
            this.mouseCursor = ImageIO.read(cursorURL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Rectangle initialiseScreenCapture() {
        try {
            this.robot = new Robot();
        }
        catch (AWTException awe) {
            awe.printStackTrace();
            return null;
        }
        return new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
    }

    public Robot getRobot() {
        return this.robot;
    }

    @Override
    public BufferedImage captureScreen(Rectangle recordArea) {
        Point mousePosition = MouseInfo.getPointerInfo().getLocation();
        BufferedImage image = this.robot.createScreenCapture(recordArea);
        Graphics2D grfx = image.createGraphics();
        grfx.drawImage((Image)this.mouseCursor, mousePosition.x - 8, mousePosition.y - 5, null);
        grfx.dispose();
        return image;
    }
}

