/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class MP3Table {
    String dir;
    JTable tableView;
    TableModel dataModel;
    JPanel panel;
    Dimension origin = new Dimension(0, 0);
    final int INITIAL_ROWHEIGHT = 20;
    int filecount = 0;
    int dircount = 0;
    Vector mp3files;

    public static void main(String[] stringArray) {
        MP3Table mP3Table = new MP3Table();
        JTable jTable = mP3Table.createTable(stringArray[0]);
        JFrame jFrame = new JFrame("TESTING");
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)jScrollPane, "Center");
        jFrame.pack();
        jFrame.show();
    }

    public JTable getTable() {
        return this.tableView;
    }

    public JTable createTable(String string) {
        final String[] stringArray = new String[]{"Display Name (on cover)", "", "Filename", "ID3 Artist", "ID3 Trackname", "Size", "Time"};
        ImageIcon imageIcon = this.createImageIcon("mp3.gif", "File Icon");
        final ImageIcon imageIcon2 = this.createImageIcon("less48.gif", "MP3 Icon");
        final ImageIcon imageIcon3 = this.createImageIcon("48.gif", "MP3 Icon");
        final ImageIcon imageIcon4 = this.createImageIcon("56.gif", "MP3 Icon");
        final ImageIcon imageIcon5 = this.createImageIcon("64.gif", "MP3 Icon");
        final ImageIcon imageIcon6 = this.createImageIcon("96.gif", "MP3 Icon");
        final ImageIcon imageIcon7 = this.createImageIcon("112.gif", "MP3 Icon");
        final ImageIcon imageIcon8 = this.createImageIcon("128.gif", "MP3 Icon");
        final ImageIcon imageIcon9 = this.createImageIcon("160.gif", "MP3 Icon");
        final ImageIcon imageIcon10 = this.createImageIcon("192.gif", "192 Icon");
        final ImageIcon imageIcon11 = this.createImageIcon("256.gif", "MP3 Icon");
        final ImageIcon imageIcon12 = this.createImageIcon("yellowfolder-16.gif", "Folder Icon");
        MP3CD mP3CD = new MP3CD(string);
        Date date = new Date();
        System.out.println("Starting scan at " + date);
        this.mp3files = mP3CD.beginFindAllMP3Files(string);
        this.dircount = mP3CD.getDirCount();
        this.filecount = mP3CD.getFileCount();
        date = new Date();
        System.out.println("Finished scan at " + date + "\n");
        this.dataModel = new AbstractTableModel(){

            public int getColumnCount() {
                return stringArray.length;
            }

            public int getRowCount() {
                return MP3Table.this.mp3files.size();
            }

            public String getColumnName(int n) {
                return stringArray[n];
            }

            public Class getColumnClass(int n) {
                if (n == 1) {
                    return imageIcon12.getClass();
                }
                return "test".getClass();
            }

            public boolean isCellEditable(int n, int n2) {
                return n2 == 0;
            }

            public void setValueAt(Object object, int n, int n2) {
                MP3Object mP3Object = (MP3Object)MP3Table.this.mp3files.elementAt(n);
                mP3Object.setDisplayString((String)object);
                MP3Table.this.setMP3Object(mP3Object, n);
                this.fireTableCellUpdated(n, n2);
            }

            public Object getValueAt(int n, int n2) {
                MP3Object mP3Object = (MP3Object)MP3Table.this.mp3files.elementAt(n);
                if (n2 == 0) {
                    return mP3Object.getDisplayString();
                }
                if (n2 == 1) {
                    int n3 = mP3Object.getType();
                    if (n3 == 0) {
                        int n4 = mP3Object.getBitrate();
                        return this.getIcon(n4);
                    }
                    return imageIcon12;
                }
                if (n2 == 2) {
                    return mP3Object.getFilename();
                }
                if (n2 == 3) {
                    int n5 = mP3Object.getType();
                    if (n5 == 1) {
                        return "";
                    }
                    String string = mP3Object.getID3Artist();
                    if (string == null || string.equals("???") || string.equals("")) {
                        string = mP3Object.getUseID3() ? "<HTML><font color=red>???</font></HTML>" : "???";
                    }
                    return string;
                }
                if (n2 == 4) {
                    int n6 = mP3Object.getType();
                    if (n6 == 1) {
                        return " ";
                    }
                    String string = mP3Object.getID3Trackname();
                    if (string == null || string.equals("???") || string.equals("")) {
                        string = mP3Object.getUseID3() ? "<HTML><font color=red>???</font></HTML>" : "???";
                    }
                    return string;
                }
                if (n2 == 5) {
                    return mP3Object.getSize();
                }
                if (n2 == 6) {
                    return mP3Object.getPlaytime();
                }
                return "TEMP";
            }

            private ImageIcon getIcon(int n) {
                if (n < 48) {
                    return imageIcon2;
                }
                if (n < 56) {
                    return imageIcon3;
                }
                if (n < 64) {
                    return imageIcon4;
                }
                if (n < 96) {
                    return imageIcon5;
                }
                if (n < 112) {
                    return imageIcon6;
                }
                if (n < 128) {
                    return imageIcon7;
                }
                if (n < 160) {
                    return imageIcon8;
                }
                if (n < 192) {
                    return imageIcon9;
                }
                if (n < 255) {
                    return imageIcon10;
                }
                return imageIcon11;
            }
        };
        this.tableView = new JTable(this.dataModel);
        this.tableView.setDragEnabled(true);
        TableColumnModel tableColumnModel = this.tableView.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellRenderer(new DisplayStringRenderer());
        tableColumn.setMinWidth(150);
        TableColumn tableColumn2 = tableColumnModel.getColumn(1);
        tableColumn2.setPreferredWidth(18);
        tableColumnModel.getColumn(5).setPreferredWidth(40);
        tableColumnModel.getColumn(6).setPreferredWidth(40);
        int n = 20;
        this.tableView.setRowHeight(20);
        return this.tableView;
    }

    public String getString(String string) {
        return string;
    }

    public ImageIcon createImageIcon(String string, String string2) {
        String string3 = "/images/" + string;
        return new ImageIcon(this.getClass().getResource(string3), string2);
    }

    public Vector getMP3Vector() {
        return this.mp3files;
    }

    public int getMP3VectorSize() {
        return this.mp3files.size();
    }

    public int[] getSelectedRows() {
        return this.tableView.getSelectedRows();
    }

    public int getDirCount() {
        return this.dircount;
    }

    public int getFileCount() {
        return this.filecount;
    }

    public void setMP3Objects(MP3Object[] mP3ObjectArray, int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.mp3files.setElementAt(mP3ObjectArray[n], nArray[n]);
            this.tableView.tableChanged(new TableModelEvent(this.dataModel, nArray[n]));
            ++n;
        }
    }

    public MP3Object getMP3Object(int n) {
        return (MP3Object)this.mp3files.elementAt(n);
    }

    public void setMP3Object(MP3Object mP3Object, int n) {
        this.mp3files.setElementAt(mP3Object, n);
        this.tableView.tableChanged(new TableModelEvent(this.dataModel, n));
    }

    class DisplayStringRenderer
    implements TableCellRenderer {
        Font tempfont = UIManager.getFont("Label.font");
        String fontName = this.tempfont.getName();
        int fontSize = this.tempfont.getSize();
        Font plainFont = new Font(this.fontName, 0, this.fontSize);

        DisplayStringRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            MP3Object mP3Object = (MP3Object)MP3Table.this.mp3files.elementAt(n);
            if (mP3Object.getType() == 0) {
                String string = mP3Object.getDisplayString();
                JLabel jLabel = new JLabel(string);
                jLabel.setFont(this.plainFont);
                if (string.indexOf("???") != -1) {
                    jLabel.setForeground(Color.red);
                }
                if (bl) {
                    jLabel.setBackground(Color.green);
                }
                return jLabel;
            }
            return new JLabel(mP3Object.getDisplayString());
        }
    }

    class LabelRenderer
    implements TableCellRenderer {
        LabelRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ImageIcon imageIcon = MP3Table.this.createImageIcon("mp3.gif", "File Icon");
            ImageIcon imageIcon2 = MP3Table.this.createImageIcon("192.gif", "File Icon");
            ImageIcon imageIcon3 = MP3Table.this.createImageIcon("yellowfolder-16.gif", "Folder Icon");
            JLabel jLabel = new JLabel("<48kbps", imageIcon, 0);
            JLabel jLabel2 = new JLabel("48kbps", imageIcon, 0);
            JLabel jLabel3 = new JLabel("56kbps", imageIcon, 0);
            JLabel jLabel4 = new JLabel("64kbps", imageIcon, 0);
            JLabel jLabel5 = new JLabel("96kbps", imageIcon, 0);
            JLabel jLabel6 = new JLabel("112kbps", imageIcon, 0);
            JLabel jLabel7 = new JLabel("128kbps", imageIcon, 0);
            JLabel jLabel8 = new JLabel("160kbps", imageIcon, 0);
            JLabel jLabel9 = new JLabel(imageIcon2);
            JLabel jLabel10 = new JLabel("256kbps", imageIcon, 0);
            JLabel jLabel11 = new JLabel(imageIcon3);
            JLabel jLabel12 = new JLabel(imageIcon);
            MP3Object mP3Object = (MP3Object)MP3Table.this.mp3files.elementAt(n);
            if (mP3Object.getType() == 0) {
                int n3 = mP3Object.getBitrate();
                if (n3 < 48) {
                    return jLabel;
                }
                if (n3 < 56) {
                    return jLabel2;
                }
                if (n3 < 64) {
                    return jLabel3;
                }
                if (n3 < 96) {
                    return jLabel4;
                }
                if (n3 < 112) {
                    return jLabel5;
                }
                if (n3 < 128) {
                    return jLabel6;
                }
                if (n3 < 160) {
                    return jLabel7;
                }
                if (n3 < 192) {
                    return jLabel8;
                }
                if (n3 < 255) {
                    return jLabel9;
                }
                return jLabel10;
            }
            return jLabel11;
        }
    }

    class ColumnLayout
    implements LayoutManager {
        int xInset = 5;
        int yInset = 5;
        int yGap = 2;

        ColumnLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Insets insets = container.getInsets();
            int n = this.yInset + insets.top;
            Component[] componentArray = container.getComponents();
            Dimension dimension = null;
            int n2 = 0;
            while (n2 < componentArray.length) {
                dimension = componentArray[n2].getPreferredSize();
                componentArray[n2].setSize(dimension.width, dimension.height);
                componentArray[n2].setLocation(this.xInset + insets.left, n);
                n += dimension.height + this.yGap;
                ++n2;
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            Insets insets = container.getInsets();
            int n = this.yInset + insets.top;
            int n2 = 0 + insets.left + insets.right;
            Component[] componentArray = container.getComponents();
            Dimension dimension = null;
            int n3 = 0;
            while (n3 < componentArray.length) {
                dimension = componentArray[n3].getPreferredSize();
                n += dimension.height + this.yGap;
                n2 = Math.max(n2, dimension.width + insets.left + insets.right + this.xInset * 2);
                ++n3;
            }
            return new Dimension(n2, n += insets.bottom);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

