/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.net;

import de.sciss.net.OSCPacket;
import java.util.ArrayList;
import java.util.List;

public class OSCBundle
extends OSCPacket {
    public static final String TAG = "#bundle";
    public static final long NOW = 1L;
    private static final long SECONDS_FROM_1900_TO_1970 = 2208988800L;
    private long timetag;
    protected final List<OSCPacket> collPackets = new ArrayList<OSCPacket>();

    public OSCBundle() {
        this.timetag = 1L;
    }

    public OSCBundle(long l) {
        this.setTimeTagAbsMillis(l);
    }

    public OSCBundle(double d) {
        this.setTimeTagRelSecs(d);
    }

    public OSCBundle(long l, long l2, int n) {
        this.setTimeTagSamples(l, l2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacket(OSCPacket oSCPacket) {
        if (oSCPacket != null) {
            List<OSCPacket> list = this.collPackets;
            synchronized (list) {
                this.collPackets.add(oSCPacket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSCPacket getPacket(int n) {
        List<OSCPacket> list = this.collPackets;
        synchronized (list) {
            return this.collPackets.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPacketCount() {
        List<OSCPacket> list = this.collPackets;
        synchronized (list) {
            return this.collPackets.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePacket(int n) {
        List<OSCPacket> list = this.collPackets;
        synchronized (list) {
            this.collPackets.remove(n);
        }
    }

    public void setTimeTagAbsMillis(long l) {
        long l2 = l / 1000L + 2208988800L;
        long l3 = (l % 1000L << 32) / 1000L;
        this.timetag = l2 << 32 | l3;
    }

    public void setTimeTagRaw(long l) {
        this.timetag = l;
    }

    public void setTimeTagRelSecs(double d) {
        this.timetag = ((long)d << 32) + (long)(d % 1.0 * 4.294967296E9 + 0.5);
    }

    public void setTimeTagSamples(long l, long l2, int n) {
        double d = (double)l2 / (double)n + (double)l / 1000.0;
        this.timetag = ((long)d + 2208988800L << 32) + (long)(d % 1.0 * 4.294967296E9 + 0.5);
    }

    public long getTimeTag() {
        return this.timetag;
    }
}

