/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.net;

import de.sciss.net.OSCBundle;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCPacketCodec;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;

public abstract class OSCPacket {
    private static final byte[] hex = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    protected OSCPacket() {
    }

    public final int getSize() throws IOException {
        return this.getSize(OSCPacketCodec.getDefaultCodec());
    }

    public final int getSize(OSCPacketCodec oSCPacketCodec) throws IOException {
        return oSCPacketCodec.getSize(this);
    }

    public final void encode(ByteBuffer byteBuffer) throws IOException {
        this.encode(OSCPacketCodec.getDefaultCodec(), byteBuffer);
    }

    public final void encode(OSCPacketCodec oSCPacketCodec, ByteBuffer byteBuffer) throws IOException {
        oSCPacketCodec.encode(this, byteBuffer);
    }

    public static OSCPacket decode(ByteBuffer byteBuffer) throws IOException {
        return OSCPacketCodec.getDefaultCodec().decode(byteBuffer);
    }

    public static void printTextOn(PrintStream printStream, OSCPacket oSCPacket) {
        OSCPacket.printTextOn(printStream, oSCPacket, 0);
    }

    public static void printHexOn(PrintStream printStream, ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.limit();
        byte[] byArray = new byte[74];
        for (n = 4; n < 56; ++n) {
            byArray[n] = 32;
        }
        byArray[56] = 124;
        printStream.println();
        n = byteBuffer.position();
        while (n < n2) {
            int n3 = 0;
            byArray[n3++] = hex[n >> 12 & 0xF];
            byArray[n3++] = hex[n >> 8 & 0xF];
            byArray[n3++] = hex[n >> 4 & 0xF];
            byArray[n3++] = hex[n & 0xF];
            int n4 = 57;
            for (int i = 0; i < 16 && n < n2; ++i, ++n) {
                if ((i & 7) == 0) {
                    n3 += 2;
                }
                byte by = byteBuffer.get();
                int n5 = ++n3;
                byArray[n5] = hex[by >> 4 & 0xF];
                int n6 = ++n3;
                ++n3;
                byArray[n6] = hex[by & 0xF];
                byArray[n4++] = by > 31 && by < 127 ? (int)by : 46;
            }
            byArray[n4++] = 124;
            while (n3 < 54) {
                byArray[n3++] = 32;
            }
            while (n4 < 74) {
                byArray[n4++] = 32;
            }
            printStream.write(byArray, 0, 74);
            printStream.println();
        }
        printStream.println();
    }

    private static void printTextOn(PrintStream printStream, OSCPacket oSCPacket, int n) {
        if (oSCPacket instanceof OSCMessage) {
            int n2;
            OSCMessage oSCMessage = (OSCMessage)oSCPacket;
            for (n2 = 0; n2 < n; ++n2) {
                printStream.print("  ");
            }
            printStream.print("[ \"" + oSCMessage.getName() + "\"");
            for (n2 = 0; n2 < oSCMessage.getArgCount(); ++n2) {
                Object object = oSCMessage.getArg(n2);
                if (object instanceof Number) {
                    if (object instanceof Float || object instanceof Double) {
                        printStream.print(", " + ((Number)object).floatValue());
                        continue;
                    }
                    printStream.print(", " + ((Number)object).longValue());
                    continue;
                }
                if (object instanceof OSCPacket) {
                    printStream.println(",");
                    OSCPacket.printTextOn(printStream, (OSCPacket)object, n + 1);
                    continue;
                }
                if (object instanceof byte[]) {
                    printStream.print(", DATA[" + ((byte[])object).length + "]");
                    continue;
                }
                printStream.print(", \"" + object.toString() + "\"");
            }
            printStream.print(" ]");
        } else {
            int n3;
            OSCBundle oSCBundle = (OSCBundle)oSCPacket;
            for (n3 = 0; n3 < n; ++n3) {
                printStream.print("  ");
            }
            printStream.print("[ \"#bundle\"");
            for (n3 = 0; n3 < oSCBundle.getPacketCount(); ++n3) {
                printStream.println(",");
                OSCPacket.printTextOn(printStream, oSCBundle.getPacket(n3), n + 1);
            }
            for (n3 = 0; n3 < n; ++n3) {
                printStream.print("  ");
            }
            printStream.print("]");
        }
        if (n == 0) {
            printStream.println();
        }
    }
}

