/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.net;

import de.sciss.net.OSCBundle;
import de.sciss.net.OSCException;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCPacket;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.List;

public class OSCPacketCodec {
    private static final OSCPacketCodec defaultCodec = new OSCPacketCodec();
    public static final int MODE_READ_DOUBLE = 1;
    public static final int MODE_READ_DOUBLE_AS_FLOAT = 2;
    private static final int MODE_READ_DOUBLE_MASK = 3;
    public static final int MODE_READ_LONG = 4;
    public static final int MODE_READ_LONG_AS_INTEGER = 8;
    private static final int MODE_READ_LONG_MASK = 12;
    public static final int MODE_WRITE_DOUBLE = 16;
    public static final int MODE_WRITE_DOUBLE_AS_FLOAT = 32;
    private static final int MODE_WRITE_DOUBLE_MASK = 48;
    public static final int MODE_WRITE_LONG = 64;
    public static final int MODE_WRITE_LONG_AS_INTEGER = 128;
    private static final int MODE_WRITE_LONG_MASK = 192;
    public static final int MODE_READ_SYMBOL_AS_STRING = 256;
    public static final int MODE_WRITE_PACKET_AS_BLOB = 512;
    public static final int MODE_STRICT_V1 = 0;
    public static final int MODE_MODEST = 938;
    public static final int MODE_GRACEFUL = 933;
    public static final int MODE_FAT_V1 = 853;
    private final Atom[] atomDecoders = new Atom[128];
    private final Class[] atomEncoderC = new Class[128];
    private final Atom[] atomEncoderA = new Atom[128];
    protected String charsetName;
    private static final byte[] bndlIdentifier = new byte[]{35, 98, 117, 110, 100, 108, 101, 0};
    private static final byte[] pad = new byte[4];

    public OSCPacketCodec() {
        this(933);
    }

    public OSCPacketCodec(int n) {
        this(n, "UTF-8");
    }

    public OSCPacketCodec(int n, String string) {
        Atom atom;
        int n2 = 0;
        this.atomDecoders[atom.getTypeTag(null)] = atom = new IntegerAtom();
        this.atomEncoderC[n2] = Integer.class;
        this.atomEncoderA[n2++] = atom;
        this.atomDecoders[atom.getTypeTag(null)] = atom = new FloatAtom();
        this.atomEncoderC[n2] = Float.class;
        this.atomEncoderA[n2++] = atom;
        this.atomDecoders[atom.getTypeTag(null)] = atom = new StringAtom();
        this.atomEncoderC[n2] = String.class;
        this.atomEncoderA[n2++] = atom;
        this.atomDecoders[atom.getTypeTag(null)] = atom = new BlobAtom();
        this.atomEncoderC[n2] = byte[].class;
        this.atomEncoderA[n2++] = atom;
        this.setStringCharsetCodec(string);
        this.setSupportMode(n);
    }

    public static OSCPacketCodec getDefaultCodec() {
        return defaultCodec;
    }

    public void setStringCharsetCodec(String string) {
        this.charsetName = string;
    }

    public void putDecoder(byte by, Atom atom) {
        this.atomDecoders[by] = atom;
    }

    public void putEncoder(Class clazz, Atom atom) {
        int n = 0;
        while (this.atomEncoderC[n] != clazz && this.atomEncoderC[n] != null) {
            ++n;
        }
        if (atom != null) {
            this.atomEncoderC[n] = clazz;
            this.atomEncoderA[n] = atom;
        } else if (this.atomEncoderC[n] != null) {
            int n2 = n + 1;
            while (this.atomEncoderC[n2] != null) {
                ++n2;
            }
            System.arraycopy(this.atomEncoderC, n + 1, this.atomEncoderC, n, n2 - n);
            System.arraycopy(this.atomEncoderA, n + 1, this.atomEncoderA, n, n2 - n);
        }
    }

    public void setSupportMode(int n) {
        switch (n & 3) {
            case 0: {
                this.atomDecoders[100] = null;
                break;
            }
            case 1: {
                this.atomDecoders[100] = new DoubleAtom();
                break;
            }
            case 2: {
                this.atomDecoders[100] = new DoubleAsFloatAtom();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        switch (n & 0xC) {
            case 0: {
                this.atomDecoders[104] = null;
                break;
            }
            case 4: {
                this.atomDecoders[104] = new LongAtom();
                break;
            }
            case 8: {
                this.atomDecoders[104] = new LongAsIntegerAtom();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        switch (n & 0x30) {
            case 0: {
                this.putEncoder(Double.class, null);
                break;
            }
            case 16: {
                this.putEncoder(Double.class, new DoubleAtom());
                break;
            }
            case 32: {
                this.putEncoder(Double.class, new DoubleAsFloatAtom());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        switch (n & 0xC0) {
            case 0: {
                this.putEncoder(Long.class, null);
                break;
            }
            case 64: {
                this.putEncoder(Long.class, new LongAtom());
                break;
            }
            case 128: {
                this.putEncoder(Long.class, new LongAsIntegerAtom());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.atomDecoders[83] = (n & 0x100) != 0 ? new StringAtom() : null;
        if ((n & 0x200) != 0) {
            PacketAtom packetAtom = new PacketAtom();
            this.putEncoder(OSCBundle.class, packetAtom);
            this.putEncoder(OSCMessage.class, packetAtom);
        } else {
            this.putEncoder(OSCBundle.class, null);
            this.putEncoder(OSCMessage.class, null);
        }
    }

    public OSCPacket decode(ByteBuffer byteBuffer) throws IOException {
        String string = OSCPacketCodec.readString(byteBuffer);
        OSCPacketCodec.skipToAlign(byteBuffer);
        if (string.equals("#bundle")) {
            return this.decodeBundle(byteBuffer);
        }
        return this.decodeMessage(string, byteBuffer);
    }

    public void encode(OSCPacket oSCPacket, ByteBuffer byteBuffer) throws IOException {
        if (oSCPacket instanceof OSCBundle) {
            this.encodeBundle((OSCBundle)oSCPacket, byteBuffer);
        } else {
            this.encodeMessage((OSCMessage)oSCPacket, byteBuffer);
        }
    }

    public int getSize(OSCPacket oSCPacket) throws IOException {
        if (oSCPacket instanceof OSCBundle) {
            return this.getBundleSize((OSCBundle)oSCPacket);
        }
        return this.getMessageSize((OSCMessage)oSCPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getBundleSize(OSCBundle oSCBundle) throws IOException {
        List<OSCPacket> list = oSCBundle.collPackets;
        synchronized (list) {
            int n = bndlIdentifier.length + 8 + (oSCBundle.collPackets.size() << 2);
            for (int i = 0; i < oSCBundle.collPackets.size(); ++i) {
                n += this.getSize(oSCBundle.collPackets.get(i));
            }
            return n;
        }
    }

    protected int getMessageSize(OSCMessage oSCMessage) throws IOException {
        int n = oSCMessage.getArgCount();
        int n2 = (oSCMessage.getName().length() + 4 & 0xFFFFFFFC) + (1 + n + 4 & 0xFFFFFFFC);
        for (int i = 0; i < n; ++i) {
            Object object = oSCMessage.getArg(i);
            Class<?> clazz = object.getClass();
            int n3 = 0;
            try {
                while (this.atomEncoderC[n3] != clazz) {
                    ++n3;
                }
                n2 += this.atomEncoderA[n3].getAtomSize(object);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new OSCException(5, clazz.getName());
            }
        }
        return n2;
    }

    protected OSCBundle decodeBundle(ByteBuffer byteBuffer) throws IOException {
        OSCBundle oSCBundle = new OSCBundle();
        int n = byteBuffer.limit();
        oSCBundle.setTimeTagRaw(byteBuffer.getLong());
        try {
            while (byteBuffer.hasRemaining()) {
                byteBuffer.limit(byteBuffer.getInt() + byteBuffer.position());
                oSCBundle.addPacket(this.decode(byteBuffer));
                byteBuffer.limit(n);
            }
            return oSCBundle;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OSCException(3, illegalArgumentException.getLocalizedMessage());
        }
    }

    protected OSCMessage decodeMessage(String string, ByteBuffer byteBuffer) throws IOException {
        byte by = 0;
        if (byteBuffer.get() != 44) {
            throw new OSCException(3, null);
        }
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        int n = byteBuffer.position();
        while (byteBuffer.get() != 0) {
        }
        int n2 = byteBuffer.position() - n - 1;
        Object[] objectArray = new Object[n2];
        OSCPacketCodec.skipToAlign(byteBuffer);
        try {
            for (int i = 0; i < n2; ++i) {
                by = byteBuffer2.get();
                objectArray[i] = this.atomDecoders[by].decodeAtom(by, byteBuffer);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new OSCException(4, String.valueOf((char)by));
        }
        return new OSCMessage(string, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodeBundle(OSCBundle oSCBundle, ByteBuffer byteBuffer) throws IOException {
        byteBuffer.put(bndlIdentifier).putLong(oSCBundle.getTimeTag());
        List<OSCPacket> list = oSCBundle.collPackets;
        synchronized (list) {
            for (int i = 0; i < oSCBundle.collPackets.size(); ++i) {
                byteBuffer.mark();
                byteBuffer.putInt(0);
                int n = byteBuffer.position();
                this.encode(oSCBundle.collPackets.get(i), byteBuffer);
                int n2 = byteBuffer.position();
                byteBuffer.reset();
                byteBuffer.putInt(n2 - n).position(n2);
            }
        }
    }

    protected void encodeMessage(OSCMessage oSCMessage, ByteBuffer byteBuffer) throws BufferOverflowException, IOException {
        int n = oSCMessage.getArgCount();
        Object object = null;
        Class<?> clazz = null;
        Atom atom = null;
        byteBuffer.put(oSCMessage.getName().getBytes());
        OSCPacketCodec.terminateAndPadToAlign(byteBuffer);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.put((byte)44);
        byteBuffer.position(byteBuffer.position() + (n + 5 & 0xFFFFFFFC));
        try {
            for (int i = 0; i < n; ++i) {
                object = oSCMessage.getArg(i);
                clazz = object.getClass();
                int n2 = 0;
                while (this.atomEncoderC[n2] != clazz) {
                    ++n2;
                }
                atom = this.atomEncoderA[n2];
                atom.encodeAtom(object, byteBuffer2, byteBuffer);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new OSCException(5, object == null ? "null" : (clazz == null ? "null" : clazz.getName()));
        }
        OSCPacketCodec.terminateAndPadToAlign(byteBuffer2);
    }

    public static String readString(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        while (byteBuffer.get() != 0) {
        }
        int n2 = byteBuffer.position() - n;
        byte[] byArray = new byte[n2];
        byteBuffer.position(n);
        byteBuffer.get(byArray);
        return new String(byArray, 0, n2 - 1);
    }

    public static void terminateAndPadToAlign(ByteBuffer byteBuffer) {
        byteBuffer.put(pad, 0, 4 - (byteBuffer.position() & 3));
    }

    public static void padToAlign(ByteBuffer byteBuffer) {
        byteBuffer.put(pad, 0, -byteBuffer.position() & 3);
    }

    public static void skipToValues(ByteBuffer byteBuffer) throws BufferUnderflowException {
        while (byteBuffer.get() != 0) {
        }
        byteBuffer.position(byteBuffer.position() + 3 & 0xFFFFFFFC);
    }

    public static void skipToAlign(ByteBuffer byteBuffer) {
        byteBuffer.position(byteBuffer.position() + 3 & 0xFFFFFFFC);
    }

    private class PacketAtom
    extends Atom {
        protected PacketAtom() {
        }

        @Override
        public Object decodeAtom(byte by, ByteBuffer byteBuffer) throws IOException {
            throw new IOException("Not supported");
        }

        @Override
        public void encodeAtom(Object object, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
            byteBuffer.put((byte)98);
            int n = byteBuffer2.position();
            int n2 = n + 4;
            byteBuffer2.position(n2);
            OSCPacketCodec.this.encode((OSCPacket)object, byteBuffer2);
            byteBuffer2.putInt(n, byteBuffer2.position() - n2);
        }

        @Override
        public byte getTypeTag(Object object) {
            return 98;
        }

        @Override
        public int getAtomSize(Object object) throws IOException {
            return OSCPacketCodec.this.getSize((OSCPacket)object) + 4;
        }
    }

    private class BlobAtom
    extends Atom {
        protected BlobAtom() {
        }

        @Override
        public Object decodeAtom(byte by, ByteBuffer byteBuffer) throws IOException {
            byte[] byArray = new byte[byteBuffer.getInt()];
            byteBuffer.get(byArray);
            OSCPacketCodec.skipToAlign(byteBuffer);
            return byArray;
        }

        @Override
        public void encodeAtom(Object object, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
            byte[] byArray = (byte[])object;
            byteBuffer.put((byte)98);
            byteBuffer2.putInt(byArray.length);
            byteBuffer2.put(byArray);
            OSCPacketCodec.padToAlign(byteBuffer2);
        }

        @Override
        public byte getTypeTag(Object object) {
            return 98;
        }

        @Override
        public int getAtomSize(Object object) throws IOException {
            return ((byte[])object).length + 7 & 0xFFFFFFFC;
        }
    }

    private class StringAtom
    extends Atom {
        protected StringAtom() {
        }

        @Override
        public Object decodeAtom(byte by, ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.position();
            while (byteBuffer.get() != 0) {
            }
            int n2 = byteBuffer.position() - 1;
            byteBuffer.position(n);
            int n3 = n2 - n;
            byte[] byArray = new byte[n3];
            byteBuffer.get(byArray, 0, n3);
            String string = new String(byArray, OSCPacketCodec.this.charsetName);
            byteBuffer.position(n2 + 4 & 0xFFFFFFFC);
            return string;
        }

        @Override
        public void encodeAtom(Object object, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
            byteBuffer.put((byte)115);
            String string = (String)object;
            byteBuffer2.put(string.getBytes(OSCPacketCodec.this.charsetName));
            OSCPacketCodec.terminateAndPadToAlign(byteBuffer2);
        }

        @Override
        public byte getTypeTag(Object object) {
            return 115;
        }

        @Override
        public int getAtomSize(Object object) throws IOException {
            String string = (String)object;
            return string.getBytes(OSCPacketCodec.this.charsetName).length + 4 & 0xFFFFFFFC;
        }
    }

    private class LongAsIntegerAtom
    extends Atom {
        protected LongAsIntegerAtom() {
        }

        @Override
        public Object decodeAtom(byte by, ByteBuffer byteBuffer) throws IOException {
            return (int)byteBuffer.getLong();
        }

        @Override
        public void encodeAtom(Object object, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
            byteBuffer.put((byte)105);
            byteBuffer2.putInt(((Long)object).intValue());
        }

        @Override
        public byte getTypeTag(Object object) {
            return 105;
        }

        @Override
        public int getAtomSize(Object object) throws IOException {
            return 4;
        }
    }

    private class DoubleAsFloatAtom
    extends Atom {
        protected DoubleAsFloatAtom() {
        }

        @Override
        public Object decodeAtom(byte by, ByteBuffer byteBuffer) throws IOException {
            return Float.valueOf((float)byteBuffer.getDouble());
        }

        @Override
        public void encodeAtom(Object object, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
            byteBuffer.put((byte)102);
            byteBuffer2.putFloat(((Double)object).floatValue());
        }

        @Override
        public byte getTypeTag(Object object) {
            return 102;
        }

        @Override
        public int getAtomSize(Object object) throws IOException {
            return 4;
        }
    }

    private class DoubleAtom
    extends Atom {
        protected DoubleAtom() {
        }

        @Override
        public Object decodeAtom(byte by, ByteBuffer byteBuffer) throws IOException {
            return byteBuffer.getDouble();
        }

        @Override
        public void encodeAtom(Object object, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
            byteBuffer.put((byte)100);
            byteBuffer2.putDouble((Double)object);
        }

        @Override
        public byte getTypeTag(Object object) {
            return 100;
        }

        @Override
        public int getAtomSize(Object object) throws IOException {
            return 8;
        }
    }

    private class LongAtom
    extends Atom {
        protected LongAtom() {
        }

        @Override
        public Object decodeAtom(byte by, ByteBuffer byteBuffer) throws IOException {
            return byteBuffer.getLong();
        }

        @Override
        public void encodeAtom(Object object, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
            byteBuffer.put((byte)104);
            byteBuffer2.putLong((Long)object);
        }

        @Override
        public byte getTypeTag(Object object) {
            return 104;
        }

        @Override
        public int getAtomSize(Object object) throws IOException {
            return 8;
        }
    }

    private class FloatAtom
    extends Atom {
        protected FloatAtom() {
        }

        @Override
        public Object decodeAtom(byte by, ByteBuffer byteBuffer) throws IOException {
            return Float.valueOf(byteBuffer.getFloat());
        }

        @Override
        public void encodeAtom(Object object, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
            byteBuffer.put((byte)102);
            byteBuffer2.putFloat(((Float)object).floatValue());
        }

        @Override
        public byte getTypeTag(Object object) {
            return 102;
        }

        @Override
        public int getAtomSize(Object object) throws IOException {
            return 4;
        }
    }

    private class IntegerAtom
    extends Atom {
        protected IntegerAtom() {
        }

        @Override
        public Object decodeAtom(byte by, ByteBuffer byteBuffer) throws IOException {
            return byteBuffer.getInt();
        }

        @Override
        public void encodeAtom(Object object, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
            byteBuffer.put((byte)105);
            byteBuffer2.putInt((Integer)object);
        }

        @Override
        public byte getTypeTag(Object object) {
            return 105;
        }

        @Override
        public int getAtomSize(Object object) throws IOException {
            return 4;
        }
    }

    public static abstract class Atom {
        public abstract Object decodeAtom(byte var1, ByteBuffer var2) throws IOException;

        public abstract void encodeAtom(Object var1, ByteBuffer var2, ByteBuffer var3) throws IOException;

        public abstract byte getTypeTag(Object var1);

        public abstract int getAtomSize(Object var1) throws IOException;
    }
}

