/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.button;

import com.alee.extended.button.AdaptiveSplitButtonPainter;
import com.alee.extended.button.ISplitButtonPainter;
import com.alee.extended.button.SplitButtonPainter;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.swing.DataRunnable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class WebSplitButtonUI
extends BasicButtonUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport,
SwingConstants {
    @DefaultPainter(value=SplitButtonPainter.class)
    protected ISplitButtonPainter painter;
    protected AbstractButton button = null;
    protected Insets margin = null;
    protected Insets padding = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebSplitButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.button = (AbstractButton)c;
        StyleManager.installSkin(this.button);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.button);
        this.button = null;
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.button);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.button, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.button, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public boolean isOnSplit() {
        return this.painter != null && this.painter.isOnSplit();
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.button, new DataRunnable<ISplitButtonPainter>(){

            public void run(ISplitButtonPainter newPainter) {
                WebSplitButtonUI.this.painter = newPainter;
            }
        }, this.painter, painter, ISplitButtonPainter.class, AdaptiveSplitButtonPainter.class);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c), this.painter);
    }
}

