/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.colorchooser;

import com.alee.extended.colorchooser.DoubleColorFieldListener;
import com.alee.laf.colorchooser.HSBColor;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.language.LanguageAdapter;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageManager;
import com.alee.utils.CollectionUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class DoubleColorField
extends WebPanel {
    private final List<DoubleColorFieldListener> listeners = new ArrayList<DoubleColorFieldListener>(1);
    private Color newColor;
    private Color oldColor;
    private HSBColor newHSBColor;
    private HSBColor oldHSBColor;

    public DoubleColorField() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (e.getY() <= DoubleColorField.this.getHeight() / 2) {
                        DoubleColorField.this.newColorPressed();
                    } else {
                        DoubleColorField.this.oldColorPressed();
                    }
                }
            }
        });
        LanguageManager.addLanguageListener((LanguageListener)new LanguageAdapter(){

            public void languageUpdated() {
                DoubleColorField.this.repaint();
                DoubleColorField.this.revalidate();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        FontMetrics fm = g2d.getFontMetrics();
        Map hints = SwingUtils.setupTextAntialias(g2d);
        g2d.setPaint(Color.GRAY);
        g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g2d.setPaint(Color.WHITE);
        g2d.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
        g2d.setPaint(this.newColor);
        g2d.fillRect(2, 2, this.getWidth() - 4, this.getHeight() / 2 - 2);
        String newText = LanguageManager.get((String)"weblaf.colorchooser.color.new");
        Point nts = LafUtils.getTextCenterShift(fm, newText);
        g2d.setPaint(this.newHSBColor.getBrightness() >= 0.7f && this.newHSBColor.getSaturation() < 0.7f ? Color.BLACK : Color.WHITE);
        g2d.drawString(newText, this.getWidth() / 2 + nts.x, 2 + (this.getHeight() - 4) / 4 + nts.y);
        g2d.setPaint(this.oldColor);
        g2d.fillRect(2, this.getHeight() / 2, this.getWidth() - 4, this.getHeight() - this.getHeight() / 2 - 2);
        String currentText = LanguageManager.get((String)"weblaf.colorchooser.color.current");
        Point cts = LafUtils.getTextCenterShift(fm, currentText);
        g2d.setPaint(this.oldHSBColor.getBrightness() >= 0.7f && this.oldHSBColor.getSaturation() < 0.7f ? Color.BLACK : Color.WHITE);
        g2d.drawString(currentText, this.getWidth() / 2 + cts.x, 2 + (this.getHeight() - 4) * 3 / 4 + cts.y);
        SwingUtils.restoreTextAntialias(g2d, hints);
    }

    public Color getNewColor() {
        return this.newColor;
    }

    public void setNewColor(Color newColor) {
        this.newColor = newColor;
        this.newHSBColor = new HSBColor(newColor);
        this.repaint();
    }

    public Color getOldColor() {
        return this.oldColor;
    }

    public void setOldColor(Color oldColor) {
        this.oldColor = oldColor;
        this.oldHSBColor = new HSBColor(oldColor);
        this.repaint();
    }

    public void addDoubleColorFieldListener(DoubleColorFieldListener listener) {
        this.listeners.add(listener);
    }

    public void removeDoubleColorFieldListener(DoubleColorFieldListener listener) {
        this.listeners.remove(listener);
    }

    private void newColorPressed() {
        for (DoubleColorFieldListener listener : CollectionUtils.copy(this.listeners)) {
            listener.newColorPressed(this.newColor);
        }
    }

    private void oldColorPressed() {
        for (DoubleColorFieldListener listener : CollectionUtils.copy(this.listeners)) {
            listener.oldColorPressed(this.oldColor);
        }
    }
}

