/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.colorchooser;

import com.alee.extended.colorchooser.ColorDisplayType;
import com.alee.extended.image.WebImage;
import com.alee.extended.window.PopOverAlignment;
import com.alee.extended.window.PopOverDirection;
import com.alee.extended.window.WebPopOver;
import com.alee.laf.button.WebButton;
import com.alee.laf.colorchooser.ColorChooserListener;
import com.alee.laf.colorchooser.WebColorChooserPanel;
import com.alee.laf.label.WebLabel;
import com.alee.laf.rootpane.WebWindow;
import com.alee.laf.text.WebTextField;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.log.Log;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.StyleId;
import com.alee.utils.ColorUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.ChooserListener;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class WebColorChooserField
extends WebTextField {
    public static final ImageIcon eyedropperIcon = new ImageIcon(WebColorChooserField.class.getResource("icons/eyedropper.png"));
    protected ColorDisplayType colorDisplayType;
    protected boolean displayEyedropper = true;
    protected final int eyedropperImageSide = 9;
    protected final int eyedropperImagePixelSize = 11;
    protected String lastCorrectColorText = "";
    protected Color color;
    protected final WebButton colorButton;
    protected Robot robot;
    protected WebImage eyedropperPicker;
    protected WebPopOver popup;
    protected WebColorChooserPanel colorChooserPanel;

    public WebColorChooserField() {
        this(StyleId.colorchooserfield, Color.WHITE);
    }

    public WebColorChooserField(Color color) {
        this(StyleId.colorchooserfield, color);
    }

    public WebColorChooserField(StyleId id) {
        this(id, Color.WHITE);
    }

    public WebColorChooserField(StyleId id, Color color) {
        super(id);
        this.setHorizontalAlignment(0);
        this.updateEyedropper();
        StyleId colorButtonId = StyleId.colorchooserfieldColorButton.at(this);
        this.colorButton = new WebButton(colorButtonId, (Icon)ImageUtils.createColorChooserIcon((Color)color));
        this.colorButton.setCursor(Cursor.getDefaultCursor());
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebColorChooserField.this.showColorChooserPopup();
            }
        });
        this.setTrailingComponent(this.colorButton);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebColorChooserField.this.updateColorFromField();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                WebColorChooserField.this.updateColorFromField();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (WebColorChooserField.this.isEnabled() && SwingUtilities.isRightMouseButton(e)) {
                    WebColorChooserField.this.showColorChooserPopup();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (WebColorChooserField.this.isEnabled()) {
                    if (Hotkey.ESCAPE.isTriggered(e)) {
                        WebColorChooserField.this.updateViewFromColor();
                    } else if (Hotkey.DOWN.isTriggered(e)) {
                        WebColorChooserField.this.showColorChooserPopup();
                    }
                }
            }
        });
        this.setColorDisplayType(ColorDisplayType.rgb);
        this.setColorImpl(color);
    }

    public boolean isDisplayEyedropper() {
        return this.displayEyedropper;
    }

    public void setDisplayEyedropper(boolean displayEyedropper) {
        this.displayEyedropper = displayEyedropper;
        this.updateEyedropper();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.setColorImpl(color);
    }

    protected void setColorImpl(Color color) {
        Color oldColor = this.color;
        this.color = color;
        this.updateViewFromColor();
        this.fireColorSelected(oldColor, color);
    }

    public ColorDisplayType getColorDisplayType() {
        return this.colorDisplayType;
    }

    public void setColorDisplayType(ColorDisplayType colorDisplayType) {
        this.colorDisplayType = colorDisplayType;
        this.updateFieldType();
    }

    protected void updateViewFromColor() {
        this.colorButton.setIcon(ImageUtils.createColorChooserIcon((Color)this.color));
        this.updateText();
    }

    protected void updateColorFromField() {
        String current = this.getText();
        if (!current.equals(this.lastCorrectColorText)) {
            try {
                Color newColor;
                boolean hex = this.colorDisplayType.equals((Object)ColorDisplayType.hex);
                Color color = newColor = hex ? ColorUtils.parseHexColor((String)current) : ColorUtils.parseRgbColor((String)current);
                if (newColor != null) {
                    newColor = ColorUtils.removeAlpha((Color)newColor);
                    this.setColorImpl(newColor);
                } else {
                    this.updateViewFromColor();
                }
            }
            catch (Throwable e) {
                this.updateViewFromColor();
            }
        }
    }

    protected void updateFieldType() {
        if (this.colorDisplayType != null) {
            boolean hex = this.colorDisplayType.equals((Object)ColorDisplayType.hex);
            this.setColumns(hex ? 6 : 9);
            this.updateText();
        }
    }

    protected void updateText() {
        if (this.color != null) {
            String text = this.getColorText(this.color);
            this.setText(text);
            this.lastCorrectColorText = text;
        }
    }

    protected String getColorText(Color color) {
        boolean hex = this.colorDisplayType.equals((Object)ColorDisplayType.hex);
        return hex ? ColorUtils.getHexColor((Color)color) : color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    protected void updateEyedropper() {
        if (this.displayEyedropper) {
            this.installEyedropper();
        } else {
            this.uninstallEyedropper();
        }
        this.revalidate();
    }

    protected void installEyedropper() {
        if (this.eyedropperPicker == null) {
            this.eyedropperPicker = new WebImage(eyedropperIcon);
            try {
                this.robot = new Robot();
            }
            catch (AWTException e) {
                Log.error((Object)this, (Throwable)e);
            }
            if (this.robot != null) {
                MouseAdapter mouseAdapter = new MouseAdapter(){
                    private boolean shouldUpdateColor;
                    private WebWindow window;
                    private JComponent screen;
                    private WebLabel info;
                    private boolean updating = false;
                    private BufferedImage screenshot;
                    private Color color;

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (WebColorChooserField.this.displayEyedropper && SwingUtils.isLeftMouseButton(e) && WebColorChooserField.this.isEnabled()) {
                            this.shouldUpdateColor = true;
                            this.createPreviewWindow();
                            this.updateWindowLocation();
                            this.window.pack();
                            this.window.setVisible(true);
                            this.screen.requestFocusInWindow();
                            this.updateScreenView();
                        }
                    }

                    @Override
                    public void mouseDragged(MouseEvent e) {
                        if (WebColorChooserField.this.displayEyedropper && SwingUtils.isLeftMouseButton(e) && this.window != null) {
                            this.updateWindowLocation();
                            this.updateScreenView();
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        if (WebColorChooserField.this.displayEyedropper && SwingUtils.isLeftMouseButton(e) && this.window != null) {
                            this.window.dispose();
                        }
                    }

                    private void updateScreenView() {
                        if (!this.updating) {
                            this.updating = true;
                            Thread updater = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    if (screen != null) {
                                        Point p = MouseInfo.getPointerInfo().getLocation();
                                        screenshot = WebColorChooserField.this.robot.createScreenCapture(new Rectangle(p.x - 4, p.y - 4, 9, 9));
                                        color = new Color(screenshot.getRGB(4, 4));
                                        if (screen != null) {
                                            screen.repaint();
                                            info.setText(WebColorChooserField.this.getColorText(color));
                                        } else {
                                            screenshot.flush();
                                            screenshot = null;
                                            color = null;
                                        }
                                    }
                                    updating = false;
                                }
                            });
                            updater.setDaemon(true);
                            updater.start();
                        }
                    }

                    private void createPreviewWindow() {
                        this.window = new WebWindow(WebColorChooserField.this.eyedropperPicker);
                        this.window.setLayout(new BorderLayout());
                        this.window.setAlwaysOnTop(true);
                        this.window.setFocusableWindowState(false);
                        this.window.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosed(WindowEvent e) {
                                if (screenshot != null) {
                                    if (shouldUpdateColor) {
                                        WebColorChooserField.this.setColorImpl(color);
                                    }
                                    screenshot.flush();
                                    screenshot = null;
                                }
                                HotkeyManager.unregisterHotkeys(screen);
                                window = null;
                                screen = null;
                            }
                        });
                        this.screen = new JComponent(){

                            @Override
                            protected void paintComponent(Graphics g) {
                                if (window.isShowing() && WebColorChooserField.this.robot != null) {
                                    Graphics2D g2d = (Graphics2D)g;
                                    Rectangle bounds = Bounds.margin.of(this);
                                    g2d.drawImage(screenshot, bounds.x + 2, bounds.y + 2, bounds.width - 4, bounds.height - 4, null);
                                    g2d.setPaint(Color.BLACK);
                                    g2d.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
                                    g2d.setPaint(Color.WHITE);
                                    g2d.drawRect(bounds.x + 1, bounds.y + 1, bounds.width - 3, bounds.height - 3);
                                    int mx = bounds.x + bounds.width / 2;
                                    int my = bounds.y + bounds.height / 2;
                                    g2d.setPaint(Color.WHITE);
                                    g2d.drawLine(mx - 1, my - 7, mx - 1, my + 7);
                                    g2d.drawLine(mx + 1, my - 7, mx + 1, my + 7);
                                    g2d.drawLine(mx - 7, my - 1, mx + 7, my - 1);
                                    g2d.drawLine(mx - 7, my + 1, mx + 7, my + 1);
                                    g2d.setPaint(Color.BLACK);
                                    g2d.drawLine(mx, my - 7, mx, my + 7);
                                    g2d.drawLine(mx - 7, my, mx + 7, my);
                                }
                            }
                        };
                        this.screen.setFocusable(true);
                        this.screen.setPreferredSize(new Dimension(103, 103));
                        this.window.add((Component)this.screen, "Center");
                        this.info = new WebLabel(10);
                        this.info.setIcon(new Icon(){

                            @Override
                            public void paintIcon(Component c, Graphics g, int x, int y) {
                                if (color != null) {
                                    Graphics2D g2d = (Graphics2D)g;
                                    g2d.setPaint(Color.BLACK);
                                    g2d.drawRect(x, y, 15, 15);
                                    g2d.setPaint(Color.WHITE);
                                    g2d.drawRect(x + 1, y + 1, 13, 13);
                                    g2d.setPaint(color);
                                    g2d.fillRect(x + 2, y + 2, 12, 12);
                                }
                            }

                            @Override
                            public int getIconWidth() {
                                return 16;
                            }

                            @Override
                            public int getIconHeight() {
                                return 16;
                            }
                        });
                        this.window.add((Component)this.info, "South");
                        HotkeyManager.registerHotkey(this.screen, Hotkey.ESCAPE, new HotkeyRunnable(){

                            @Override
                            public void run(KeyEvent e) {
                                if (window != null) {
                                    shouldUpdateColor = false;
                                    window.dispose();
                                }
                            }
                        });
                    }

                    private void updateWindowLocation() {
                        Point p = MouseInfo.getPointerInfo().getLocation();
                        Rectangle b = this.window.getGraphicsConfiguration().getDevice().getDefaultConfiguration().getBounds();
                        int ww = this.window.getWidth();
                        int wh = this.window.getHeight();
                        int x = p.x + 20 + ww < b.x + b.width ? p.x + 20 : p.x - 20 - ww;
                        int y = p.y + 20 + wh < b.y + b.height ? p.y + 20 : p.y - 20 - wh;
                        this.window.setLocation(x, y);
                    }
                };
                this.eyedropperPicker.addMouseListener(mouseAdapter);
                this.eyedropperPicker.addMouseMotionListener(mouseAdapter);
                this.eyedropperPicker.setCursor(Cursor.getDefaultCursor());
            }
        }
        this.setLeadingComponent(this.eyedropperPicker);
    }

    protected void uninstallEyedropper() {
        this.setLeadingComponent(null);
    }

    protected void showColorChooserPopup() {
        if (!this.requestFocusInWindow() && !this.isFocusOwner()) {
            return;
        }
        this.updateColorFromField();
        if (this.popup == null || this.colorChooserPanel == null) {
            Window ancestor = SwingUtils.getWindowAncestor((Component)this);
            this.popup = new WebPopOver(ancestor);
            this.popup.setPadding(5);
            this.popup.setCloseOnFocusLoss(true);
            this.colorChooserPanel = new WebColorChooserPanel(true);
            this.colorChooserPanel.setColor(this.color);
            this.popup.add(this.colorChooserPanel);
            this.updatePopupLocation();
            ancestor.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    if (WebColorChooserField.this.popup.isShowing()) {
                        WebColorChooserField.this.updatePopupLocation();
                    }
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    if (WebColorChooserField.this.popup.isShowing()) {
                        WebColorChooserField.this.updatePopupLocation();
                    }
                }
            });
            ancestor.addPropertyChangeListener("componentOrientation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (WebColorChooserField.this.popup.isShowing()) {
                        WebColorChooserField.this.updatePopupLocation();
                    }
                }
            });
            this.colorChooserPanel.addColorChooserListener(new ColorChooserListener(){

                @Override
                public void okPressed(ActionEvent e) {
                    WebColorChooserField.this.setColorImpl(WebColorChooserField.this.colorChooserPanel.getColor());
                    WebColorChooserField.this.popup.setVisible(false);
                }

                @Override
                public void resetPressed(ActionEvent e) {
                }

                @Override
                public void cancelPressed(ActionEvent e) {
                    WebColorChooserField.this.popup.setVisible(false);
                }
            });
        } else {
            this.updatePopupLocation();
            this.colorChooserPanel.setColor(this.color);
        }
        SwingUtils.copyOrientation(this, this.popup);
        this.popup.show((Component)this, PopOverDirection.down, PopOverAlignment.centered);
        this.colorChooserPanel.requestFocusInWindow();
    }

    protected void updatePopupLocation() {
        Point los = this.getLocationOnScreen();
        Rectangle gb = this.popup.getGraphicsConfiguration().getBounds();
        boolean shadeWidth = false;
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        int w = this.getWidth();
        int h = this.getHeight();
        int x = ltr ? (los.x + 0 + this.popup.getWidth() <= gb.x + gb.width ? los.x + 0 : los.x + w - 0 - this.popup.getWidth()) : (los.x + w - 0 - this.popup.getWidth() >= gb.x ? los.x + w - 0 - this.popup.getWidth() : los.x + 0);
        int y = los.y + h + this.popup.getHeight() <= gb.y + gb.height ? los.y + h + 0 : los.y - this.popup.getHeight() - 0;
        this.popup.setLocation(x, y);
    }

    public void addColorListener(ChooserListener<Color> listener) {
        this.listenerList.add(ChooserListener.class, listener);
    }

    public void removeColorListener(ChooserListener<Color> listener) {
        this.listenerList.remove(ChooserListener.class, listener);
    }

    public void fireColorSelected(Color oldColor, Color newColor) {
        for (ChooserListener listener : (ChooserListener[])this.listenerList.getListeners(ChooserListener.class)) {
            listener.selected(oldColor, newColor);
        }
    }
}

