/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.date;

import com.alee.extended.date.DateCustomizer;
import com.alee.extended.date.DateListener;
import com.alee.extended.layout.TableLayout;
import com.alee.extended.transition.ComponentTransition;
import com.alee.extended.transition.TransitionAdapter;
import com.alee.extended.transition.effects.Direction;
import com.alee.extended.transition.effects.slide.SlideTransitionEffect;
import com.alee.extended.transition.effects.slide.SlideType;
import com.alee.laf.button.WebButton;
import com.alee.laf.button.WebToggleButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.separator.WebSeparator;
import com.alee.managers.style.StyleId;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CompareUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TimeUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class WebCalendar
extends WebPanel {
    public static final ImageIcon previousSkipIcon = new ImageIcon(WebCalendar.class.getResource("icons/previous_skip.png"));
    public static final ImageIcon previousIcon = new ImageIcon(WebCalendar.class.getResource("icons/previous.png"));
    public static final ImageIcon nextIcon = new ImageIcon(WebCalendar.class.getResource("icons/next.png"));
    public static final ImageIcon nextSkipIcon = new ImageIcon(WebCalendar.class.getResource("icons/next_skip.png"));
    protected List<DateListener> dateListeners = new ArrayList<DateListener>(1);
    protected SimpleDateFormat titleFormat = new SimpleDateFormat("MMMM yyyy");
    protected boolean startWeekFromSunday = false;
    protected boolean displayWeekNumbers = false;
    protected boolean animate = true;
    protected boolean horizontalSlide = true;
    protected DateCustomizer dateCustomizer;
    protected Date date;
    protected Date shownDate;
    protected Date oldShownDate;
    protected WebButton previousSkip;
    protected WebButton previous;
    protected WebLabel titleLabel;
    protected WebButton next;
    protected WebButton nextSkip;
    protected WebPanel weekHeaders;
    protected WebPanel monthDays;
    protected ComponentTransition monthDaysTransition;
    protected WebToggleButton lastSelectedDayButton;

    public WebCalendar() {
        this(StyleId.calendar, (Date)null);
    }

    public WebCalendar(Date date) {
        this(StyleId.calendar, date);
    }

    public WebCalendar(StyleId id) {
        this(id, (Date)null);
    }

    public WebCalendar(StyleId id, Date date) {
        super(id, new BorderLayout(0, 0), new Component[0]);
        this.putClientProperty("HANDLES_ENABLE_STATE", true);
        this.date = date != null ? new Date(date.getTime()) : null;
        this.shownDate = date != null ? new Date(date.getTime()) : new Date();
        WebPanel centerPanel = new WebPanel();
        centerPanel.setOpaque(false);
        this.add((Component)centerPanel, (Object)"Center");
        WebPanel header = new WebPanel(StyleId.calendarHeaderPanel.at(this));
        this.add((Component)header, (Object)"North");
        this.previousSkip = new WebButton(StyleId.calendarPrevYearButton.at(header), (Icon)previousSkipIcon);
        this.previousSkip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebCalendar.this.changeYear(-1);
            }
        });
        this.previous = new WebButton(StyleId.calendarPrevMonthButton.at(header), (Icon)previousIcon);
        this.previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebCalendar.this.changeMonth(-1);
            }
        });
        WebPanel leftHeader = new WebPanel((LayoutManager)new BorderLayout(), new Component[0]);
        leftHeader.setOpaque(false);
        leftHeader.add((Component)this.previousSkip, (Object)"West");
        leftHeader.add((Component)this.previous, (Object)"East");
        header.add((Component)leftHeader, (Object)"West");
        this.titleLabel = new WebLabel(StyleId.calendarTitleLabel.at(header));
        this.titleLabel.setBoldFont();
        this.updateTitleLabel();
        header.add((Component)this.titleLabel, (Object)"Center");
        this.next = new WebButton(StyleId.calendarNextMonthButton.at(header), (Icon)nextIcon);
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebCalendar.this.changeMonth(1);
            }
        });
        this.nextSkip = new WebButton(StyleId.calendarNextYearButton.at(header), (Icon)nextSkipIcon);
        this.nextSkip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebCalendar.this.changeYear(1);
            }
        });
        WebPanel rightHeader = new WebPanel((LayoutManager)new BorderLayout(), new Component[0]);
        rightHeader.setOpaque(false);
        rightHeader.add((Component)this.next, (Object)"West");
        rightHeader.add((Component)this.nextSkip, (Object)"East");
        header.add((Component)rightHeader, (Object)"East");
        this.weekHeaders = new WebPanel(StyleId.calendarWeekTitlesPanel.at(this));
        centerPanel.add((Component)this.weekHeaders, (Object)"North");
        this.updateWeekHeaders();
        this.monthDays = this.createMonthPanel();
        this.updateMonth(this.monthDays);
        this.monthDaysTransition = new ComponentTransition(this.monthDays);
        this.monthDaysTransition.setOpaque(false);
        this.monthDaysTransition.addTransitionListener(new TransitionAdapter(){

            @Override
            public void transitionFinished() {
                WebCalendar.this.requestFocusToSelected();
            }
        });
        centerPanel.add((Component)this.monthDaysTransition, (Object)"Center");
    }

    protected void updateTitleLabel() {
        this.titleLabel.setText(this.titleFormat.format(this.shownDate));
    }

    protected void updateMonth(boolean animate) {
        if (animate && this.isAnimate()) {
            this.monthDays = this.createMonthPanel();
            this.updateMonth(this.monthDays);
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            SlideTransitionEffect effect = new SlideTransitionEffect();
            effect.setType(SlideType.moveBoth);
            effect.setDirection(this.oldShownDate.getTime() > this.shownDate.getTime() ? this.getNextDirection(ltr) : this.getPrevDirection(ltr));
            effect.setSpeed(20);
            this.monthDaysTransition.setTransitionEffect(effect);
            this.monthDaysTransition.performTransition(this.monthDays);
        } else {
            this.updateMonth(this.monthDays);
            this.requestFocusToSelected();
        }
    }

    protected void changeMonth(int change) {
        if (!this.getComponentOrientation().isLeftToRight()) {
            change = -change;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.shownDate);
        calendar.set(5, 1);
        calendar.set(2, calendar.get(2) + change);
        this.setShownDate(calendar.getTime());
    }

    protected void changeYear(int change) {
        if (!this.getComponentOrientation().isLeftToRight()) {
            change = -change;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.shownDate);
        calendar.set(5, 1);
        calendar.set(1, calendar.get(1) + change);
        this.setShownDate(calendar.getTime());
    }

    protected double[] getContentColumns() {
        double[] dArray;
        double f = -1.0;
        double p = -2.0;
        if (this.displayWeekNumbers) {
            double[] dArray2 = new double[15];
            dArray2[0] = -1.0;
            dArray2[1] = -2.0;
            dArray2[2] = -1.0;
            dArray2[3] = -2.0;
            dArray2[4] = -1.0;
            dArray2[5] = -2.0;
            dArray2[6] = -1.0;
            dArray2[7] = -2.0;
            dArray2[8] = -1.0;
            dArray2[9] = -2.0;
            dArray2[10] = -1.0;
            dArray2[11] = -2.0;
            dArray2[12] = -1.0;
            dArray2[13] = -2.0;
            dArray = dArray2;
            dArray2[14] = -1.0;
        } else {
            double[] dArray3 = new double[13];
            dArray3[0] = -1.0;
            dArray3[1] = -2.0;
            dArray3[2] = -1.0;
            dArray3[3] = -2.0;
            dArray3[4] = -1.0;
            dArray3[5] = -2.0;
            dArray3[6] = -1.0;
            dArray3[7] = -2.0;
            dArray3[8] = -1.0;
            dArray3[9] = -2.0;
            dArray3[10] = -1.0;
            dArray3[11] = -2.0;
            dArray = dArray3;
            dArray3[12] = -1.0;
        }
        return dArray;
    }

    protected int getFirstDatesColumn() {
        return this.displayWeekNumbers ? 2 : 0;
    }

    protected WebPanel createMonthPanel() {
        double f = -1.0;
        double[] cols = this.getContentColumns();
        double[] rows = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
        return new WebPanel(StyleId.calendarMonthPanel.at(this), new TableLayout(new double[][]{cols, rows}, 0, 0), new Component[0]);
    }

    protected void requestFocusToSelected() {
        if (this.lastSelectedDayButton != null) {
            this.lastSelectedDayButton.requestFocusInWindow();
        }
    }

    protected Direction getNextDirection(boolean ltr) {
        return this.horizontalSlide ? (ltr ? Direction.right : Direction.left) : Direction.up;
    }

    protected Direction getPrevDirection(boolean ltr) {
        return this.horizontalSlide ? (ltr ? Direction.left : Direction.right) : Direction.down;
    }

    protected void updateWeekHeaders() {
        this.weekHeaders.removeAll();
        double[] cols = this.getContentColumns();
        double[] rows = new double[]{-2.0};
        this.weekHeaders.setLayout(new TableLayout(new double[][]{cols, rows}));
        StyleId separatorId = StyleId.calendarWeekTitleSeparator.at(this.weekHeaders);
        StyleId weekNumberId = StyleId.calendarWeekTitleLabel.at(this.weekHeaders);
        StyleId dayOfWeekId = StyleId.calendarWeekTitleLabel.at(this.weekHeaders);
        if (this.displayWeekNumbers) {
            WebLabel weekNumber = new WebLabel(weekNumberId, "weblaf.ex.calendar.weekNumber");
            weekNumber.setFontSizeAndStyle(10, 1);
            this.weekHeaders.add((Component)weekNumber, (Object)"0,0");
            this.weekHeaders.add((Component)new WebSeparator(separatorId, 1), (Object)"1,0");
        }
        int col = this.getFirstDatesColumn();
        for (int i = 1; i <= 7; ++i) {
            int day = !this.startWeekFromSunday ? i : (i == 1 ? 7 : i - 1);
            WebLabel dayOfWeekLabel = new WebLabel(dayOfWeekId, "weblaf.ex.calendar.dayOfWeek." + day);
            dayOfWeekLabel.setFontSizeAndStyle(10, 1);
            this.weekHeaders.add((Component)dayOfWeekLabel, (Object)(col + ",0"));
            ++col;
            if (i >= 7) continue;
            this.weekHeaders.add((Component)new WebSeparator(separatorId, 1), (Object)(col + ",0"));
            ++col;
        }
        this.weekHeaders.revalidate();
        this.weekHeaders.repaint();
    }

    protected void updateMonth(JPanel monthDays) {
        WebToggleButton day;
        StyleId dayId;
        Date thisDate;
        int shift;
        monthDays.removeAll();
        this.lastSelectedDayButton = null;
        StyleId separatorId = StyleId.calendarMonthDateSeparator.at(monthDays);
        monthDays.add((Component)new WebSeparator(separatorId, 1), "1,0,1,5");
        monthDays.add((Component)new WebSeparator(separatorId, 1), "3,0,3,5");
        monthDays.add((Component)new WebSeparator(separatorId, 1), "5,0,5,5");
        monthDays.add((Component)new WebSeparator(separatorId, 1), "7,0,7,5");
        monthDays.add((Component)new WebSeparator(separatorId, 1), "9,0,9,5");
        monthDays.add((Component)new WebSeparator(separatorId, 1), "11,0,11,5");
        if (this.displayWeekNumbers) {
            monthDays.add((Component)new WebSeparator(separatorId, 1), "13,0,13,5");
        }
        ButtonGroup dates = new ButtonGroup();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.shownDate);
        calendar.set(5, 1);
        int max = this.getContentColumns().length;
        int col = this.getFirstDatesColumn();
        int row = 0;
        int days = 0;
        int dayOfWeek = calendar.get(7);
        switch (dayOfWeek) {
            case 2: {
                shift = this.startWeekFromSunday ? 1 : 7;
                break;
            }
            case 3: {
                shift = this.startWeekFromSunday ? 2 : 1;
                break;
            }
            case 4: {
                shift = this.startWeekFromSunday ? 3 : 2;
                break;
            }
            case 5: {
                shift = this.startWeekFromSunday ? 4 : 3;
                break;
            }
            case 6: {
                shift = this.startWeekFromSunday ? 5 : 4;
                break;
            }
            case 7: {
                shift = this.startWeekFromSunday ? 6 : 5;
                break;
            }
            case 1: {
                shift = this.startWeekFromSunday ? 7 : 6;
                break;
            }
            default: {
                shift = 0;
            }
        }
        TimeUtils.changeByDays((Calendar)calendar, (int)(-shift));
        if (this.displayWeekNumbers) {
            StyleId weekNumberId = StyleId.calendarWeekTitleLabel.at(this.weekHeaders);
            int week = calendar.get(3);
            for (int i = 0; i < 6; ++i) {
                WebLabel weekNumberLabel = new WebLabel(weekNumberId, "" + week);
                weekNumberLabel.setFontSizeAndStyle(10, 1);
                monthDays.add((Component)weekNumberLabel, "0," + i);
                ++week;
            }
        }
        while (calendar.get(5) > 1) {
            final Date thisDate2 = calendar.getTime();
            StyleId dayId2 = StyleId.calendarPreviousMonthDateToggleButton.at(monthDays);
            WebToggleButton day2 = new WebToggleButton(dayId2, "" + calendar.get(5));
            day2.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    WebToggleButton dayButton = (WebToggleButton)e.getSource();
                    if (dayButton.isSelected()) {
                        WebCalendar.this.setDateImpl(thisDate2);
                    }
                }
            });
            if (this.dateCustomizer != null) {
                this.dateCustomizer.customize(day2, thisDate2);
            }
            monthDays.add((Component)day2, col + "," + row);
            dates.add(day2);
            TimeUtils.increaseByDay((Calendar)calendar);
            ++days;
            if ((col += 2) <= max) continue;
            col = this.getFirstDatesColumn();
            ++row;
        }
        do {
            boolean weekend = calendar.get(7) == 1 || calendar.get(7) == 7;
            boolean selected = this.date != null && TimeUtils.isSameDay((Calendar)calendar, (Long)this.date.getTime());
            thisDate = calendar.getTime();
            dayId = weekend ? StyleId.calendarWeekendMonthDateToggleButton.at(monthDays) : StyleId.calendarCurrentMonthDateToggleButton.at(monthDays);
            day = new WebToggleButton(dayId, "" + calendar.get(5));
            day.setSelected(selected);
            day.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebCalendar.this.lastSelectedDayButton = (WebToggleButton)e.getSource();
                    WebCalendar.this.setDateImpl(thisDate);
                }
            });
            if (this.dateCustomizer != null) {
                this.dateCustomizer.customize(day, thisDate);
            }
            monthDays.add((Component)day, col + "," + row);
            dates.add(day);
            if (selected) {
                this.lastSelectedDayButton = day;
            }
            TimeUtils.increaseByDay((Calendar)calendar);
            ++days;
            if ((col += 2) <= max) continue;
            col = this.getFirstDatesColumn();
            ++row;
        } while (calendar.get(5) > 1);
        int left = 42 - days;
        for (int i = 1; i <= left; ++i) {
            thisDate = calendar.getTime();
            dayId = StyleId.calendarNextMonthDateToggleButton.at(monthDays);
            day = new WebToggleButton(dayId, "" + calendar.get(5));
            day.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    WebToggleButton dayButton = (WebToggleButton)e.getSource();
                    if (dayButton.isSelected()) {
                        WebCalendar.this.setDateImpl(thisDate);
                    }
                }
            });
            if (this.dateCustomizer != null) {
                this.dateCustomizer.customize(day, thisDate);
            }
            monthDays.add((Component)day, col + "," + row);
            dates.add(day);
            TimeUtils.increaseByDay((Calendar)calendar);
            if ((col += 2) <= max) continue;
            col = this.getFirstDatesColumn();
            ++row;
        }
        monthDays.revalidate();
        monthDays.repaint();
    }

    public SimpleDateFormat getTitleFormat() {
        return this.titleFormat;
    }

    public void setTitleFormat(SimpleDateFormat titleFormat) {
        this.titleFormat = titleFormat;
        this.updateTitleLabel();
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.setDate(date, this.isAnimate());
    }

    public void setDate(Date date, boolean animate) {
        if (!CompareUtils.equals((Object)this.date, (Object[])new Object[]{date})) {
            this.setDateImpl(date, animate);
        }
    }

    protected void setDateImpl(Date date) {
        this.setDateImpl(date, this.isAnimate());
    }

    protected void setDateImpl(Date date, boolean animate) {
        this.date = date;
        this.setShownDate(date, animate);
        this.fireDateSelected(date);
    }

    public Date getShownDate() {
        return this.shownDate;
    }

    public void setShownDate(Date date) {
        this.setShownDate(date, this.isAnimate());
    }

    public void setShownDate(Date date, boolean animate) {
        if (date == null) {
            date = new Date();
        }
        this.oldShownDate = this.shownDate;
        this.shownDate = date;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.oldShownDate);
        int oldMonth = calendar.get(2);
        int oldYear = calendar.get(1);
        calendar.setTime(date);
        int newMonth = calendar.get(2);
        int newYear = calendar.get(1);
        if (oldMonth != newMonth || oldYear != newYear) {
            this.updateTitleLabel();
            this.updateMonth(animate);
        }
    }

    public boolean isStartWeekFromSunday() {
        return this.startWeekFromSunday;
    }

    public void setStartWeekFromSunday(boolean startWeekFromSunday) {
        this.startWeekFromSunday = startWeekFromSunday;
        this.updateWeekHeaders();
        this.updateMonth(this.monthDays);
    }

    public boolean isDisplayWeekNumbers() {
        return this.displayWeekNumbers;
    }

    public void setDisplayWeekNumbers(boolean display) {
        this.displayWeekNumbers = display;
        this.updateWeekHeaders();
        this.updateMonth(this.monthDays);
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public boolean isHorizontalSlide() {
        return this.horizontalSlide;
    }

    public void setHorizontalSlide(boolean horizontalSlide) {
        this.horizontalSlide = horizontalSlide;
    }

    public DateCustomizer getDateCustomizer() {
        return this.dateCustomizer;
    }

    public void setDateCustomizer(DateCustomizer dateCustomizer) {
        this.dateCustomizer = dateCustomizer;
        this.updateMonth(this.monthDays);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        SwingUtils.setEnabledRecursively(this, enabled, true);
    }

    public void addDateSelectionListener(DateListener listener) {
        this.dateListeners.add(listener);
    }

    public void removeDateSelectionListener(DateListener listener) {
        this.dateListeners.remove(listener);
    }

    public void fireDateSelected(Date date) {
        for (DateListener listener : CollectionUtils.copy(this.dateListeners)) {
            listener.dateChanged(date);
        }
    }
}

