/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock;

import com.alee.extended.dock.DockingPaneConstants;
import com.alee.extended.dock.DockingPaneInfo;
import com.alee.extended.layout.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DockingPaneLayout
extends AbstractLayoutManager
implements DockingPaneConstants {
    private boolean buttonPanesVisible = true;
    private String filledFrame = null;
    private Insets buttonsMargin = new Insets(1, 1, 1, 1);
    private int buttonSpacing = 0;
    private int buttonSidesSpacing = 20;
    private Insets framesMargin = new Insets(0, 0, 0, 0);
    private Insets contentMargin = new Insets(0, 0, 0, 0);
    private Map<Component, String> constraints = new HashMap<Component, String>();
    private DockingPaneInfo info = null;

    public boolean isButtonPanesVisible() {
        return this.buttonPanesVisible;
    }

    public void setButtonPanesVisible(boolean buttonPanesVisible) {
        this.buttonPanesVisible = buttonPanesVisible;
    }

    public String getFilledFrame() {
        return this.filledFrame;
    }

    public void setFilledFrame(String filledFrame) {
        this.filledFrame = filledFrame;
    }

    public Insets getButtonsMargin() {
        return this.buttonsMargin;
    }

    public void setButtonsMargin(Insets buttonsMargin) {
        this.buttonsMargin = buttonsMargin;
    }

    public int getButtonSpacing() {
        return this.buttonSpacing;
    }

    public void setButtonSpacing(int buttonSpacing) {
        this.buttonSpacing = buttonSpacing;
    }

    public int getButtonSidesSpacing() {
        return this.buttonSidesSpacing;
    }

    public void setButtonSidesSpacing(int buttonSidesSpacing) {
        this.buttonSidesSpacing = buttonSidesSpacing;
    }

    public Insets getFramesMargin() {
        return this.framesMargin;
    }

    public void setFramesMargin(Insets framesMargin) {
        this.framesMargin = framesMargin;
    }

    public Insets getContentMargin() {
        return this.contentMargin;
    }

    public void setContentMargin(Insets contentMargin) {
        this.contentMargin = contentMargin;
    }

    public Map<Component, String> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Map<Component, String> constraints) {
        this.constraints = constraints;
    }

    public DockingPaneInfo getDockingPaneInfo() {
        return this.info;
    }

    @Override
    public void addComponent(Component component, Object constraints) {
        this.constraints.put(component, (String)constraints);
    }

    @Override
    public void removeComponent(Component component) {
        this.constraints.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    @Override
    public void layoutContainer(Container parent) {
        int y;
        int topY;
        int leftX;
        Dimension ps;
        int rightX;
        boolean fit;
        Iterator<Component> ps2;
        int x;
        int leftX2;
        this.info = new DockingPaneInfo(this, parent);
        if (this.info.hasTopButtons) {
            int topY2 = this.info.rect.y + this.buttonsMargin.top;
            leftX2 = this.info.rect.x + this.info.leftButtonsPaneBounds.width + this.buttonsMargin.left;
            x = 0;
            for (Component component : this.info.topLeftButtons) {
                ps2 = component.getPreferredSize();
                component.setBounds(leftX2 + x, topY2, ((Dimension)((Object)ps2)).width, this.info.topButtonsSize.height);
                x += ((Dimension)((Object)ps2)).width + this.buttonSpacing;
            }
            boolean bl = fit = this.info.topButtonsSize.width + this.info.leftButtonsPaneBounds.width + this.info.rightButtonsPaneBounds.width < this.info.rect.width;
            rightX = fit ? this.info.rect.x + this.info.rect.width - this.info.rightButtonsPaneBounds.width - this.buttonsMargin.right : (x > 0 ? leftX2 + x - this.buttonSpacing + this.info.buttonSidesSpacing : leftX2) + this.info.topRightButtonsSize.width - this.buttonsMargin.right;
            x = 0;
            for (Component component : this.info.topRightButtons) {
                ps = component.getPreferredSize();
                component.setBounds(rightX - (x += ps.width), topY2, ps.width, this.info.topButtonsSize.height);
                x += this.buttonSpacing;
            }
        }
        if (this.info.hasBottomButtons) {
            int bottomY = this.info.rect.y + this.info.rect.height - this.buttonsMargin.bottom - this.info.bottomButtonsSize.height;
            leftX2 = this.info.rect.x + this.info.leftButtonsPaneBounds.width + this.buttonsMargin.left;
            x = 0;
            for (Component component : this.info.bottomLeftButtons) {
                ps2 = component.getPreferredSize();
                component.setBounds(leftX2 + x, bottomY, ((Dimension)((Object)ps2)).width, this.info.bottomButtonsSize.height);
                x += ((Dimension)((Object)ps2)).width + this.buttonSpacing;
            }
            boolean bl = fit = this.info.bottomButtonsSize.width + this.info.leftButtonsPaneBounds.width + this.info.rightButtonsPaneBounds.width < this.info.rect.width;
            rightX = fit ? this.info.rect.x + this.info.rect.width - this.info.rightButtonsPaneBounds.width - this.buttonsMargin.right : (x > 0 ? leftX2 + x - this.buttonSpacing + this.info.buttonSidesSpacing : leftX2) + this.info.bottomRightButtonsSize.width - this.buttonsMargin.right;
            x = 0;
            for (Component component : this.info.bottomRightButtons) {
                ps = component.getPreferredSize();
                component.setBounds(rightX - (x += ps.width), bottomY, ps.width, this.info.bottomButtonsSize.height);
                x += this.buttonSpacing;
            }
        }
        if (this.info.hasLeftButtons) {
            leftX = this.info.rect.x + this.buttonsMargin.left;
            topY = this.info.rect.y + this.info.topButtonsPaneBounds.height + this.buttonsMargin.top;
            y = 0;
            for (Component component : this.info.leftTopButtons) {
                ps2 = component.getPreferredSize();
                component.setBounds(leftX, topY + y, this.info.leftButtonsSize.width, ((Dimension)((Object)ps2)).height);
                y += ((Dimension)((Object)ps2)).height + this.buttonSpacing;
            }
            boolean bl = fit = this.info.leftButtonsSize.height + this.info.topButtonsPaneBounds.height + this.info.bottomButtonsPaneBounds.height < this.info.rect.height;
            int bottomY = fit ? this.info.rect.y + this.info.rect.height - this.info.bottomButtonsPaneBounds.height - this.buttonsMargin.bottom : (y > 0 ? topY + y - this.buttonSpacing + this.info.buttonSidesSpacing : topY) + this.info.leftBottomButtonsSize.height - this.buttonsMargin.bottom;
            y = 0;
            for (Component component : this.info.leftBottomButtons) {
                ps = component.getPreferredSize();
                component.setBounds(leftX, bottomY - (y += ps.height), this.info.leftButtonsSize.width, ps.height);
                y += this.buttonSpacing;
            }
        }
        if (this.info.hasRightButtons) {
            boolean fit2;
            leftX = this.info.rect.x + this.info.rect.width - this.buttonsMargin.right - this.info.rightButtonsSize.width;
            topY = this.info.rect.y + this.info.topButtonsPaneBounds.height + this.buttonsMargin.top;
            y = 0;
            for (Component component : this.info.rightTopButtons) {
                ps2 = component.getPreferredSize();
                component.setBounds(leftX, topY + y, this.info.rightButtonsSize.width, ((Dimension)((Object)ps2)).height);
                y += ((Dimension)((Object)ps2)).height + this.buttonSpacing;
            }
            boolean bl = fit2 = this.info.rightButtonsSize.height + this.info.topButtonsPaneBounds.height + this.info.bottomButtonsPaneBounds.height < this.info.rect.height;
            int bottomY = fit2 ? this.info.rect.y + this.info.rect.height - this.info.bottomButtonsPaneBounds.height - this.buttonsMargin.bottom : (y > 0 ? topY + y - this.buttonSpacing + this.info.buttonSidesSpacing : topY) + this.info.rightBottomButtonsSize.height - this.buttonsMargin.bottom;
            y = 0;
            for (Component component : this.info.rightBottomButtons) {
                ps = component.getPreferredSize();
                component.setBounds(leftX, bottomY - (y += ps.height), this.info.rightButtonsSize.width, ps.height);
                y += this.buttonSpacing;
            }
        }
        if (this.info.topFrame != null) {
            this.info.topFrame.setBounds(this.info.topFrameBounds);
        }
        if (this.info.leftFrame != null) {
            this.info.leftFrame.setBounds(this.info.leftFrameBounds);
        }
        if (this.info.rightFrame != null) {
            this.info.rightFrame.setBounds(this.info.rightFrameBounds);
        }
        if (this.info.bottomFrame != null) {
            this.info.bottomFrame.setBounds(this.info.bottomFrameBounds);
        }
        if (this.info.content != null) {
            this.info.content.setBounds(this.info.contentBounds);
        }
    }
}

