/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.extended.label.StyleRange;
import com.alee.extended.label.StyledLabelUtils;
import com.alee.extended.label.WebStyledLabelUI;
import com.alee.laf.WebLookAndFeel;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.LanguageUtils;
import com.alee.managers.language.data.TooltipWay;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.managers.log.Log;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.Skin;
import com.alee.managers.style.Skinnable;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.managers.style.StyleableComponent;
import com.alee.managers.tooltip.ToolTipMethods;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.WebCustomTooltip;
import com.alee.painter.Paintable;
import com.alee.painter.Painter;
import com.alee.utils.CollectionUtils;
import com.alee.utils.EventUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.EventMethods;
import com.alee.utils.swing.FocusEventRunnable;
import com.alee.utils.swing.FontMethods;
import com.alee.utils.swing.KeyEventRunnable;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.MouseEventRunnable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class WebStyledLabel
extends JLabel
implements Styleable,
Skinnable,
Paintable,
ShapeProvider,
MarginSupport,
PaddingSupport,
EventMethods,
ToolTipMethods,
LanguageMethods,
FontMethods<WebStyledLabel> {
    public static final String PROPERTY_STYLE_RANGE = "styleRange";
    protected List<StyleRange> styleRanges;
    protected boolean lineWrap;
    protected int rows;
    protected int maximumRows;
    protected int minimumRows;
    protected int preferredWidth;
    protected int rowGap;

    public WebStyledLabel() {
    }

    public WebStyledLabel(Icon icon) {
        super(icon);
    }

    public WebStyledLabel(int horizontalAlignment) {
        this.setHorizontalAlignment(horizontalAlignment);
    }

    public WebStyledLabel(Icon icon, int horizontalAlignment) {
        super(icon, horizontalAlignment);
    }

    public WebStyledLabel(String text, Object ... data) {
        super(LanguageUtils.getInitialText((String)text, (Object[])data));
        LanguageUtils.registerInitialLanguage((LanguageMethods)this, (String)text, (Object[])data);
    }

    public WebStyledLabel(String text, int horizontalAlignment, Object ... data) {
        super(LanguageUtils.getInitialText((String)text, (Object[])data), horizontalAlignment);
        LanguageUtils.registerInitialLanguage((LanguageMethods)this, (String)text, (Object[])data);
    }

    public WebStyledLabel(String text, Icon icon, Object ... data) {
        super(LanguageUtils.getInitialText((String)text, (Object[])data), icon, 10);
        LanguageUtils.registerInitialLanguage((LanguageMethods)this, (String)text, (Object[])data);
    }

    public WebStyledLabel(String text, Icon icon, int horizontalAlignment, Object ... data) {
        super(LanguageUtils.getInitialText((String)text, (Object[])data), icon, horizontalAlignment);
        LanguageUtils.registerInitialLanguage((LanguageMethods)this, (String)text, (Object[])data);
    }

    public WebStyledLabel(StyleId id) {
        this.setStyleId(id);
    }

    public WebStyledLabel(StyleId id, Icon icon) {
        super(icon);
        this.setStyleId(id);
    }

    public WebStyledLabel(StyleId id, int horizontalAlignment) {
        this.setHorizontalAlignment(horizontalAlignment);
        this.setStyleId(id);
    }

    public WebStyledLabel(StyleId id, Icon icon, int horizontalAlignment) {
        super(icon, horizontalAlignment);
        this.setStyleId(id);
    }

    public WebStyledLabel(StyleId id, String text, Object ... data) {
        super(LanguageUtils.getInitialText((String)text, (Object[])data));
        LanguageUtils.registerInitialLanguage((LanguageMethods)this, (String)text, (Object[])data);
        this.setStyleId(id);
    }

    public WebStyledLabel(StyleId id, String text, int horizontalAlignment, Object ... data) {
        super(LanguageUtils.getInitialText((String)text, (Object[])data), horizontalAlignment);
        LanguageUtils.registerInitialLanguage((LanguageMethods)this, (String)text, (Object[])data);
        this.setStyleId(id);
    }

    public WebStyledLabel(StyleId id, String text, Icon icon, Object ... data) {
        super(LanguageUtils.getInitialText((String)text, (Object[])data), icon, 10);
        LanguageUtils.registerInitialLanguage((LanguageMethods)this, (String)text, (Object[])data);
        this.setStyleId(id);
    }

    public WebStyledLabel(StyleId id, String text, Icon icon, int horizontalAlignment, Object ... data) {
        super(LanguageUtils.getInitialText((String)text, (Object[])data), icon, horizontalAlignment);
        LanguageUtils.registerInitialLanguage((LanguageMethods)this, (String)text, (Object[])data);
        this.setStyleId(id);
    }

    @Override
    public void setText(String text) {
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        String plainText = StyledLabelUtils.getPlainText(text, styles);
        super.setText(plainText);
        if (styles.size() > 0) {
            this.setStyleRanges(styles);
        } else {
            this.clearStyleRanges();
        }
    }

    public List<StyleRange> getStyleRanges() {
        return CollectionUtils.copy(this.getStyleRangesImpl());
    }

    public void addStyleRange(StyleRange styleRange) {
        StyleRange removed = this.addStyleRangeImpl(styleRange);
        this.firePropertyChange(PROPERTY_STYLE_RANGE, removed, styleRange);
    }

    public void addStyleRanges(List<StyleRange> styleRanges) {
        this.addStyleRangesImpl(styleRanges);
        this.firePropertyChange(PROPERTY_STYLE_RANGE, null, styleRanges);
    }

    public void removeStyleRange(StyleRange styleRange) {
        this.removeStyleRangeImpl(styleRange);
        this.firePropertyChange(PROPERTY_STYLE_RANGE, styleRange, null);
    }

    public void removeStyleRanges(List<StyleRange> styleRanges) {
        this.removeStyleRangesImpl(styleRanges);
        this.firePropertyChange(PROPERTY_STYLE_RANGE, styleRanges, null);
    }

    public void setStyleRanges(List<StyleRange> styleRanges) {
        this.clearStyleRangesImpl();
        this.addStyleRangesImpl(styleRanges);
        this.firePropertyChange(PROPERTY_STYLE_RANGE, null, styleRanges);
    }

    public void clearStyleRanges() {
        this.clearStyleRangesImpl();
        this.firePropertyChange(PROPERTY_STYLE_RANGE, null, null);
    }

    protected List<StyleRange> getStyleRangesImpl() {
        if (this.styleRanges == null) {
            this.styleRanges = new ArrayList<StyleRange>(3);
        }
        return this.styleRanges;
    }

    protected StyleRange addStyleRangeImpl(StyleRange styleRange) {
        StyleRange removed = this.clearSimilarRangeImpl(styleRange.getStartIndex(), styleRange.getLength());
        this.getStyleRangesImpl().add(styleRange);
        return removed;
    }

    protected void addStyleRangesImpl(List<StyleRange> styleRanges) {
        if (styleRanges != null) {
            for (StyleRange styleRange : styleRanges) {
                this.addStyleRangeImpl(styleRange);
            }
        }
    }

    protected void removeStyleRangeImpl(StyleRange styleRange) {
        if (!this.getStyleRangesImpl().remove(styleRange)) {
            Iterator<StyleRange> iterator = this.getStyleRangesImpl().iterator();
            while (iterator.hasNext()) {
                StyleRange range = iterator.next();
                if (range.getStartIndex() != styleRange.getStartIndex() || range.getLength() != styleRange.getLength()) continue;
                iterator.remove();
                return;
            }
        }
    }

    protected void removeStyleRangesImpl(List<StyleRange> styleRanges) {
        if (styleRanges != null) {
            for (StyleRange styleRange : styleRanges) {
                this.removeStyleRangeImpl(styleRange);
            }
        }
    }

    protected void clearStyleRangesImpl() {
        this.getStyleRangesImpl().clear();
    }

    protected StyleRange clearSimilarRangeImpl(int start, int length) {
        Iterator<StyleRange> iterator = this.getStyleRangesImpl().iterator();
        while (iterator.hasNext()) {
            StyleRange range = iterator.next();
            if (range.getStartIndex() != start || range.getLength() != length) continue;
            iterator.remove();
            return range;
        }
        return null;
    }

    public boolean isLineWrap() {
        return this.lineWrap;
    }

    public void setLineWrap(boolean wrap) {
        this.lineWrap = wrap;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getRowGap() {
        return this.rowGap;
    }

    public void setRowGap(int gap) {
        this.rowGap = gap;
    }

    public int getMaximumRows() {
        return this.maximumRows;
    }

    public void setMaximumRows(int maximumRows) {
        this.maximumRows = maximumRows;
    }

    public int getMinimumRows() {
        return this.minimumRows;
    }

    public void setMinimumRows(int minimumRows) {
        this.minimumRows = minimumRows;
    }

    @Override
    public StyleId getStyleId() {
        return this.getWebUI().getStyleId();
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return this.getWebUI().setStyleId(id);
    }

    @Override
    public Skin getSkin() {
        return StyleManager.getSkin(this);
    }

    @Override
    public Skin setSkin(Skin skin) {
        return StyleManager.setSkin(this, skin);
    }

    @Override
    public Skin setSkin(Skin skin, boolean recursively) {
        return StyleManager.setSkin(this, skin, recursively);
    }

    @Override
    public Skin restoreSkin() {
        return StyleManager.restoreSkin(this);
    }

    @Override
    public void addStyleListener(StyleListener listener) {
        StyleManager.addStyleListener(this, listener);
    }

    @Override
    public void removeStyleListener(StyleListener listener) {
        StyleManager.removeStyleListener(this, listener);
    }

    @Override
    public Map<String, Painter> getCustomPainters() {
        return StyleManager.getCustomPainters(this);
    }

    @Override
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this);
    }

    @Override
    public Painter getCustomPainter(String id) {
        return StyleManager.getCustomPainter(this, id);
    }

    @Override
    public Painter setCustomPainter(Painter painter) {
        return StyleManager.setCustomPainter(this, painter);
    }

    @Override
    public Painter setCustomPainter(String id, Painter painter) {
        return StyleManager.setCustomPainter(this, id, painter);
    }

    @Override
    public boolean restoreDefaultPainters() {
        return StyleManager.restoreDefaultPainters(this);
    }

    @Override
    public Shape provideShape() {
        return this.getWebUI().provideShape();
    }

    @Override
    public Insets getMargin() {
        return this.getWebUI().getMargin();
    }

    public void setMargin(int margin) {
        this.setMargin(margin, margin, margin, margin);
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
    }

    @Override
    public void setMargin(Insets margin) {
        this.getWebUI().setMargin(margin);
    }

    @Override
    public Insets getPadding() {
        return this.getWebUI().getPadding();
    }

    public void setPadding(int padding) {
        this.setPadding(padding, padding, padding, padding);
    }

    public void setPadding(int top, int left, int bottom, int right) {
        this.setPadding(new Insets(top, left, bottom, right));
    }

    @Override
    public void setPadding(Insets padding) {
        this.getWebUI().setPadding(padding);
    }

    private WebStyledLabelUI getWebUI() {
        return (WebStyledLabelUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebStyledLabelUI)) {
            try {
                this.setUI((WebStyledLabelUI)ReflectUtils.createInstance((String)WebLookAndFeel.styledLabelUI, (Object[])new Object[0]));
            }
            catch (Throwable e) {
                Log.error((Object)this, (Throwable)e);
                this.setUI(new WebStyledLabelUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    @Override
    public String getUIClassID() {
        return StyleableComponent.styledlabel.getUIClassID();
    }

    @Override
    public MouseAdapter onMousePress(MouseEventRunnable runnable) {
        return EventUtils.onMousePress(this, runnable);
    }

    @Override
    public MouseAdapter onMousePress(MouseButton mouseButton, MouseEventRunnable runnable) {
        return EventUtils.onMousePress(this, mouseButton, runnable);
    }

    @Override
    public MouseAdapter onMouseEnter(MouseEventRunnable runnable) {
        return EventUtils.onMouseEnter(this, runnable);
    }

    @Override
    public MouseAdapter onMouseExit(MouseEventRunnable runnable) {
        return EventUtils.onMouseExit(this, runnable);
    }

    @Override
    public MouseAdapter onMouseDrag(MouseEventRunnable runnable) {
        return EventUtils.onMouseDrag(this, runnable);
    }

    @Override
    public MouseAdapter onMouseDrag(MouseButton mouseButton, MouseEventRunnable runnable) {
        return EventUtils.onMouseDrag(this, mouseButton, runnable);
    }

    @Override
    public MouseAdapter onMouseClick(MouseEventRunnable runnable) {
        return EventUtils.onMouseClick(this, runnable);
    }

    @Override
    public MouseAdapter onMouseClick(MouseButton mouseButton, MouseEventRunnable runnable) {
        return EventUtils.onMouseClick(this, mouseButton, runnable);
    }

    @Override
    public MouseAdapter onDoubleClick(MouseEventRunnable runnable) {
        return EventUtils.onDoubleClick(this, runnable);
    }

    @Override
    public MouseAdapter onMenuTrigger(MouseEventRunnable runnable) {
        return EventUtils.onMenuTrigger(this, runnable);
    }

    @Override
    public KeyAdapter onKeyType(KeyEventRunnable runnable) {
        return EventUtils.onKeyType(this, runnable);
    }

    @Override
    public KeyAdapter onKeyType(HotkeyData hotkey, KeyEventRunnable runnable) {
        return EventUtils.onKeyType(this, hotkey, runnable);
    }

    @Override
    public KeyAdapter onKeyPress(KeyEventRunnable runnable) {
        return EventUtils.onKeyPress(this, runnable);
    }

    @Override
    public KeyAdapter onKeyPress(HotkeyData hotkey, KeyEventRunnable runnable) {
        return EventUtils.onKeyPress(this, hotkey, runnable);
    }

    @Override
    public KeyAdapter onKeyRelease(KeyEventRunnable runnable) {
        return EventUtils.onKeyRelease(this, runnable);
    }

    @Override
    public KeyAdapter onKeyRelease(HotkeyData hotkey, KeyEventRunnable runnable) {
        return EventUtils.onKeyRelease(this, hotkey, runnable);
    }

    @Override
    public FocusAdapter onFocusGain(FocusEventRunnable runnable) {
        return EventUtils.onFocusGain(this, runnable);
    }

    @Override
    public FocusAdapter onFocusLoss(FocusEventRunnable runnable) {
        return EventUtils.onFocusLoss(this, runnable);
    }

    @Override
    public WebCustomTooltip setToolTip(String tooltip) {
        return TooltipManager.setTooltip((Component)this, tooltip);
    }

    @Override
    public WebCustomTooltip setToolTip(Icon icon, String tooltip) {
        return TooltipManager.setTooltip((Component)this, icon, tooltip);
    }

    @Override
    public WebCustomTooltip setToolTip(String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip((Component)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip setToolTip(Icon icon, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip((Component)this, icon, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip setToolTip(String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip((Component)this, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip setToolTip(Icon icon, String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip(this, icon, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip) {
        return TooltipManager.setTooltip((Component)this, tooltip);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip, int delay) {
        return TooltipManager.setTooltip((Component)this, tooltip, delay);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip((Component)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip((Component)this, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(String tooltip) {
        return TooltipManager.addTooltip((Component)this, tooltip);
    }

    @Override
    public WebCustomTooltip addToolTip(Icon icon, String tooltip) {
        return TooltipManager.addTooltip((Component)this, icon, tooltip);
    }

    @Override
    public WebCustomTooltip addToolTip(String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip((Component)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip addToolTip(Icon icon, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip((Component)this, icon, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip addToolTip(String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip((Component)this, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(Icon icon, String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip((Component)this, icon, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip) {
        return TooltipManager.addTooltip((Component)this, tooltip);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip, int delay) {
        return TooltipManager.addTooltip((Component)this, tooltip, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip((Component)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip((Component)this, tooltip, tooltipWay, delay);
    }

    @Override
    public void removeToolTip(WebCustomTooltip tooltip) {
        TooltipManager.removeTooltip(this, tooltip);
    }

    @Override
    public void removeToolTips() {
        TooltipManager.removeTooltips(this);
    }

    @Override
    public void removeToolTips(WebCustomTooltip ... tooltips) {
        TooltipManager.removeTooltips((Component)this, tooltips);
    }

    @Override
    public void removeToolTips(List<WebCustomTooltip> tooltips) {
        TooltipManager.removeTooltips((Component)this, tooltips);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.isLineWrap() ? new Dimension(1, 1) : super.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.isLineWrap() ? new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE) : super.getMaximumSize();
    }

    public void setPreferredWidth(int width) {
        this.preferredWidth = width;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setLanguage(String key, Object ... data) {
        LanguageManager.registerComponent((JComponent)this, (String)key, (Object[])data);
    }

    public void updateLanguage(Object ... data) {
        LanguageManager.updateComponent((JComponent)this, (Object[])data);
    }

    public void updateLanguage(String key, Object ... data) {
        LanguageManager.updateComponent((JComponent)this, (String)key, (Object[])data);
    }

    public void removeLanguage() {
        LanguageManager.unregisterComponent((JComponent)this);
    }

    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent((JComponent)this);
    }

    public void setLanguageUpdater(LanguageUpdater updater) {
        LanguageManager.registerLanguageUpdater((JComponent)this, (LanguageUpdater)updater);
    }

    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater((JComponent)this);
    }

    @Override
    public WebStyledLabel setPlainFont() {
        return SwingUtils.setPlainFont(this);
    }

    @Override
    public WebStyledLabel setPlainFont(boolean apply) {
        return SwingUtils.setPlainFont(this, apply);
    }

    @Override
    public boolean isPlainFont() {
        return SwingUtils.isPlainFont(this);
    }

    @Override
    public WebStyledLabel setBoldFont() {
        return SwingUtils.setBoldFont(this);
    }

    @Override
    public WebStyledLabel setBoldFont(boolean apply) {
        return SwingUtils.setBoldFont(this, apply);
    }

    @Override
    public boolean isBoldFont() {
        return SwingUtils.isBoldFont(this);
    }

    @Override
    public WebStyledLabel setItalicFont() {
        return SwingUtils.setItalicFont(this);
    }

    @Override
    public WebStyledLabel setItalicFont(boolean apply) {
        return SwingUtils.setItalicFont(this, apply);
    }

    @Override
    public boolean isItalicFont() {
        return SwingUtils.isItalicFont(this);
    }

    @Override
    public WebStyledLabel setFontStyle(boolean bold, boolean italic) {
        return SwingUtils.setFontStyle(this, bold, italic);
    }

    @Override
    public WebStyledLabel setFontStyle(int style) {
        return SwingUtils.setFontStyle(this, style);
    }

    @Override
    public WebStyledLabel setFontSize(int fontSize) {
        return SwingUtils.setFontSize(this, fontSize);
    }

    @Override
    public WebStyledLabel changeFontSize(int change) {
        return SwingUtils.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return SwingUtils.getFontSize(this);
    }

    @Override
    public WebStyledLabel setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebStyledLabel setFontSizeAndStyle(int fontSize, int style) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebStyledLabel setFontName(String fontName) {
        return SwingUtils.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return SwingUtils.getFontName(this);
    }
}

