/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.statusbar;

import com.alee.extended.statusbar.AdaptiveStatusBarPainter;
import com.alee.extended.statusbar.IStatusBarPainter;
import com.alee.extended.statusbar.StatusBarPainter;
import com.alee.extended.statusbar.StatusBarUI;
import com.alee.extended.statusbar.WebStatusBar;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.swing.DataRunnable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class WebStatusBarUI
extends StatusBarUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    @DefaultPainter(value=StatusBarPainter.class)
    protected IStatusBarPainter painter;
    protected WebStatusBar statusBar;
    protected Insets margin = null;
    protected Insets padding = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebStatusBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.statusBar = (WebStatusBar)c;
        StyleManager.installSkin(this.statusBar);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.statusBar);
        this.statusBar = null;
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.statusBar);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.statusBar, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.statusBar, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.statusBar, new DataRunnable<IStatusBarPainter>(){

            public void run(IStatusBarPainter newPainter) {
                WebStatusBarUI.this.painter = newPainter;
            }
        }, this.painter, painter, IStatusBarPainter.class, AdaptiveStatusBarPainter.class);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return null;
    }
}

