/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.AsyncNodeState;
import com.alee.extended.tree.AsyncTreeDataProvider;
import com.alee.extended.tree.AsyncTreeModelAdapter;
import com.alee.extended.tree.AsyncTreeModelListener;
import com.alee.extended.tree.AsyncTreeQueue;
import com.alee.extended.tree.AsyncUniqueNode;
import com.alee.extended.tree.ChildrenListener;
import com.alee.extended.tree.WebAsyncTree;
import com.alee.laf.tree.TreeState;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTreeModel;
import com.alee.utils.CollectionUtils;
import com.alee.utils.MapUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.collection.DoubleMap;
import com.alee.utils.compare.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class AsyncTreeModel<E extends AsyncUniqueNode>
extends WebTreeModel<E> {
    protected final Object modelListenersLock = new Object();
    protected final List<AsyncTreeModelListener> asyncTreeModelListeners = new ArrayList<AsyncTreeModelListener>(1);
    protected final WebAsyncTree<E> tree;
    protected final AsyncTreeDataProvider<E> dataProvider;
    protected boolean asyncLoading = true;
    protected E rootNode = null;
    protected final Object cacheLock = new Object();
    protected final Map<String, Boolean> nodeCached = new HashMap<String, Boolean>();
    protected final Map<String, List<E>> rawNodeChildrenCache = new HashMap<String, List<E>>();
    protected final DoubleMap<String, E> nodeById = new DoubleMap();
    protected final Object busyLock = new Object();

    public AsyncTreeModel(WebAsyncTree<E> tree, AsyncTreeDataProvider<E> dataProvider) {
        super(null);
        this.tree = tree;
        this.dataProvider = dataProvider;
    }

    public boolean isAsyncLoading() {
        return this.asyncLoading;
    }

    public void setAsyncLoading(boolean asyncLoading) {
        this.asyncLoading = asyncLoading;
    }

    public AsyncTreeDataProvider<E> getDataProvider() {
        return this.dataProvider;
    }

    public E getRoot() {
        if (this.rootNode == null) {
            this.rootNode = this.dataProvider.getRoot();
            this.cacheNodeById(this.rootNode);
            ((AsyncUniqueNode)this.rootNode).attachLoadIconObserver(this.tree);
        }
        return this.rootNode;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.dataProvider.isLeaf((AsyncUniqueNode)node);
    }

    @Override
    public int getChildCount(Object parent) {
        AsyncUniqueNode node = (AsyncUniqueNode)parent;
        if (this.isLeaf(node)) {
            return 0;
        }
        if (this.areChildrenLoaded(node)) {
            return super.getChildCount(parent);
        }
        return this.loadChildren(node);
    }

    public E getChild(Object parent, int index) {
        AsyncUniqueNode node = (AsyncUniqueNode)parent;
        if (this.areChildrenLoaded(node)) {
            return (E)((AsyncUniqueNode)super.getChild(parent, index));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areChildrenLoaded(E node) {
        Object object = this.cacheLock;
        synchronized (object) {
            Boolean cached = this.nodeCached.get(((UniqueNode)node).getId());
            return cached != null && cached != false;
        }
    }

    @Override
    public void reload(TreeNode node) {
        this.tree.cancelEditing();
        this.clearNodeChildrenCache((AsyncUniqueNode)node, false);
        super.reload(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearNodeChildrenCache(E node, boolean clearNode) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (clearNode) {
                this.nodeById.remove((Object)((UniqueNode)node).getId());
            }
            this.nodeCached.remove(((UniqueNode)node).getId());
            List<E> children = this.rawNodeChildrenCache.remove(((UniqueNode)node).getId());
            if (children != null) {
                this.clearNodeChildrenCache(children, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearNodeChildrenCache(List<E> nodes, boolean clearNodes) {
        Object object = this.cacheLock;
        synchronized (object) {
            for (AsyncUniqueNode node : nodes) {
                this.clearNodeChildrenCache(node, clearNodes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearNodeChildrenCache(E[] nodes, boolean clearNodes) {
        Object object = this.cacheLock;
        synchronized (object) {
            for (E node : nodes) {
                this.clearNodeChildrenCache(node, clearNodes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheNodeById(E node) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.nodeById.put((Object)((UniqueNode)node).getId(), node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheNodesById(List<E> nodes) {
        Object object = this.cacheLock;
        synchronized (object) {
            for (AsyncUniqueNode node : nodes) {
                this.nodeById.put((Object)node.getId(), (Object)node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int loadChildren(E parent) {
        Object object = this.busyLock;
        synchronized (object) {
            if (((AsyncUniqueNode)parent).isLoading()) {
                return 0;
            }
            ((AsyncUniqueNode)parent).setState(AsyncNodeState.loading);
            this.nodeChanged((TreeNode)parent);
        }
        this.fireChildrenLoadStarted(parent);
        int childCount = ((DefaultMutableTreeNode)parent).getChildCount();
        if (childCount > 0) {
            int[] indices = new int[childCount];
            Object[] children = new Object[childCount];
            for (int i = childCount - 1; i >= 0; --i) {
                indices[i] = i;
                children[i] = ((AsyncUniqueNode)parent).getChildAt(i);
                ((DefaultMutableTreeNode)parent).remove(i);
            }
            this.nodesWereRemoved((TreeNode)parent, indices, children);
        }
        if (this.asyncLoading) {
            AsyncTreeQueue.execute(this.tree, new Runnable((AsyncUniqueNode)parent){
                final /* synthetic */ AsyncUniqueNode val$parent;
                {
                    this.val$parent = asyncUniqueNode;
                }

                @Override
                public void run() {
                    AsyncTreeModel.this.dataProvider.loadChildren(this.val$parent, new ChildrenListener<E>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void loadCompleted(List<E> children) {
                            Object object = AsyncTreeModel.this.cacheLock;
                            synchronized (object) {
                                AsyncTreeModel.this.rawNodeChildrenCache.put(val$parent.getId(), children);
                                AsyncTreeModel.this.cacheNodesById(children);
                            }
                            final List<AsyncUniqueNode> realChildren = AsyncTreeModel.this.filterAndSort(val$parent, children);
                            Object object2 = AsyncTreeModel.this.cacheLock;
                            synchronized (object2) {
                                AsyncTreeModel.this.nodeCached.put(val$parent.getId(), true);
                            }
                            SwingUtils.invokeLater((Runnable)new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    if (realChildren != null && realChildren.size() > 0) {
                                        AsyncTreeModel.this.insertNodesIntoImpl(realChildren, val$parent, 0);
                                    }
                                    Object object = AsyncTreeModel.this.busyLock;
                                    synchronized (object) {
                                        val$parent.setState(AsyncNodeState.loaded);
                                        AsyncTreeModel.this.nodeChanged(val$parent);
                                    }
                                    AsyncTreeModel.this.fireChildrenLoadCompleted(val$parent, realChildren);
                                }
                            });
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void loadFailed(final Throwable cause) {
                            Object object = AsyncTreeModel.this.cacheLock;
                            synchronized (object) {
                                AsyncTreeModel.this.rawNodeChildrenCache.put(val$parent.getId(), new ArrayList(0));
                                AsyncTreeModel.this.nodeCached.put(val$parent.getId(), true);
                            }
                            SwingUtils.invokeLater((Runnable)new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    Object object = AsyncTreeModel.this.busyLock;
                                    synchronized (object) {
                                        val$parent.setState(AsyncNodeState.failed);
                                        val$parent.setFailureCause(cause);
                                        AsyncTreeModel.this.nodeChanged(val$parent);
                                    }
                                    AsyncTreeModel.this.fireChildrenLoadFailed(val$parent, cause);
                                }
                            });
                        }
                    });
                }
            });
            return 0;
        }
        this.dataProvider.loadChildren(parent, new ChildrenListener<E>((AsyncUniqueNode)parent){
            final /* synthetic */ AsyncUniqueNode val$parent;
            {
                this.val$parent = asyncUniqueNode;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void loadCompleted(List<E> children) {
                Object object = AsyncTreeModel.this.cacheLock;
                synchronized (object) {
                    AsyncTreeModel.this.rawNodeChildrenCache.put(this.val$parent.getId(), children);
                    AsyncTreeModel.this.cacheNodesById(children);
                }
                List<AsyncUniqueNode> realChildren = AsyncTreeModel.this.filterAndSort(this.val$parent, children);
                Object object2 = AsyncTreeModel.this.cacheLock;
                synchronized (object2) {
                    AsyncTreeModel.this.nodeCached.put(this.val$parent.getId(), true);
                }
                if (realChildren != null && realChildren.size() > 0) {
                    AsyncTreeModel.this.insertNodesIntoImpl(realChildren, this.val$parent, 0);
                }
                object2 = AsyncTreeModel.this.busyLock;
                synchronized (object2) {
                    this.val$parent.setState(AsyncNodeState.loaded);
                    AsyncTreeModel.this.nodeChanged(this.val$parent);
                }
                AsyncTreeModel.this.fireChildrenLoadCompleted(this.val$parent, realChildren);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void loadFailed(Throwable cause) {
                Object object = AsyncTreeModel.this.cacheLock;
                synchronized (object) {
                    AsyncTreeModel.this.rawNodeChildrenCache.put(this.val$parent.getId(), new ArrayList(0));
                    AsyncTreeModel.this.nodeCached.put(this.val$parent.getId(), true);
                }
                object = AsyncTreeModel.this.busyLock;
                synchronized (object) {
                    this.val$parent.setState(AsyncNodeState.failed);
                    this.val$parent.setFailureCause(cause);
                    AsyncTreeModel.this.nodeChanged(this.val$parent);
                }
                AsyncTreeModel.this.fireChildrenLoadFailed(this.val$parent, cause);
            }
        });
        return ((DefaultMutableTreeNode)parent).getChildCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildNodes(E parent, final List<E> children) {
        Object object = this.busyLock;
        synchronized (object) {
            if (((AsyncUniqueNode)parent).isLoading()) {
                return;
            }
            ((AsyncUniqueNode)parent).setState(AsyncNodeState.loading);
            this.nodeChanged((TreeNode)parent);
        }
        object = this.cacheLock;
        synchronized (object) {
            this.rawNodeChildrenCache.put(((UniqueNode)parent).getId(), children);
            this.cacheNodesById(children);
        }
        final List<E> realChildren = this.filterAndSort(parent, children);
        Object object2 = this.cacheLock;
        synchronized (object2) {
            this.nodeCached.put(((UniqueNode)parent).getId(), true);
        }
        SwingUtils.invokeLater((Runnable)new Runnable((AsyncUniqueNode)parent){
            final /* synthetic */ AsyncUniqueNode val$parent;
            {
                this.val$parent = asyncUniqueNode;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (realChildren != null && realChildren.size() > 0) {
                    AsyncTreeModel.this.clearNodeChildrenCache(children, false);
                    AsyncTreeModel.this.insertNodesIntoImpl(realChildren, this.val$parent, 0);
                }
                Object object = AsyncTreeModel.this.busyLock;
                synchronized (object) {
                    this.val$parent.setState(AsyncNodeState.loaded);
                    AsyncTreeModel.this.nodeChanged(this.val$parent);
                }
                AsyncTreeModel.this.fireChildrenLoadCompleted(this.val$parent, realChildren);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildNodes(E parent, List<E> children) {
        if (!((AsyncUniqueNode)parent).isLoaded()) {
            return;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            List<E> cachedChildren = this.rawNodeChildrenCache.get(((UniqueNode)parent).getId());
            if (cachedChildren == null) {
                cachedChildren = new ArrayList(children.size());
                this.rawNodeChildrenCache.put(((UniqueNode)parent).getId(), cachedChildren);
            }
            cachedChildren.addAll(children);
            this.cacheNodesById(children);
        }
        this.clearNodeChildrenCache(children, false);
        this.insertNodesIntoImpl(children, parent, ((DefaultMutableTreeNode)parent).getChildCount());
        this.updateSortingAndFiltering(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodeFromParent(MutableTreeNode node) {
        if (node == null) {
            return;
        }
        AsyncUniqueNode childNode = (AsyncUniqueNode)node;
        AsyncUniqueNode parentNode = childNode.getParent();
        if (parentNode == null || !parentNode.isLoaded()) {
            return;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            List<E> children = this.rawNodeChildrenCache.get(parentNode.getId());
            if (children != null) {
                children.remove(childNode);
            }
        }
        this.clearNodeChildrenCache(childNode, true);
        childNode.removeAllChildren();
        super.removeNodeFromParent(node);
        this.updateSortingAndFiltering(parentNode);
        childNode.detachLoadIconObserver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        AsyncUniqueNode childNode = (AsyncUniqueNode)newChild;
        AsyncUniqueNode parentNode = (AsyncUniqueNode)parent;
        if (!parentNode.isLoaded()) {
            return;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            List<AsyncUniqueNode> cachedChildren = this.rawNodeChildrenCache.get(parentNode.getId());
            if (cachedChildren == null) {
                cachedChildren = new ArrayList(1);
                this.rawNodeChildrenCache.put(parentNode.getId(), cachedChildren);
            }
            cachedChildren.add(index, childNode);
            this.cacheNodeById(childNode);
        }
        this.clearNodeChildrenCache(childNode, false);
        this.insertNodeIntoImpl(childNode, parentNode, index);
        this.updateSortingAndFiltering(parentNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertNodesInto(List<E> children, E parent, int index) {
        if (!((AsyncUniqueNode)parent).isLoaded()) {
            return;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            List<E> cachedChildren = this.rawNodeChildrenCache.get(((UniqueNode)parent).getId());
            if (cachedChildren == null) {
                cachedChildren = new ArrayList(1);
                this.rawNodeChildrenCache.put(((UniqueNode)parent).getId(), cachedChildren);
            }
            cachedChildren.addAll(index, children);
            this.cacheNodesById(children);
        }
        this.clearNodeChildrenCache(children, false);
        this.insertNodesIntoImpl(children, parent, index);
        this.updateSortingAndFiltering(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertNodesInto(E[] children, E parent, int index) {
        if (!((AsyncUniqueNode)parent).isLoaded()) {
            return;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            List<E> cachedChildren = this.rawNodeChildrenCache.get(((UniqueNode)parent).getId());
            if (cachedChildren == null) {
                cachedChildren = new ArrayList(1);
                this.rawNodeChildrenCache.put(((UniqueNode)parent).getId(), cachedChildren);
            }
            for (int i = children.length - 1; i >= 0; --i) {
                cachedChildren.add(index, children[i]);
            }
            this.cacheNodesById(Arrays.asList(children));
        }
        this.clearNodeChildrenCache((E)children, false);
        this.insertNodesIntoImpl((AsyncUniqueNode[])children, (AsyncUniqueNode)parent, index);
        this.updateSortingAndFiltering(parent);
    }

    protected void insertNodeIntoImpl(E child, E parent, int index) {
        super.insertNodeInto((MutableTreeNode)child, (MutableTreeNode)parent, index);
        ((AsyncUniqueNode)child).attachLoadIconObserver(this.tree);
    }

    protected void insertNodesIntoImpl(List<E> children, E parent, int index) {
        super.insertNodesInto(children, parent, index);
        for (AsyncUniqueNode child : children) {
            child.attachLoadIconObserver(this.tree);
        }
    }

    protected void insertNodesIntoImpl(E[] children, E parent, int index) {
        super.insertNodesInto(children, parent, index);
        for (E child : children) {
            ((AsyncUniqueNode)child).attachLoadIconObserver(this.tree);
        }
    }

    public void updateSortingAndFiltering() {
        this.updateSortingAndFiltering(this.getRoot(), true);
    }

    public void updateSortingAndFiltering(E parentNode) {
        this.updateSortingAndFiltering(parentNode, false);
    }

    public void updateSortingAndFiltering(E parentNode, boolean recursively) {
        if (parentNode != null) {
            this.updateSortingAndFilteringImpl(parentNode, recursively, true);
        }
    }

    protected void updateSortingAndFilteringImpl(E parentNode, boolean recursively, boolean performUpdates) {
        if (((AsyncUniqueNode)parentNode).isLoaded() && this.rawNodeChildrenCache.containsKey(((UniqueNode)parentNode).getId())) {
            this.performSortingAndFiltering(parentNode, recursively, performUpdates);
        } else if (((AsyncUniqueNode)parentNode).isLoading()) {
            this.addAsyncTreeModelListener(new AsyncTreeModelAdapter((AsyncUniqueNode)parentNode, recursively, performUpdates){
                final /* synthetic */ AsyncUniqueNode val$parentNode;
                final /* synthetic */ boolean val$recursively;
                final /* synthetic */ boolean val$performUpdates;
                {
                    this.val$parentNode = asyncUniqueNode;
                    this.val$recursively = bl;
                    this.val$performUpdates = bl2;
                }

                @Override
                public void loadCompleted(AsyncUniqueNode parent, List children) {
                    if (this.val$parentNode.getId().equals(parent.getId())) {
                        AsyncTreeModel.this.removeAsyncTreeModelListener(this);
                        AsyncTreeModel.this.performSortingAndFiltering(this.val$parentNode, this.val$recursively, this.val$performUpdates);
                    }
                }

                @Override
                public void loadFailed(AsyncUniqueNode parent, Throwable cause) {
                    if (this.val$parentNode.getId().equals(parent.getId())) {
                        AsyncTreeModel.this.removeAsyncTreeModelListener(this);
                    }
                }
            });
        }
    }

    protected void performSortingAndFiltering(E parentNode, boolean recursively, boolean performUpdates) {
        TreeState treeState = this.tree.getTreeState();
        List<E> cachedChildren = this.rawNodeChildrenCache.get(((UniqueNode)parentNode).getId());
        if (cachedChildren != null) {
            ((DefaultMutableTreeNode)parentNode).removeAllChildren();
            List<E> children = this.filterAndSort(parentNode, cachedChildren);
            for (AsyncUniqueNode child : children) {
                ((DefaultMutableTreeNode)parentNode).add(child);
            }
        }
        if (recursively) {
            for (int i = 0; i < ((DefaultMutableTreeNode)parentNode).getChildCount(); ++i) {
                this.updateSortingAndFilteringImpl(((AsyncUniqueNode)parentNode).getChildAt(i), true, false);
            }
        }
        if (performUpdates) {
            this.nodeStructureChanged((TreeNode)parentNode);
            this.tree.setTreeState(treeState);
        }
    }

    protected List<E> filterAndSort(E parentNode, List<E> children) {
        if (children == null || children.size() == 0) {
            return new ArrayList(0);
        }
        Filter<E> filter = this.dataProvider.getChildrenFilter(parentNode);
        Comparator<E> comparator = this.dataProvider.getChildrenComparator(parentNode);
        if (filter != null) {
            ArrayList filtered = CollectionUtils.filter(children, filter);
            if (comparator != null) {
                Collections.sort(filtered, comparator);
            }
            return filtered;
        }
        if (comparator != null) {
            children = CollectionUtils.copy(children);
            Collections.sort(children, comparator);
        }
        return children;
    }

    public E findNode(String nodeId) {
        return (E)((AsyncUniqueNode)this.nodeById.get((Object)nodeId));
    }

    public DoubleMap<String, E> getNodesCache() {
        return MapUtils.copyDoubleMap(this.nodeById);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AsyncTreeModelListener> getAsyncTreeModelListeners() {
        Object object = this.modelListenersLock;
        synchronized (object) {
            return CollectionUtils.copy(this.asyncTreeModelListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAsyncTreeModelListener(AsyncTreeModelListener listener) {
        Object object = this.modelListenersLock;
        synchronized (object) {
            this.asyncTreeModelListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAsyncTreeModelListener(AsyncTreeModelListener listener) {
        Object object = this.modelListenersLock;
        synchronized (object) {
            this.asyncTreeModelListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChildrenLoadStarted(E parent) {
        ArrayList listeners;
        Iterator iterator = this.modelListenersLock;
        synchronized (iterator) {
            listeners = CollectionUtils.copy(this.asyncTreeModelListeners);
        }
        for (AsyncTreeModelListener listener : listeners) {
            listener.loadStarted(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChildrenLoadCompleted(E parent, List<E> children) {
        ArrayList listeners;
        Iterator iterator = this.modelListenersLock;
        synchronized (iterator) {
            listeners = CollectionUtils.copy(this.asyncTreeModelListeners);
        }
        for (AsyncTreeModelListener listener : listeners) {
            listener.loadCompleted(parent, children);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChildrenLoadFailed(E parent, Throwable cause) {
        ArrayList listeners;
        Iterator iterator = this.modelListenersLock;
        synchronized (iterator) {
            listeners = CollectionUtils.copy(this.asyncTreeModelListeners);
        }
        for (AsyncTreeModelListener listener : listeners) {
            listener.loadFailed(parent, cause);
        }
    }
}

