/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.IconSupport;
import com.alee.extended.tree.AsyncNodeState;
import com.alee.extended.tree.NodeImageObserver;
import com.alee.extended.tree.WebAsyncTree;
import com.alee.laf.tree.UniqueNode;
import com.alee.utils.ImageUtils;
import com.alee.utils.swing.BroadcastImageObserver;
import com.alee.utils.swing.LoadIconType;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class AsyncUniqueNode
extends UniqueNode
implements IconSupport,
Serializable {
    protected static final Icon failedStateIcon = new ImageIcon(AsyncUniqueNode.class.getResource("icons/failed.png"));
    protected static final Map<Icon, Icon> failedStateIcons = new WeakHashMap<Icon, Icon>(5);
    public static LoadIconType loadIconType = LoadIconType.roller;
    protected AsyncNodeState state = AsyncNodeState.waiting;
    protected ImageObserver observer = null;
    protected Throwable failureCause = null;

    public AsyncUniqueNode() {
    }

    public AsyncUniqueNode(Object userObject) {
        super(userObject);
    }

    public AsyncUniqueNode(String id, Object userObject) {
        super(id, userObject);
    }

    public AsyncNodeState getState() {
        return this.state;
    }

    public boolean isWaiting() {
        return this.state == AsyncNodeState.waiting;
    }

    public boolean isLoading() {
        return this.state == AsyncNodeState.loading;
    }

    public boolean isLoaded() {
        return this.state == AsyncNodeState.loaded;
    }

    public boolean isFailed() {
        return this.state == AsyncNodeState.failed;
    }

    public void setState(AsyncNodeState state) {
        this.state = state;
    }

    public Throwable getFailureCause() {
        return this.failureCause;
    }

    public void setFailureCause(Throwable failureCause) {
        this.failureCause = failureCause;
    }

    public Icon getIcon() {
        if (this.isLoading()) {
            return this.getLoadIcon();
        }
        Icon icon = this.getNodeIcon();
        return icon != null && this.isFailed() ? this.getFailedStateIcon(icon) : icon;
    }

    public Icon getLoadIcon() {
        return loadIconType != null ? loadIconType.getIcon() : null;
    }

    public void attachLoadIconObserver(WebAsyncTree tree) {
        Icon icon = this.getLoadIcon();
        if (icon != null && icon instanceof ImageIcon) {
            ImageIcon imageIcon = (ImageIcon)icon;
            ImageObserver existing = imageIcon.getImageObserver();
            if (existing == null) {
                imageIcon.setImageObserver(new BroadcastImageObserver());
            } else if (existing instanceof BroadcastImageObserver) {
                if (this.observer == null) {
                    this.observer = new NodeImageObserver(tree, this);
                }
                ((BroadcastImageObserver)existing).addObserver(this.observer);
            }
        }
    }

    public void detachLoadIconObserver() {
        ImageIcon imageIcon;
        ImageObserver existing;
        Icon icon;
        if (this.observer != null && (icon = this.getLoadIcon()) != null && icon instanceof ImageIcon && (existing = (imageIcon = (ImageIcon)icon).getImageObserver()) instanceof BroadcastImageObserver) {
            ((BroadcastImageObserver)existing).removeObserver(this.observer);
        }
    }

    public abstract Icon getNodeIcon();

    public Icon getFailedStateIcon(Icon icon) {
        Icon failedIcon = failedStateIcons.get(icon);
        if (failedIcon == null) {
            failedIcon = ImageUtils.mergeIcons((Icon[])new Icon[]{icon, failedStateIcon});
            failedStateIcons.put(icon, failedIcon);
        }
        return failedIcon;
    }

    @Override
    public AsyncUniqueNode getParent() {
        return (AsyncUniqueNode)super.getParent();
    }

    @Override
    public AsyncUniqueNode getChildAt(int index) {
        return (AsyncUniqueNode)super.getChildAt(index);
    }
}

