/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.IconSupport;
import com.alee.api.TitleSupport;
import com.alee.extended.tree.AsyncUniqueNode;
import com.alee.utils.FileUtils;
import java.io.File;
import javax.swing.Icon;

public class FileTreeNode
extends AsyncUniqueNode
implements IconSupport,
TitleSupport {
    public static final String rootId = "File.tree.root";
    protected File file;
    protected String title = null;

    public FileTreeNode(File file) {
        this.file = file;
    }

    @Override
    public String getId() {
        return this.file != null ? this.file.getAbsolutePath() : rootId;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public Icon getNodeIcon() {
        return this.file != null ? FileUtils.getFileIcon((File)this.file, (boolean)false) : null;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        if (this.file != null) {
            String name = FileUtils.getDisplayFileName((File)this.file);
            if (name != null && !name.trim().equals("")) {
                return name;
            }
            name = this.file.getName();
            if (!name.trim().equals("")) {
                return name != null ? name : "";
            }
            return FileUtils.getFileDescription((File)this.file, null).getDescription();
        }
        return rootId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public FileTreeNode getParent() {
        return (FileTreeNode)super.getParent();
    }

    @Override
    public FileTreeNode getChildAt(int index) {
        return (FileTreeNode)super.getChildAt(index);
    }

    public int indexOfFileChild(File file) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!FileUtils.equals((File)this.getChildAt(i).getFile(), (File)file)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String toString() {
        return this.getTitle();
    }
}

