/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.window;

import com.alee.api.Behavior;
import com.alee.managers.style.Bounds;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import javax.swing.JTree;
import javax.swing.SwingUtilities;

public class ComponentMoveBehavior
extends MouseAdapter
implements Behavior {
    protected Component toDrag;
    protected boolean dragging = false;
    protected Component dragged = null;
    protected Point initialPoint = null;
    protected Rectangle initialBounds = null;

    public ComponentMoveBehavior() {
        this(null);
    }

    public ComponentMoveBehavior(Component toDrag) {
        this.toDrag = toDrag;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.getSource() instanceof Component && ((Component)e.getSource()).isEnabled()) {
            this.dragged = this.getDraggedComponent(e);
            if (this.dragged != null) {
                Rectangle dragStartBounds = this.getDragStartBounds(e);
                if (dragStartBounds != null && dragStartBounds.contains(e.getPoint())) {
                    this.dragging = true;
                    this.initialPoint = MouseInfo.getPointerInfo().getLocation();
                    this.initialBounds = this.dragged.getBounds();
                } else {
                    this.dragged = null;
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dragging) {
            Point point = MouseInfo.getPointerInfo().getLocation();
            this.dragged.setLocation(this.initialBounds.x + (point.x - this.initialPoint.x), this.initialBounds.y + (point.y - this.initialPoint.y));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.dragging) {
            this.dragging = false;
            this.dragged = null;
            this.initialPoint = null;
            this.initialBounds = null;
        }
    }

    protected Component getDraggedComponent(MouseEvent e) {
        return this.toDrag == null ? SwingUtils.getWindowAncestor((Component)e.getComponent()) : this.toDrag;
    }

    protected Rectangle getDragStartBounds(MouseEvent e) {
        return Bounds.margin.of(e.getComponent());
    }

    public static void install(Component component) {
        ComponentMoveBehavior.install(component, null);
    }

    public static ComponentMoveBehavior install(Component component, Component toDrag) {
        ComponentMoveBehavior.uninstall(component);
        ComponentMoveBehavior behavior = new ComponentMoveBehavior(toDrag);
        component.addMouseListener(behavior);
        component.addMouseMotionListener(behavior);
        return behavior;
    }

    public static void uninstall(Component component) {
        for (MouseListener mouseListener : component.getMouseListeners()) {
            if (!(mouseListener instanceof ComponentMoveBehavior)) continue;
            component.removeMouseListener(mouseListener);
        }
        for (EventListener eventListener : component.getMouseMotionListeners()) {
            if (!(eventListener instanceof ComponentMoveBehavior)) continue;
            component.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
    }

    public static boolean isInstalled(JTree tree) {
        for (MouseMotionListener listener : tree.getMouseMotionListeners()) {
            if (!(listener instanceof ComponentMoveBehavior)) continue;
            return true;
        }
        return false;
    }
}

