/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.button;

import com.alee.laf.button.IAbstractButtonPainter;
import com.alee.managers.style.Bounds;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.CompareUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;

public abstract class AbstractButtonPainter<E extends AbstractButton, U extends BasicButtonUI, D extends IDecoration<E, D>>
extends AbstractDecorationPainter<E, U, D>
implements IAbstractButtonPainter<E, U> {
    protected ChangeListener modelChangeListener;
    protected Color selectedForeground;
    protected Rectangle viewRect = new Rectangle();
    protected Rectangle textRect = new Rectangle();
    protected Rectangle iconRect = new Rectangle();

    @Override
    public void install(E c, U ui) {
        super.install(c, ui);
        this.modelChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractButtonPainter.this.updateDecorationState();
            }
        };
        ((AbstractButton)this.component).getModel().addChangeListener(this.modelChangeListener);
    }

    @Override
    public void uninstall(E c, U ui) {
        ((AbstractButton)this.component).getModel().removeChangeListener(this.modelChangeListener);
        this.modelChangeListener = null;
        super.uninstall(c, ui);
    }

    @Override
    protected void propertyChange(String property, Object oldValue, Object newValue) {
        super.propertyChange(property, oldValue, newValue);
        if (CompareUtils.equals((Object)property, (Object[])new Object[]{"model"})) {
            ((ButtonModel)oldValue).removeChangeListener(this.modelChangeListener);
            ((ButtonModel)newValue).addChangeListener(this.modelChangeListener);
        }
    }

    @Override
    protected List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        ButtonModel model = ((AbstractButton)this.component).getModel();
        if (model.isPressed()) {
            states.add("pressed");
        }
        if (model.isSelected()) {
            states.add("selected");
        }
        return states;
    }

    @Override
    protected Boolean isOpaqueUndecorated() {
        return false;
    }

    @Override
    protected void paintContent(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        FontMetrics fm = ((JComponent)c).getFontMetrics(((Component)c).getFont());
        this.calculateBounds(fm);
        this.paintIcon(g2d);
        this.paintText(g2d);
    }

    protected void calculateBounds(FontMetrics fm) {
        this.viewRect = Bounds.padding.of(this.component);
        this.textRect.height = 0;
        this.textRect.width = 0;
        this.textRect.y = 0;
        this.textRect.x = 0;
        this.iconRect.height = 0;
        this.iconRect.width = 0;
        this.iconRect.y = 0;
        this.iconRect.x = 0;
        SwingUtilities.layoutCompoundLabel(this.component, fm, ((AbstractButton)this.component).getText(), ((AbstractButton)this.component).getIcon(), ((AbstractButton)this.component).getVerticalAlignment(), ((AbstractButton)this.component).getHorizontalAlignment(), ((AbstractButton)this.component).getVerticalTextPosition(), ((AbstractButton)this.component).getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, ((AbstractButton)this.component).getText() == null ? 0 : ((AbstractButton)this.component).getIconTextGap());
    }

    protected void paintIcon(Graphics2D g2d) {
        if (((AbstractButton)this.component).getIcon() != null) {
            Icon icon = ((AbstractButton)this.component).getIcon();
            Icon tmpIcon = null;
            if (icon == null) {
                return;
            }
            Icon selectedIcon = null;
            ButtonModel model = ((AbstractButton)this.component).getModel();
            if (model.isSelected() && (selectedIcon = ((AbstractButton)this.component).getSelectedIcon()) != null) {
                icon = selectedIcon;
            }
            if (!model.isEnabled()) {
                if (model.isSelected() && (tmpIcon = ((AbstractButton)this.component).getDisabledSelectedIcon()) == null) {
                    tmpIcon = selectedIcon;
                }
                if (tmpIcon == null) {
                    tmpIcon = ((AbstractButton)this.component).getDisabledIcon();
                }
            } else if (model.isPressed() && model.isArmed()) {
                tmpIcon = ((AbstractButton)this.component).getPressedIcon();
            } else if (((AbstractButton)this.component).isRolloverEnabled() && model.isRollover()) {
                if (model.isSelected() && (tmpIcon = ((AbstractButton)this.component).getRolloverSelectedIcon()) == null) {
                    tmpIcon = selectedIcon;
                }
                if (tmpIcon == null) {
                    tmpIcon = ((AbstractButton)this.component).getRolloverIcon();
                }
            }
            if (tmpIcon != null) {
                icon = tmpIcon;
            }
            if (model.isPressed() && model.isArmed()) {
                icon.paintIcon(this.component, g2d, this.iconRect.x, this.iconRect.y);
            } else {
                icon.paintIcon(this.component, g2d, this.iconRect.x, this.iconRect.y);
            }
        }
    }

    protected void paintText(Graphics2D g2d) {
        String text = ((AbstractButton)this.component).getText();
        if (text != null && !text.equals("")) {
            Map map = SwingUtils.setupTextAntialias(g2d);
            View v = (View)((AbstractButton)this.component).getClientProperty("html");
            if (v != null) {
                v.paint(g2d, this.textRect);
            } else {
                FontMetrics fm = SwingUtils.getFontMetrics(this.component, g2d);
                int mnemonicIndex = ((AbstractButton)this.component).getDisplayedMnemonicIndex();
                ButtonModel model = ((AbstractButton)this.component).getModel();
                if (model.isEnabled()) {
                    g2d.setPaint(model.isPressed() || model.isSelected() ? this.selectedForeground : ((AbstractButton)this.component).getForeground());
                    SwingUtils.drawStringUnderlineCharAt(g2d, text, mnemonicIndex, this.textRect.x, this.textRect.y + fm.getAscent());
                } else {
                    g2d.setPaint(((AbstractButton)this.component).getBackground().brighter());
                    SwingUtils.drawStringUnderlineCharAt(g2d, text, mnemonicIndex, this.textRect.x + 1, this.textRect.y + fm.getAscent() + 1);
                    g2d.setPaint(((AbstractButton)this.component).getBackground().darker());
                    SwingUtils.drawStringUnderlineCharAt(g2d, text, mnemonicIndex, this.textRect.x, this.textRect.y + fm.getAscent());
                }
            }
            SwingUtils.restoreTextAntialias(g2d, map);
        }
    }
}

