/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.grouping;

import com.alee.laf.grouping.AbstractGroupingLayout;
import com.alee.laf.grouping.GridSize;
import com.alee.laf.grouping.GroupPaneConstraints;
import com.alee.painter.PainterSupport;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.utils.general.Pair;
import com.alee.utils.swing.SizeType;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingConstants;

@XStreamAlias(value="GroupPaneLayout")
public class GroupPaneLayout
extends AbstractGroupingLayout
implements SwingConstants {
    @XStreamAsAttribute
    protected int orientation;
    @XStreamAsAttribute
    protected int columns;
    @XStreamAsAttribute
    protected int rows;
    protected final transient Map<Component, GroupPaneConstraints> constraints = new HashMap<Component, GroupPaneConstraints>(5);

    public GroupPaneLayout() {
        this(0, Integer.MAX_VALUE, 1);
    }

    public GroupPaneLayout(int orientation) {
        this(orientation, Integer.MAX_VALUE, 1);
    }

    public GroupPaneLayout(int columns, int rows) {
        this(0, columns, rows);
    }

    public GroupPaneLayout(int orientation, int columns, int rows) {
        this.setOrientation(orientation);
        this.setColumns(columns);
        this.setRows(rows);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    @Override
    public void addComponent(Component component, Object c) {
        if (c != null && !(c instanceof GroupPaneConstraints)) {
            throw new RuntimeException("Unsupported layout constraints: " + c);
        }
        this.constraints.put(component, c != null ? (GroupPaneConstraints)c : GroupPaneConstraints.PREFERRED);
        super.addComponent(component, c);
    }

    @Override
    public void removeComponent(Component component) {
        super.removeComponent(component);
        this.constraints.remove(component);
    }

    @Override
    public void layoutContainer(Container parent) {
        GridSize gridSize = this.getActualGridSize(parent);
        Pair<int[], int[]> sizes = this.calculateSizes(parent, gridSize, SizeType.current);
        Insets border = parent.getInsets();
        int y = border.top;
        for (int row = 0; row < gridSize.rows; ++row) {
            int x = border.left;
            for (int column = 0; column < gridSize.columns; ++column) {
                int index = this.pointToIndex(parent, column, row, gridSize);
                Component component = parent.getComponent(index);
                if (component != null) {
                    component.setBounds(x, y, ((int[])sizes.key)[column], ((int[])sizes.value)[row]);
                }
                x += ((int[])sizes.key)[column];
            }
            y += ((int[])sizes.value)[row];
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int n;
        GridSize gridSize = this.getActualGridSize(parent);
        Pair<int[], int[]> sizes = this.calculateSizes(parent, gridSize, SizeType.preferred);
        Dimension ps = new Dimension(0, 0);
        int[] nArray = (int[])sizes.key;
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            Integer columnWith = nArray[n];
            ps.width += columnWith.intValue();
        }
        nArray = (int[])sizes.value;
        n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            Integer rowHeight = nArray[n];
            ps.height += rowHeight.intValue();
        }
        Insets border = parent.getInsets();
        ps.width += border.left + border.right;
        ps.height += border.top + border.bottom;
        return ps;
    }

    public GridSize getActualGridSize(Container parent) {
        int count = parent.getComponentCount();
        if (this.orientation == 0) {
            return new GridSize(Math.min(count, this.columns), (count - 1) / this.columns + 1);
        }
        return new GridSize((count - 1) / this.rows + 1, Math.min(count, this.rows));
    }

    public Component getComponentAt(Container parent, int column, int row) {
        int count;
        GridSize gridSize = this.getActualGridSize(parent);
        int index = this.pointToIndex(parent, column, row, gridSize);
        return index < (count = parent.getComponentCount()) ? parent.getComponent(index) : null;
    }

    public int indexToColumn(Container parent, int index, GridSize gridSize) {
        boolean ltr = parent.getComponentOrientation().isLeftToRight();
        int column = this.orientation == 0 ? index % this.columns : index / this.rows;
        return ltr ? column : gridSize.columns - 1 - column;
    }

    public int indexToRow(int index) {
        return this.orientation == 0 ? index / this.columns : index % this.rows;
    }

    public int pointToIndex(Container parent, int column, int row, GridSize gridSize) {
        boolean ltr = parent.getComponentOrientation().isLeftToRight();
        int c = ltr ? column : gridSize.columns - 1 - column;
        return this.orientation == 0 ? row * this.columns + c : c * this.rows + row;
    }

    protected Pair<int[], int[]> calculateSizes(Container parent, GridSize gridSize, SizeType type) {
        int row;
        int col;
        int count = parent.getComponentCount();
        int cols = gridSize.columns;
        int[] colWidths = new int[cols];
        double[] colPercents = new double[cols];
        int rows = gridSize.rows;
        int[] rowHeights = new int[rows];
        double[] rowPercents = new double[rows];
        for (int i = 0; i < count; ++i) {
            Component component = parent.getComponent(i);
            GroupPaneConstraints c = this.constraints.get(component);
            Dimension ps = component.getPreferredSize();
            col = this.indexToColumn(parent, i, gridSize);
            row = this.indexToRow(i);
            colWidths[col] = Math.max(colWidths[col], (int)Math.floor(c.width > 1.0 ? c.width : (double)ps.width));
            colPercents[col] = Math.max(colPercents[col], 1.0 >= c.width && c.width > 0.0 ? c.width : 0.0);
            rowHeights[row] = Math.max(rowHeights[row], (int)Math.floor(c.height > 1.0 ? c.height : (double)ps.height));
            rowPercents[row] = Math.max(rowPercents[row], 1.0 >= c.height && c.height > 0.0 ? c.height : 0.0);
        }
        Dimension size = parent.getSize();
        Pair<Double, Integer> rc = this.calculateSizes(cols, size.width, colWidths, colPercents);
        Pair<Double, Integer> rr = this.calculateSizes(rows, size.height, rowHeights, rowPercents);
        if (type == SizeType.current) {
            for (int i = 0; i < count; ++i) {
                col = this.indexToColumn(parent, i, gridSize);
                if (colPercents[col] > 0.0 && colPercents[col] <= 1.0) {
                    int pw = (int)Math.floor((double)((Integer)rc.getValue()).intValue() * colPercents[col] / (Double)rc.getKey());
                    colWidths[col] = Math.max(pw, colWidths[col]);
                }
                if (!(rowPercents[row = this.indexToRow(i)] > 0.0) || !(rowPercents[row] <= 1.0)) continue;
                int ph = (int)Math.floor((double)((Integer)rr.getValue()).intValue() * rowPercents[row] / (Double)rr.getKey());
                rowHeights[row] = Math.max(ph, rowHeights[row]);
            }
            this.appendDelta(cols, colWidths, size.width);
            this.appendDelta(rows, rowHeights, size.height);
        }
        return new Pair((Object)colWidths, (Object)rowHeights);
    }

    protected Pair<Double, Integer> calculateSizes(int count, int size, int[] sizes, double[] percents) {
        double freePercents;
        int freeSize;
        boolean changed;
        int[] initSizes = Arrays.copyOf(sizes, count);
        block0: do {
            int i;
            changed = false;
            double maxWeight = 0.0;
            for (i = 0; i < count; ++i) {
                if (!(percents[i] > 0.0)) continue;
                maxWeight = Math.max(maxWeight, (double)initSizes[i] / percents[i]);
            }
            for (i = 0; i < count; ++i) {
                sizes[i] = percents[i] > 0.0 ? (int)Math.floor(maxWeight * percents[i]) : initSizes[i];
            }
            freeSize = size;
            freePercents = 0.0;
            for (i = 0; i < count; ++i) {
                freeSize -= percents[i] == 0.0 ? sizes[i] : 0;
                freePercents += percents[i];
            }
            for (i = 0; i < count; ++i) {
                double availSize;
                if (!(percents[i] > 0.0) || !((double)sizes[i] > (availSize = (double)freeSize * percents[i] / freePercents)) || !((double)initSizes[i] > availSize)) continue;
                percents[i] = 0.0;
                changed = true;
                continue block0;
            }
        } while (changed);
        return new Pair((Object)freePercents, (Object)freeSize);
    }

    protected void appendDelta(int count, int[] sizes, int size) {
        int roughColSize = 0;
        for (int i = 0; i < count; ++i) {
            roughColSize += sizes[i];
        }
        int delta = size - roughColSize;
        if (delta < count) {
            int i = count - 1;
            while (delta > 0) {
                int n = i--;
                sizes[n] = sizes[n] + 1;
                --delta;
            }
        }
    }

    @Override
    protected Pair<String, String> getDescriptors(Container parent, Component component, int index) {
        boolean paintRightLine;
        boolean paintRight;
        boolean paintBottomLine;
        boolean paintBottom;
        boolean paintLeftLine;
        boolean paintLeft;
        boolean paintTopLine;
        boolean paintTop;
        GridSize gridSize = this.getActualGridSize(parent);
        int row = this.indexToRow(index);
        int col = this.indexToColumn(parent, index, gridSize);
        boolean ltr = parent.getComponentOrientation().isLeftToRight();
        if (this.isNeighbourDecoratable(parent, gridSize, col, row, 1)) {
            paintTop = false;
            paintTopLine = false;
        } else if (!this.isPaintTop() && row == 0) {
            paintTop = false;
            paintTopLine = false;
        } else {
            paintTop = true;
            paintTopLine = false;
        }
        if (this.isNeighbourDecoratable(parent, gridSize, col, row, ltr ? 2 : 4)) {
            paintLeft = false;
            paintLeftLine = false;
        } else if (!this.isPaintLeft() && col == (ltr ? 0 : gridSize.columns - 1)) {
            paintLeft = false;
            paintLeftLine = false;
        } else {
            paintLeft = true;
            paintLeftLine = false;
        }
        if (this.isNeighbourDecoratable(parent, gridSize, col, row, 3)) {
            paintBottom = false;
            paintBottomLine = true;
        } else if (!this.isPaintBottom() && row == gridSize.rows - 1) {
            paintBottom = false;
            paintBottomLine = false;
        } else {
            paintBottom = true;
            paintBottomLine = false;
        }
        if (this.isNeighbourDecoratable(parent, gridSize, col, row, ltr ? 4 : 2)) {
            paintRight = false;
            paintRightLine = true;
        } else if (!this.isPaintRight() && col == (ltr ? gridSize.columns - 1 : 0)) {
            paintRight = false;
            paintRightLine = false;
        } else {
            paintRight = true;
            paintRightLine = true;
        }
        String sides = DecorationUtils.toString(paintTop, paintLeft, paintBottom, paintRight);
        String lines = DecorationUtils.toString(paintTopLine, paintLeftLine, paintBottomLine, paintRightLine);
        return new Pair((Object)sides, (Object)lines);
    }

    public boolean isNeighbourDecoratable(Container parent, GridSize gridSize, int col, int row, int direction) {
        Component neighbour = this.getNeighbour(parent, gridSize, col, row, direction);
        return neighbour != null && PainterSupport.isDecoratable(neighbour);
    }

    public Component getNeighbour(Container parent, GridSize gridSize, int col, int row, int direction) {
        if (direction == 1) {
            return row > 0 ? this.getComponentAt(parent, col, row - 1) : null;
        }
        if (direction == 2) {
            return col > 0 ? this.getComponentAt(parent, col - 1, row) : null;
        }
        if (direction == 3) {
            return row < gridSize.rows - 1 ? this.getComponentAt(parent, col, row + 1) : null;
        }
        if (direction == 4) {
            return col < gridSize.columns - 1 ? this.getComponentAt(parent, col + 1, row) : null;
        }
        return null;
    }
}

