/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.label;

import com.alee.global.StyleConstants;
import com.alee.laf.label.IAbstractLabelPainter;
import com.alee.laf.label.Rotation;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;

public abstract class AbstractLabelPainter<E extends JLabel, U extends BasicLabelUI, D extends IDecoration<E, D>>
extends AbstractDecorationPainter<E, U, D>
implements IAbstractLabelPainter<E, U> {
    protected boolean drawShade;
    protected Color shadeColor;
    protected int shadeSize;
    protected Rotation rotation;
    protected Rectangle paintIconR = new Rectangle();
    protected Rectangle paintTextR = new Rectangle();
    protected Rectangle paintViewR = new Rectangle();

    protected Rotation getActualRotation() {
        return this.rotation != null ? (this.ltr ? this.rotation : this.rotation.rightToLeft()) : Rotation.none;
    }

    @Override
    protected Boolean isOpaqueUndecorated() {
        return false;
    }

    @Override
    public Insets getCompleteBorder() {
        Insets border = super.getCompleteBorder();
        if (border != null) {
            switch (this.getActualRotation()) {
                case counterClockwise: {
                    return this.i(border.left, border.bottom, border.right, border.top);
                }
                case upsideDown: {
                    return this.i(border.bottom, border.right, border.top, border.left);
                }
                case clockwise: {
                    return this.i(border.right, border.top, border.left, border.bottom);
                }
            }
        }
        return border;
    }

    @Override
    protected void paintContent(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        Icon icon;
        Font oldFont = GraphicsUtils.setupFont((Graphics)g2d, (Font)((Component)c).getFont());
        Paint oldPaint = g2d.getPaint();
        this.paintBackground(g2d, bounds, c, ui);
        String text = ((JLabel)c).getText();
        Icon icon2 = icon = ((Component)c).isEnabled() ? ((JLabel)c).getIcon() : ((JLabel)c).getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        Rotation rotation = this.getActualRotation();
        if (rotation != Rotation.none) {
            double angle = 0.0;
            double rX = 0.0;
            double rY = 0.0;
            switch (rotation) {
                case clockwise: {
                    angle = 1.5707963267948966;
                    rX = bounds.width;
                    rY = bounds.width;
                    break;
                }
                case upsideDown: {
                    angle = Math.PI;
                    rX = bounds.width;
                    rY = bounds.height;
                    break;
                }
                case counterClockwise: {
                    angle = -1.5707963267948966;
                    rX = bounds.height;
                    rY = bounds.height;
                }
            }
            g2d.rotate(angle, rX / 2.0, rY / 2.0);
        }
        FontMetrics fm = ((JComponent)c).getFontMetrics(((Component)c).getFont());
        String clippedText = this.layout(c, fm, ((JComponent)c).getWidth(), ((JComponent)c).getHeight());
        this.paintIcon(g2d, c, icon);
        this.paintText(g2d, c, clippedText, fm);
        g2d.setPaint(oldPaint);
        GraphicsUtils.restoreFont((Graphics)g2d, (Font)oldFont);
    }

    protected void paintBackground(Graphics2D g2d, Rectangle bounds, E label, U ui) {
    }

    protected void paintIcon(Graphics2D g2d, E label, Icon icon) {
        if (icon != null) {
            icon.paintIcon((Component)label, g2d, this.paintIconR.x, this.paintIconR.y);
        }
    }

    protected void paintText(Graphics2D g2d, E label, String text, FontMetrics fm) {
        if (text != null) {
            Map textHints = this.drawShade ? StyleConstants.defaultTextRenderingHints : StyleConstants.textRenderingHints;
            Map oldHints = SwingUtils.setupTextAntialias(g2d, textHints);
            if (this.isHtmlText(label)) {
                this.paintHtmlText(g2d, label);
            } else {
                this.paintPlainText(g2d, label, text, fm);
            }
            SwingUtils.restoreTextAntialias(g2d, oldHints);
        }
    }

    protected boolean isHtmlText(E label) {
        return ((JComponent)label).getClientProperty("html") != null;
    }

    protected void paintHtmlText(Graphics2D g2d, E label) {
        View v = (View)((JComponent)label).getClientProperty("html");
        v.paint(g2d, this.paintTextR);
    }

    protected void paintPlainText(Graphics2D g2d, E label, String text, FontMetrics fm) {
        int textX = this.paintTextR.x;
        int textY = this.paintTextR.y + fm.getAscent();
        if (((Component)label).isEnabled()) {
            this.paintEnabledText(label, g2d, text, textX, textY);
        } else {
            this.paintDisabledText(label, g2d, text, textX, textY);
        }
    }

    protected String layout(E label, FontMetrics fm, int width, int height) {
        Insets insets = ((JComponent)label).getInsets(null);
        Icon icon = ((Component)label).isEnabled() ? ((JLabel)label).getIcon() : ((JLabel)label).getDisabledIcon();
        this.paintViewR.x = insets.left;
        this.paintViewR.y = insets.top;
        if (this.getActualRotation().isVertical()) {
            this.paintViewR.width = height;
            this.paintViewR.height = width;
        } else {
            this.paintViewR.width = width;
            this.paintViewR.height = height;
        }
        this.paintViewR.width -= insets.left + insets.right;
        this.paintViewR.height -= insets.top + insets.bottom;
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        return this.layoutCL(label, fm, ((JLabel)label).getText(), icon, this.paintViewR, this.paintIconR, this.paintTextR);
    }

    protected String layoutCL(E label, FontMetrics fm, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        return SwingUtilities.layoutCompoundLabel(label, fm, text, icon, ((JLabel)label).getVerticalAlignment(), ((JLabel)label).getHorizontalAlignment(), ((JLabel)label).getVerticalTextPosition(), ((JLabel)label).getHorizontalTextPosition(), viewR, iconR, textR, ((JLabel)label).getIconTextGap());
    }

    protected void paintEnabledText(E label, Graphics2D g2d, String text, int textX, int textY) {
        if (this.drawShade) {
            g2d.setPaint(((Component)label).getForeground());
            this.paintShadowText(g2d, text, textX, textY);
        } else {
            int mnemIndex = ((JLabel)label).getDisplayedMnemonicIndex();
            g2d.setPaint(((Component)label).getForeground());
            SwingUtils.drawStringUnderlineCharAt(g2d, text, mnemIndex, textX, textY);
        }
    }

    protected void paintDisabledText(E label, Graphics2D g2d, String text, int textX, int textY) {
        if (((Component)label).isEnabled() && this.drawShade) {
            g2d.setPaint(((Component)label).getBackground().darker());
            this.paintShadowText(g2d, text, textX, textY);
        } else {
            int accChar = ((JLabel)label).getDisplayedMnemonicIndex();
            Color background = ((Component)label).getBackground();
            g2d.setPaint(background.brighter());
            SwingUtils.drawStringUnderlineCharAt(g2d, text, accChar, textX + 1, textY + 1);
            g2d.setPaint(background.darker());
            SwingUtils.drawStringUnderlineCharAt(g2d, text, accChar, textX, textY);
        }
    }

    protected void paintShadowText(Graphics2D g2d, String text, int textX, int textY) {
        g2d.translate(textX, textY);
        GraphicsUtils.paintTextEffect((Graphics2D)g2d, (String)text, (Color)this.shadeColor, (int)this.shadeSize, (double)(-this.shadeSize), (double)(1 - this.shadeSize), (boolean)true);
        g2d.translate(-textX, -textY);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ps = this.getContentSize();
        Insets cb = this.getCompleteBorder();
        if (cb != null) {
            ps.width += cb.left + cb.right;
            ps.height += cb.top + cb.bottom;
        }
        if (this.getActualRotation().isVertical()) {
            ps = this.transposeDimension(ps);
        }
        return ps;
    }

    protected Dimension getContentSize() {
        String text = ((JLabel)this.component).getText();
        Icon icon = ((JLabel)this.component).isEnabled() ? ((JLabel)this.component).getIcon() : ((JLabel)this.component).getDisabledIcon();
        Font font = ((JLabel)this.component).getFont();
        if (icon == null && (text == null || text != null && font == null)) {
            return new Dimension(0, 0);
        }
        if (text == null || icon != null && font == null) {
            return new Dimension(icon.getIconWidth(), icon.getIconHeight());
        }
        FontMetrics fm = ((JLabel)this.component).getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle();
        iconR.height = 0;
        iconR.width = 0;
        iconR.y = 0;
        iconR.x = 0;
        textR.height = 0;
        textR.width = 0;
        textR.y = 0;
        textR.x = 0;
        viewR.x = 0;
        viewR.y = 0;
        viewR.height = Short.MAX_VALUE;
        viewR.width = Short.MAX_VALUE;
        this.layoutCL((JLabel)this.component, fm, text, icon, viewR, iconR, textR);
        int x1 = Math.min(iconR.x, textR.x);
        int x2 = Math.max(iconR.x + iconR.width, textR.x + textR.width);
        int y1 = Math.min(iconR.y, textR.y);
        int y2 = Math.max(iconR.y + iconR.height, textR.y + textR.height);
        return new Dimension(x2 - x1, y2 - y1);
    }

    protected Dimension transposeDimension(Dimension from) {
        return new Dimension(from.height, from.width);
    }
}

