/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.laf.WebLookAndFeel;
import com.alee.laf.menu.IAbstractMenuItemPainter;
import com.alee.laf.menu.MenuCornerSupport;
import com.alee.laf.menu.MenuItemChangeListener;
import com.alee.laf.menu.MenuUtils;
import com.alee.painter.AbstractPainter;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.text.View;

public abstract class AbstractMenuItemPainter<E extends JMenuItem, U extends BasicMenuItemUI>
extends AbstractPainter<E, U>
implements IAbstractMenuItemPainter<E, U>,
MenuCornerSupport {
    protected int acceleratorGap = 15;
    protected int iconAlignment = 0;
    protected Color disabledFg = Color.LIGHT_GRAY;
    protected Color selectedTopBg = new Color(208, 208, 198);
    protected Color selectedBottomBg = new Color(196, 196, 186);
    protected Color acceleratorBg = new Color(255, 255, 255, 200);
    protected Color acceleratorFg = new Color(90, 90, 90);
    protected Color acceleratorDisabledFg = new Color(170, 170, 170);
    protected boolean alignTextToMenuIcons = true;
    protected MenuItemChangeListener buttonModelChangeListener;
    protected Font acceleratorFont = null;

    @Override
    public void install(E c, U ui) {
        super.install(c, ui);
        this.setAcceleratorFont();
        this.buttonModelChangeListener = MenuItemChangeListener.install((JMenuItem)this.component);
    }

    @Override
    public void uninstall(E c, U ui) {
        MenuItemChangeListener.uninstall(this.buttonModelChangeListener, (JMenuItem)this.component);
        this.buttonModelChangeListener = null;
        super.uninstall(c, ui);
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        boolean hasAccelerator;
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        int w = ((JMenuItem)this.component).getWidth();
        int h = ((JMenuItem)this.component).getHeight();
        Insets bi = ((JMenuItem)this.component).getInsets();
        int y = bi.top;
        int ih = h - bi.top - bi.bottom;
        ButtonModel model = ((JMenuItem)this.component).getModel();
        boolean selected = ((JMenuItem)this.component).isEnabled() && (model.isArmed() || model.isSelected());
        this.paintBackground(g2d, selected);
        int iconPlaceholderWidth = MenuUtils.getIconPlaceholderWidth((JMenuItem)this.component, this.alignTextToMenuIcons);
        int gap = iconPlaceholderWidth > 0 ? ((JMenuItem)this.component).getIconTextGap() : 0;
        int x = this.ltr ? bi.left : w - bi.right - iconPlaceholderWidth;
        this.paintIcon(g2d, x, y, iconPlaceholderWidth, ih, selected);
        x += this.ltr ? iconPlaceholderWidth + gap : -gap;
        String text = ((JMenuItem)this.component).getText();
        boolean hasText = text != null && text.length() > 0;
        String accText = MenuUtils.getAcceleratorText((JMenuItem)this.component);
        boolean bl = hasAccelerator = accText != null;
        if (hasText || hasAccelerator) {
            Map hints = SwingUtils.setupTextAntialias(g2d);
            if (hasText) {
                FontMetrics fm = ((JMenuItem)this.component).getFontMetrics(((JMenuItem)this.component).getFont());
                View html = (View)((JMenuItem)this.component).getClientProperty("html");
                int tw = html != null ? (int)html.getPreferredSpan(0) : fm.stringWidth(text);
                this.paintText(g2d, fm, x -= this.ltr ? 0 : tw, y, tw, ih, selected);
            }
            if (hasAccelerator) {
                FontMetrics afm = ((JMenuItem)this.component).getFontMetrics(this.acceleratorFont);
                int aw = afm.stringWidth(accText);
                x = this.ltr ? w - bi.right - aw : bi.left;
                this.paintAcceleratorText(g2d, accText, afm, x, y, aw, ih, selected);
            }
            SwingUtils.restoreTextAntialias(g2d, hints);
        }
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    protected void paintBackground(Graphics2D g2d, boolean selected) {
        if (selected) {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.selectedTopBg, 0.0f, ((JMenuItem)this.component).getHeight(), this.selectedBottomBg));
            g2d.fillRect(0, 0, ((JMenuItem)this.component).getWidth(), ((JMenuItem)this.component).getHeight());
        }
    }

    protected void paintIcon(Graphics2D g2d, int x, int y, int w, int h, boolean selected) {
        Icon icon;
        boolean enabled = ((JMenuItem)this.component).isEnabled();
        Icon icon2 = ((JMenuItem)this.component).isSelected() && ((JMenuItem)this.component).getSelectedIcon() != null ? (enabled ? ((JMenuItem)this.component).getSelectedIcon() : ((JMenuItem)this.component).getDisabledSelectedIcon()) : (icon = enabled ? ((JMenuItem)this.component).getIcon() : ((JMenuItem)this.component).getDisabledIcon());
        if (icon != null) {
            boolean center;
            boolean left = this.ltr ? this.iconAlignment == 2 || this.iconAlignment == 10 : this.iconAlignment == 4 || this.iconAlignment == 11;
            boolean bl = center = this.iconAlignment == 0;
            int iconX = left ? x : (center ? x + w / 2 - icon.getIconWidth() / 2 : x + w - icon.getIconWidth());
            icon.paintIcon(this.component, g2d, iconX, y + h / 2 - icon.getIconHeight() / 2);
        }
    }

    protected void paintText(Graphics2D g2d, FontMetrics fm, int x, int y, int w, int h, boolean selected) {
        g2d.setPaint(((JMenuItem)this.component).isEnabled() ? ((JMenuItem)this.component).getForeground() : this.disabledFg);
        Font oldFont = GraphicsUtils.setupFont((Graphics)g2d, (Font)((JMenuItem)this.component).getFont());
        View html = (View)((JMenuItem)this.component).getClientProperty("html");
        if (html != null) {
            html.paint(g2d, new Rectangle(x, y, w, h));
        } else {
            int mnemonic = WebLookAndFeel.isMnemonicHidden() ? -1 : ((JMenuItem)this.component).getDisplayedMnemonicIndex();
            SwingUtils.drawStringUnderlineCharAt(g2d, ((JMenuItem)this.component).getText(), mnemonic, x, y + h / 2 + LafUtils.getTextCenterShiftY(fm));
        }
        GraphicsUtils.restoreFont((Graphics)g2d, (Font)oldFont);
    }

    protected void paintAcceleratorText(Graphics2D g2d, String accText, FontMetrics fm, int x, int y, int w, int h, boolean selected) {
        if (selected && this.acceleratorBg != null) {
            int th = fm.getHeight();
            g2d.setPaint(this.acceleratorBg);
            g2d.fillRoundRect(x - 3, y + h / 2 - th / 2, w + 6, th, 4, 4);
        }
        Font oldFont = GraphicsUtils.setupFont((Graphics)g2d, (Font)this.acceleratorFont);
        g2d.setPaint(((JMenuItem)this.component).isEnabled() ? this.acceleratorFg : this.acceleratorDisabledFg);
        g2d.drawString(accText, x, y + h / 2 + LafUtils.getTextCenterShiftY(fm));
        GraphicsUtils.restoreFont((Graphics)g2d, (Font)oldFont);
    }

    protected void setAcceleratorFont() {
        this.acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        if (this.acceleratorFont == null) {
            this.acceleratorFont = UIManager.getFont("MenuItem.font");
        }
    }

    @Override
    public Rectangle getSelectedBounds() {
        return SwingUtils.getRelativeBounds(this.component, ((JMenuItem)this.component).getParent());
    }

    @Override
    public void fillCorner(Graphics2D g2d, Rectangle clip, Shape corner, int cornerSide) {
    }

    @Override
    public Dimension getPreferredSize() {
        int textHeight;
        int textWidth;
        Insets bi = ((JMenuItem)this.component).getInsets();
        FontMetrics fm = ((JMenuItem)this.component).getFontMetrics(((JMenuItem)this.component).getFont());
        FontMetrics afm = ((JMenuItem)this.component).getFontMetrics(this.acceleratorFont);
        int iconPlaceholderWidth = MenuUtils.getIconPlaceholderWidth((JMenuItem)this.component, this.alignTextToMenuIcons);
        View html = (View)((JMenuItem)this.component).getClientProperty("html");
        if (html != null) {
            textWidth = (int)html.getPreferredSpan(0);
            textHeight = (int)html.getPreferredSpan(1);
        } else {
            String text = ((JMenuItem)this.component).getText();
            textWidth = text != null && text.length() > 0 ? fm.stringWidth(text) : 0;
            textHeight = fm.getHeight();
        }
        int gap = textWidth > 0 && iconPlaceholderWidth > 0 ? ((JMenuItem)this.component).getIconTextGap() : 0;
        String accelerationText = MenuUtils.getAcceleratorText((JMenuItem)this.component);
        int accWidth = accelerationText != null ? this.acceleratorGap + afm.stringWidth(accelerationText) : 0;
        int iconHeight = ((JMenuItem)this.component).getIcon() != null ? ((JMenuItem)this.component).getIcon().getIconHeight() : 0;
        int contentHeight = MathUtils.max((int[])new int[]{iconHeight, textHeight, afm.getHeight()});
        return new Dimension(bi.left + iconPlaceholderWidth + gap + textWidth + accWidth + bi.right, bi.top + contentHeight + bi.bottom);
    }
}

