/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.progressbar;

import com.alee.laf.progressbar.AdaptiveProgressBarPainter;
import com.alee.laf.progressbar.IProgressBarPainter;
import com.alee.laf.progressbar.ProgressBarPainter;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.swing.DataRunnable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class WebProgressBarUI
extends BasicProgressBarUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    @DefaultPainter(value=ProgressBarPainter.class)
    protected IProgressBarPainter painter;
    protected Insets margin = null;
    protected Insets padding = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebProgressBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.progressBar = (JProgressBar)c;
        StyleManager.installSkin(this.progressBar);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.progressBar);
        this.progressBar = null;
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.progressBar);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.progressBar, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.progressBar, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.progressBar, new DataRunnable<IProgressBarPainter>(){

            public void run(IProgressBarPainter newPainter) {
                WebProgressBarUI.this.painter = newPainter;
            }
        }, this.painter, painter, IProgressBarPainter.class, AdaptiveProgressBarPainter.class);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, this.painter);
    }
}

