/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.radiobutton;

import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.AbstractContent;
import com.alee.utils.GraphicsUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import javax.swing.JRadioButton;

@XStreamAlias(value="RadioIcon")
public class RadioIcon<E extends JRadioButton, D extends IDecoration<E, D>, I extends RadioIcon<E, D, I>>
extends AbstractContent<E, D, I> {
    @XStreamAsAttribute
    protected Color leftColor;
    @XStreamAsAttribute
    protected Color rightColor;

    public String getId() {
        return "selected";
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, D d) {
        int x = bounds.x + 2;
        int y = bounds.y + 2;
        int w = bounds.width - 4;
        int h = bounds.height - 4;
        Ellipse2D.Double shape = new Ellipse2D.Double(x, y, w, h);
        GradientPaint paint = new GradientPaint(x, 0.0f, this.leftColor, x + w, 0.0f, this.rightColor);
        Paint op = GraphicsUtils.setupPaint((Graphics2D)g2d, (Paint)paint);
        g2d.fill(shape);
        GraphicsUtils.restorePaint((Graphics2D)g2d, (Paint)op);
    }

    public I merge(I icon) {
        if (((RadioIcon)icon).leftColor != null) {
            this.leftColor = ((RadioIcon)icon).leftColor;
        }
        if (((RadioIcon)icon).rightColor != null) {
            this.rightColor = ((RadioIcon)icon).rightColor;
        }
        return (I)this;
    }
}

