/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.rootpane;

import com.alee.laf.rootpane.IRootPanePainter;
import com.alee.laf.rootpane.WebRootPaneUI;
import com.alee.painter.decoration.AbstractContainerPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import java.util.List;
import javax.swing.JRootPane;

public class RootPanePainter<E extends JRootPane, U extends WebRootPaneUI, D extends IDecoration<E, D>>
extends AbstractContainerPainter<E, U, D>
implements IRootPanePainter<E, U> {
    protected WindowFocusListener windowFocusListener;
    protected WindowStateListener windowStateListener;
    protected boolean maximized = false;

    @Override
    public void install(E c, U ui) {
        super.install(c, ui);
        Window window = SwingUtils.getWindowAncestor(c);
        if (window != null) {
            if (this.isDecorated()) {
                this.enableWindowDecoration(c, window);
            } else {
                this.disableWindowDecoration(c, window);
            }
            if (window instanceof Frame) {
                this.windowStateListener = new WindowStateListener(){

                    @Override
                    public void windowStateChanged(WindowEvent e) {
                        if (RootPanePainter.this.isDecorated()) {
                            RootPanePainter.this.updateDecorationState();
                        }
                    }
                };
                window.addWindowStateListener(this.windowStateListener);
            }
        }
    }

    @Override
    public void uninstall(E c, U ui) {
        Window window = SwingUtils.getWindowAncestor(c);
        if (window != null) {
            if (this.isDecorated()) {
                this.disableWindowDecoration(c, window);
            }
            if (this.windowStateListener != null) {
                window.removeWindowStateListener(this.windowStateListener);
                this.windowStateListener = null;
            }
        }
        super.uninstall(c, ui);
    }

    @Override
    protected void installFocusListener() {
        Window window = SwingUtils.getWindowAncestor((Component)this.component);
        if (window != null && this.usesState("focused")) {
            this.windowFocusListener = new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    RootPanePainter.this.focused = true;
                    if (RootPanePainter.this.isDecorated()) {
                        RootPanePainter.this.updateDecorationState();
                    }
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    RootPanePainter.this.focused = false;
                    if (RootPanePainter.this.isDecorated()) {
                        RootPanePainter.this.updateDecorationState();
                    }
                }
            };
            window.addWindowFocusListener(this.windowFocusListener);
        }
    }

    @Override
    protected void uninstallFocusListener() {
        Window window = SwingUtils.getWindowAncestor((Component)this.component);
        if (window != null && this.windowFocusListener != null) {
            window.removeWindowFocusListener(this.windowFocusListener);
            this.windowFocusListener = null;
        }
    }

    @Override
    protected List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        if (((WebRootPaneUI)this.ui).isIconified()) {
            states.add("iconified");
        }
        if (((WebRootPaneUI)this.ui).isMaximized()) {
            states.add("maximized");
        }
        if (SwingUtils.isFullScreen((Component)this.component)) {
            states.add("fullscreen");
        }
        return states;
    }

    protected void enableWindowDecoration(E c, Window window) {
        if (!window.isDisplayable()) {
            if (window instanceof Frame) {
                ((Frame)window).setUndecorated(true);
                ((JRootPane)c).setWindowDecorationStyle(1);
            } else if (window instanceof Dialog) {
                ((Dialog)window).setUndecorated(true);
                ((JRootPane)c).setWindowDecorationStyle(2);
            }
        }
    }

    protected void disableWindowDecoration(E c, Window window) {
        if (!window.isDisplayable()) {
            if (window instanceof Frame) {
                ((Frame)window).setUndecorated(false);
                ((JRootPane)c).setWindowDecorationStyle(0);
            } else if (window instanceof Dialog) {
                ((Dialog)window).setUndecorated(false);
                ((JRootPane)c).setWindowDecorationStyle(0);
            }
        }
    }

    protected boolean isActive(E c) {
        return SwingUtils.getWindowAncestor(c).isFocused();
    }
}

