/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.scroll;

import com.alee.global.StyleConstants;
import com.alee.laf.scroll.IScrollBarPainter;
import com.alee.laf.scroll.WebScrollBarUI;
import com.alee.painter.AbstractPainter;
import com.alee.utils.ColorUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollBar;

public class ScrollBarPainter<E extends JScrollBar, U extends WebScrollBarUI>
extends AbstractPainter<E, U>
implements IScrollBarPainter<E, U> {
    protected Integer thumbRound;
    protected Insets thumbMargin;
    protected Integer scrollBarWidth;
    protected Color trackBorderColor;
    protected Color trackBackgroundColor;
    protected Color thumbBorderColor;
    protected Color thumbBackgroundColor;
    protected Color thumbDisabledBorderColor;
    protected Color thumbDisabledBackgroundColor;
    protected Color thumbRolloverBorderColor;
    protected Color thumbRolloverBackgroundColor;
    protected Color thumbPressedBorderColor;
    protected Color thumbPressedBackgroundColor;
    protected MouseAdapter mouseAdapter;
    protected boolean animated;
    protected WebTimer rolloverAnimator;
    protected float rolloverState;
    protected boolean rollover;
    protected boolean pressed;
    protected boolean dragged;
    protected Rectangle trackBounds;
    protected Rectangle thumbBounds;
    protected Insets thumbMarginR;
    protected Insets thumbMarginHL;
    protected Insets thumbMarginHR;

    @Override
    public void install(E c, U ui) {
        super.install(c, ui);
        this.animated = true;
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ScrollBarPainter.this.setPressed(true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ScrollBarPainter.this.setPressed(false);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ScrollBarPainter.this.setRollover(ScrollBarPainter.this.thumbBounds.contains(e.getPoint()));
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                ScrollBarPainter.this.setRollover(ScrollBarPainter.this.thumbBounds.contains(e.getPoint()));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ScrollBarPainter.this.setRollover(false);
            }
        };
        ((JScrollBar)this.component).addMouseListener(this.mouseAdapter);
        ((JScrollBar)this.component).addMouseMotionListener(this.mouseAdapter);
    }

    @Override
    public void uninstall(E c, U ui) {
        ((JScrollBar)this.component).removeMouseListener(this.mouseAdapter);
        ((JScrollBar)this.component).removeMouseMotionListener(this.mouseAdapter);
        super.uninstall(c, ui);
    }

    public boolean isRollover() {
        return this.rollover;
    }

    public void setRollover(boolean rollover) {
        if (this.rollover != rollover) {
            this.rollover = rollover;
            if (this.animated) {
                if (rollover) {
                    if (this.rolloverAnimator != null) {
                        this.rolloverAnimator.stop();
                    }
                    this.repaintThumb();
                } else {
                    if (this.rolloverAnimator == null) {
                        this.rolloverAnimator = new WebTimer(StyleConstants.fps36, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (ScrollBarPainter.this.rolloverState > 0.0f) {
                                    ScrollBarPainter.this.rolloverState -= 0.1f;
                                    ScrollBarPainter.this.repaintThumb();
                                } else {
                                    ScrollBarPainter.this.rolloverState = 0.0f;
                                    ScrollBarPainter.this.rolloverAnimator.stop();
                                }
                            }
                        });
                    }
                    this.rolloverState = 1.0f;
                    this.rolloverAnimator.start();
                }
            } else {
                this.rolloverState = rollover ? 1.0f : 0.0f;
                this.repaintThumb();
            }
        }
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPressed(boolean pressed) {
        if (this.pressed != pressed) {
            this.pressed = pressed;
            this.repaintThumb();
        }
    }

    @Override
    public void setDragged(boolean dragged) {
        this.dragged = dragged;
    }

    @Override
    public void setTrackBounds(Rectangle bounds) {
        this.trackBounds = bounds;
    }

    @Override
    public void setThumbBounds(Rectangle bounds) {
        this.thumbBounds = bounds;
    }

    @Override
    public Boolean isOpaque() {
        return ((WebScrollBarUI)this.ui).isPaintTrack();
    }

    @Override
    public Insets getBorders() {
        if (((WebScrollBarUI)this.ui).isPaintTrack()) {
            boolean hor = ((JScrollBar)this.component).getOrientation() == 0;
            return this.i(hor ? 1 : 0, hor ? 0 : 1, 0, 0);
        }
        return super.getBorders();
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E scrollbar, U ui) {
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        this.paintBackground(g2d, scrollbar, bounds);
        this.paintTrack(g2d, scrollbar, this.trackBounds);
        this.paintThumb(g2d, scrollbar, this.thumbBounds);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    protected void paintBackground(Graphics2D g2d, E scrollbar, Rectangle bounds) {
        if (((WebScrollBarUI)this.ui).isPaintTrack()) {
            g2d.setPaint(this.trackBackgroundColor);
            g2d.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            if (((JScrollBar)scrollbar).getOrientation() == 1) {
                int x = this.ltr ? bounds.x : bounds.x + bounds.width - 1;
                g2d.setPaint(this.trackBorderColor);
                g2d.drawLine(x, bounds.y, x, bounds.height - 1);
            } else {
                g2d.setPaint(this.trackBorderColor);
                g2d.drawLine(bounds.x, bounds.y, bounds.x + bounds.width - 1, bounds.y);
            }
        }
    }

    protected void paintTrack(Graphics2D g2d, E scrollbar, Rectangle bounds) {
    }

    protected void paintThumb(Graphics2D g2d, E scrollbar, Rectangle bounds) {
        Insets m = this.getCurrentThumbMargin(scrollbar);
        int w = bounds.width - m.left - m.right;
        int h = bounds.height - m.top - m.bottom;
        int round = MathUtils.min((int[])new int[]{this.thumbRound, w - 1, h - 1});
        g2d.setPaint(this.getCurrentThumbBackgroundColor(scrollbar));
        g2d.fillRoundRect(bounds.x + m.left, bounds.y + m.top, w, h, round, round);
        g2d.setPaint(this.getCurrentThumbBorderColor(scrollbar));
        g2d.drawRoundRect(bounds.x + m.left, bounds.y + m.top, w - 1, h - 1, round, round);
    }

    protected Insets getCurrentThumbMargin(E scrollbar) {
        if (this.thumbMargin != null) {
            boolean ver;
            if (this.thumbMarginR == null) {
                this.updateThumbMargins();
            }
            boolean bl = ver = ((JScrollBar)scrollbar).getOrientation() == 1;
            return ver ? (this.ltr ? this.thumbMargin : this.thumbMarginR) : (this.ltr ? this.thumbMarginHL : this.thumbMarginHR);
        }
        return this.i(0, 0, 0, 0);
    }

    protected void updateThumbMargins() {
        this.thumbMarginR = this.i(this.thumbMargin.top, this.thumbMargin.right, this.thumbMargin.bottom, this.thumbMargin.left);
        this.thumbMarginHL = this.i(this.thumbMargin.left, this.thumbMargin.bottom, this.thumbMargin.right, this.thumbMargin.top);
        this.thumbMarginHR = this.i(this.thumbMargin.right, this.thumbMargin.top, this.thumbMargin.left, this.thumbMargin.bottom);
    }

    protected Color getCurrentThumbBorderColor(E scrollbar) {
        return ((Component)scrollbar).isEnabled() ? (this.pressed || this.dragged ? this.thumbPressedBorderColor : (this.rollover ? this.thumbRolloverBorderColor : ColorUtils.getIntermediateColor((Color)this.thumbBorderColor, (Color)this.thumbRolloverBorderColor, (float)this.rolloverState))) : this.thumbDisabledBorderColor;
    }

    protected Color getCurrentThumbBackgroundColor(E scrollbar) {
        return ((Component)scrollbar).isEnabled() ? (this.pressed || this.dragged ? this.thumbPressedBackgroundColor : (this.rollover ? this.thumbRolloverBackgroundColor : ColorUtils.getIntermediateColor((Color)this.thumbBackgroundColor, (Color)this.thumbRolloverBackgroundColor, (float)this.rolloverState))) : this.thumbDisabledBackgroundColor;
    }

    public void repaintThumb() {
        if (this.thumbBounds != null) {
            this.repaint(this.thumbBounds);
        } else {
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Insets i = ((JScrollBar)this.component).getInsets();
        boolean ver = ((JScrollBar)this.component).getOrientation() == 1;
        return ver ? new Dimension(i.left + this.scrollBarWidth + i.right, i.top + 48 + i.bottom) : new Dimension(i.left + 48 + i.right, i.top + this.scrollBarWidth + i.bottom);
    }
}

