/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.scroll;

import com.alee.laf.scroll.WebScrollBar;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.plaf.UIResource;

public class WebScrollPaneBar
extends WebScrollBar
implements UIResource {
    private final WeakReference<JScrollPane> scrollPane;
    private boolean unitIncrementSet;
    private boolean blockIncrementSet;

    public WebScrollPaneBar(JScrollPane scrollPane, int orientation) {
        super(orientation);
        this.scrollPane = new WeakReference<JScrollPane>(scrollPane);
        this.putClientProperty("JScrollBar.fastWheelScrolling", Boolean.TRUE);
    }

    @Override
    public void setUnitIncrement(int unitIncrement) {
        this.unitIncrementSet = true;
        this.putClientProperty("JScrollBar.fastWheelScrolling", null);
        super.setUnitIncrement(unitIncrement);
    }

    @Override
    public int getUnitIncrement(int direction) {
        JViewport vp = ((JScrollPane)this.scrollPane.get()).getViewport();
        if (!this.unitIncrementSet && vp != null && vp.getView() instanceof Scrollable) {
            Scrollable view = (Scrollable)((Object)vp.getView());
            Rectangle vr = vp.getViewRect();
            return view.getScrollableUnitIncrement(vr, this.getOrientation(), direction);
        }
        return super.getUnitIncrement(direction);
    }

    @Override
    public void setBlockIncrement(int blockIncrement) {
        this.blockIncrementSet = true;
        this.putClientProperty("JScrollBar.fastWheelScrolling", null);
        super.setBlockIncrement(blockIncrement);
    }

    @Override
    public int getBlockIncrement(int direction) {
        JViewport vp = ((JScrollPane)this.scrollPane.get()).getViewport();
        if (this.blockIncrementSet || vp == null) {
            return super.getBlockIncrement(direction);
        }
        if (vp.getView() instanceof Scrollable) {
            Scrollable view = (Scrollable)((Object)vp.getView());
            Rectangle vr = vp.getViewRect();
            return view.getScrollableBlockIncrement(vr, this.getOrientation(), direction);
        }
        if (this.getOrientation() == 1) {
            return vp.getExtentSize().height;
        }
        return vp.getExtentSize().width;
    }
}

