/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.scroll;

import com.alee.laf.scroll.AdaptiveScrollPanePainter;
import com.alee.laf.scroll.IScrollPanePainter;
import com.alee.laf.scroll.ScrollCornerProvider;
import com.alee.laf.scroll.ScrollPanePainter;
import com.alee.laf.scroll.WebScrollPaneCorner;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.LafUtils;
import com.alee.utils.swing.DataRunnable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class WebScrollPaneUI
extends BasicScrollPaneUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    protected Color cornerBackground;
    protected Color cornerLineColor;
    @DefaultPainter(value=ScrollPanePainter.class)
    protected IScrollPanePainter painter;
    protected PropertyChangeListener propertyChangeListener;
    protected Insets margin = null;
    protected Insets padding = null;
    protected Component view = null;
    protected Map<String, JComponent> cornersCache = new HashMap<String, JComponent>(4);

    public Color getCornerBackground() {
        return this.cornerBackground;
    }

    public void setCornerBackground(Color cornerBackground) {
        this.cornerBackground = cornerBackground;
        this.updateCornerColors();
    }

    public Color getCornerLineColor() {
        return this.cornerLineColor;
    }

    public void setCornerLineColor(Color cornerLineColor) {
        this.cornerLineColor = cornerLineColor;
        this.updateCornerColors();
    }

    public static ComponentUI createUI(JComponent c) {
        return new WebScrollPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        JViewport viewport = this.scrollpane.getViewport();
        if (viewport != null) {
            this.view = viewport.getView();
        }
        StyleId.scrollpaneViewport.at(this.scrollpane).set(this.scrollpane.getViewport());
        StyleId.scrollpaneVerticalBar.at(this.scrollpane).set(this.scrollpane.getVerticalScrollBar());
        StyleId.scrollpaneHorizontalBar.at(this.scrollpane).set(this.scrollpane.getHorizontalScrollBar());
        this.updateCorners();
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JScrollBar hsb;
                if (evt.getPropertyName().equals("componentOrientation")) {
                    WebScrollPaneUI.this.updateCorners();
                } else if (evt.getPropertyName().equals("viewport")) {
                    StyleId.scrollpaneViewport.at(WebScrollPaneUI.this.scrollpane).set(WebScrollPaneUI.this.scrollpane.getViewport());
                } else if (evt.getPropertyName().equals("verticalScrollBar")) {
                    JScrollBar vsb = WebScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                    if (vsb != null) {
                        StyleId.scrollpaneVerticalBar.at(WebScrollPaneUI.this.scrollpane).set(vsb);
                    }
                } else if (evt.getPropertyName().equals("horizontalScrollBar") && (hsb = WebScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) != null) {
                    StyleId.scrollpaneHorizontalBar.at(WebScrollPaneUI.this.scrollpane).set(hsb);
                }
            }
        };
        this.scrollpane.addPropertyChangeListener(this.propertyChangeListener);
        StyleManager.installSkin(this.scrollpane);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.scrollpane);
        this.scrollpane.removePropertyChangeListener(this.propertyChangeListener);
        this.removeCorners();
        this.view = null;
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.scrollpane);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.scrollpane, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.scrollpane, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.scrollpane, new DataRunnable<IScrollPanePainter>(){

            public void run(IScrollPanePainter newPainter) {
                WebScrollPaneUI.this.painter = newPainter;
            }
        }, this.painter, painter, IScrollPanePainter.class, AdaptiveScrollPanePainter.class);
    }

    protected void updateCorners() {
        ScrollCornerProvider scp = this.getScrollCornerProvider();
        this.updateCorner("LOWER_LEADING_CORNER", scp);
        this.updateCorner("LOWER_TRAILING_CORNER", scp);
        this.updateCorner("UPPER_TRAILING_CORNER", scp);
    }

    protected void updateCornerColors() {
        this.updateCornerColor("LOWER_LEADING_CORNER");
        this.updateCornerColor("LOWER_TRAILING_CORNER");
        this.updateCornerColor("UPPER_TRAILING_CORNER");
    }

    protected void removeCorners() {
        for (Component component : this.cornersCache.values()) {
            if (component == null) continue;
            this.scrollpane.remove(component);
        }
        this.cornersCache.clear();
    }

    protected ScrollCornerProvider getScrollCornerProvider() {
        ScrollCornerProvider scp = null;
        if (this.view != null) {
            if (this.view instanceof ScrollCornerProvider) {
                scp = (ScrollCornerProvider)((Object)this.view);
            } else {
                Object ui = LafUtils.getUI(this.view);
                if (ui != null && ui instanceof ScrollCornerProvider) {
                    scp = (ScrollCornerProvider)ui;
                }
            }
        }
        return scp;
    }

    protected void updateCorner(String key, ScrollCornerProvider provider) {
        JComponent corner = this.cornersCache.get(key);
        if (corner == null) {
            if (provider != null) {
                corner = provider.getCorner(key);
            }
            if (corner == null) {
                WebScrollPaneCorner wc = new WebScrollPaneCorner(key);
                if (this.cornerBackground != null) {
                    wc.setBackground(this.cornerBackground);
                }
                if (this.cornerLineColor != null) {
                    wc.setBorderColor(this.cornerLineColor);
                }
                corner = wc;
            }
            this.cornersCache.put(key, corner);
        }
        this.scrollpane.setCorner(key, corner);
    }

    protected void updateCornerColor(String key) {
        JComponent corner = this.cornersCache.get(key);
        if (corner != null && corner instanceof WebScrollPaneCorner) {
            WebScrollPaneCorner wc = (WebScrollPaneCorner)corner;
            if (this.cornerBackground != null) {
                wc.setBackground(this.cornerBackground);
            }
            if (this.cornerLineColor != null) {
                wc.setBorderColor(this.cornerLineColor);
            }
        }
    }

    @Override
    protected void syncScrollPaneWithViewport() {
        Component newView;
        super.syncScrollPaneWithViewport();
        JViewport viewport = this.scrollpane.getViewport();
        if (viewport != null && (newView = viewport.getView()) != null && !newView.equals(this.view)) {
            this.view = newView;
            this.updateCorners();
        }
    }

    @Override
    protected void updateViewport(PropertyChangeEvent e) {
        super.updateViewport(e);
        if (e.getOldValue() != e.getNewValue()) {
            this.syncScrollPaneWithViewport();
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return null;
    }
}

