/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.laf.panel.IPanelPainter;
import com.alee.laf.panel.WebPanelUI;
import com.alee.painter.AbstractPainter;
import com.alee.utils.CompareUtils;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class TableCornerPainter<E extends JPanel, U extends WebPanelUI>
extends AbstractPainter<E, U>
implements IPanelPainter<E, U> {
    public static Color topLineColor;
    public static Color bottomLineColor;
    public static Color topBgColor;
    public static Color bottomBgColor;
    public static Color gridColor;

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        int width = ((JPanel)this.component).getWidth();
        int height = ((JPanel)this.component).getHeight();
        g2d.setPaint(topLineColor);
        g2d.drawLine(0, 0, width - 1, 0);
        g2d.setPaint(this.createBackgroundPaint(0, 1, 0, height - 1));
        g2d.fillRect(0, 1, width, height - 1);
        g2d.setPaint(bottomLineColor);
        g2d.drawLine(0, height - 1, width - 1, height - 1);
        if (this.ltr) {
            g2d.setPaint(gridColor);
            g2d.drawLine(0, 2, 0, height - 4);
        } else {
            g2d.setPaint(gridColor);
            g2d.drawLine(width - 1, 2, width - 1, height - 4);
        }
    }

    protected Paint createBackgroundPaint(int x1, int y1, int x2, int y2) {
        if (bottomBgColor == null || CompareUtils.equals((Object)topBgColor, (Object[])new Object[]{bottomBgColor})) {
            return topBgColor;
        }
        return new GradientPaint(x1, y1, topBgColor, x2, y2, bottomBgColor);
    }
}

