/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.laf.text.IAbstractTextEditorPainter;
import com.alee.managers.language.LM;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.EventUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.general.Pair;
import com.alee.utils.swing.DocumentChangeListener;
import com.alee.utils.swing.DocumentEventRunnable;
import com.alee.utils.xml.FontConverter;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import javax.swing.SwingConstants;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public abstract class AbstractTextEditorPainter<E extends JTextComponent, U extends BasicTextUI, D extends IDecoration<E, D>>
extends AbstractDecorationPainter<E, U, D>
implements IAbstractTextEditorPainter<E, U>,
SwingConstants {
    protected int inputPromptHorizontalPosition = 0;
    protected int inputPromptVerticalPosition = 0;
    @XStreamConverter(value=FontConverter.class)
    protected Font inputPromptFont = null;
    protected Color inputPromptForeground = new Color(160, 160, 160);
    protected boolean inputPromptOnlyWhenEditable = true;
    protected boolean hideInputPromptOnFocus = true;
    protected transient Pair<DocumentChangeListener, PropertyChangeListener> documentChangeListeners;

    @Override
    public void install(E c, U ui) {
        super.install(c, ui);
        this.documentChangeListeners = EventUtils.onChange((JTextComponent)this.component, new DocumentEventRunnable(){

            @Override
            public void run(DocumentEvent e) {
                AbstractTextEditorPainter.this.updateDecorationState();
            }
        });
    }

    @Override
    public void uninstall(E c, U ui) {
        ((JTextComponent)this.component).removePropertyChangeListener("document", (PropertyChangeListener)this.documentChangeListeners.getValue());
        ((JTextComponent)this.component).getDocument().removeDocumentListener((DocumentListener)this.documentChangeListeners.getKey());
        super.uninstall(c, ui);
    }

    @Override
    protected List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        if (TextUtils.isEmpty((String)((JTextComponent)this.component).getText())) {
            states.add("empty");
        }
        return states;
    }

    @Override
    protected void paintContent(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        DefaultCaret dropCaret;
        Highlighter highlighter = ((JTextComponent)this.component).getHighlighter();
        if (highlighter != null) {
            highlighter.paint(g2d);
        }
        Map hints = SwingUtils.setupTextAntialias(g2d);
        this.paintInputPrompt(g2d);
        Rectangle alloc = this.getEditorRect();
        if (alloc != null) {
            ((BasicTextUI)ui).getRootView((JTextComponent)this.component).paint(g2d, alloc);
        }
        SwingUtils.restoreTextAntialias(g2d, hints);
        Caret caret = ((JTextComponent)this.component).getCaret();
        if (caret != null) {
            caret.paint(g2d);
        }
        if ((dropCaret = (DefaultCaret)ReflectUtils.getFieldValueSafely(ui, (String)"dropCaret")) != null) {
            dropCaret.paint(g2d);
        }
    }

    protected void paintInputPrompt(Graphics2D g2d) {
        if (this.isInputPromptVisible()) {
            Rectangle b = this.getEditorRect();
            Shape oc = GraphicsUtils.intersectClip((Graphics2D)g2d, (Shape)b);
            g2d.setFont(this.inputPromptFont != null ? this.inputPromptFont : ((JTextComponent)this.component).getFont());
            g2d.setPaint(this.inputPromptForeground != null ? this.inputPromptForeground : ((JTextComponent)this.component).getForeground());
            String text = LM.get((String)this.getInputPrompt());
            FontMetrics fm = g2d.getFontMetrics();
            int x = this.inputPromptHorizontalPosition == 0 ? b.x + b.width / 2 - fm.stringWidth(text) / 2 : (this.ltr && this.inputPromptHorizontalPosition == 10 || !this.ltr && this.inputPromptHorizontalPosition == 11 || this.inputPromptHorizontalPosition == 2 ? b.x : b.x + b.width - fm.stringWidth(text));
            int y = this.inputPromptVerticalPosition == 0 ? b.y + b.height / 2 + LafUtils.getTextCenterShiftY(fm) : ((BasicTextUI)this.ui).getBaseline(this.component, ((JTextComponent)this.component).getWidth(), ((JTextComponent)this.component).getHeight());
            g2d.drawString(text, x, y);
            GraphicsUtils.restoreClip((Graphics2D)g2d, (Shape)oc);
        }
    }

    protected Rectangle getEditorRect() {
        Rectangle alloc = ((JTextComponent)this.component).getBounds();
        if (alloc.width > 0 && alloc.height > 0) {
            Insets insets = ((JTextComponent)this.component).getInsets();
            alloc.x = insets.left;
            alloc.y = insets.top;
            alloc.width -= insets.left + insets.right;
            alloc.height -= insets.top + insets.bottom;
            return alloc;
        }
        return null;
    }

    @Override
    public boolean isInputPromptVisible() {
        String inputPrompt = LM.get((String)this.getInputPrompt());
        return inputPrompt != null && !inputPrompt.isEmpty() && TextUtils.isEmpty((String)((JTextComponent)this.component).getText()) && (!this.inputPromptOnlyWhenEditable || ((JTextComponent)this.component).isEditable() && ((JTextComponent)this.component).isEnabled()) && (!this.hideInputPromptOnFocus || !this.isFocused());
    }
}

