/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.laf.text.AdaptiveTextPanePainter;
import com.alee.laf.text.ITextPanePainter;
import com.alee.laf.text.TextPanePainter;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.CompareUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.swing.DataRunnable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextPaneUI;
import javax.swing.text.JTextComponent;

public class WebTextPaneUI
extends BasicTextPaneUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    @DefaultPainter(value=TextPanePainter.class)
    protected ITextPanePainter painter;
    protected String inputPrompt;
    protected JTextPane textPane = null;
    protected Insets margin = null;
    protected Insets padding = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebTextPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.textPane = (JTextPane)c;
        StyleManager.installSkin(this.textPane);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.textPane);
        this.textPane = null;
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.textPane);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.textPane, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.textPane, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.textPane, new DataRunnable<ITextPanePainter>(){

            public void run(ITextPanePainter newPainter) {
                WebTextPaneUI.this.painter = newPainter;
            }
        }, this.painter, painter, ITextPanePainter.class, AdaptiveTextPanePainter.class);
    }

    public String getInputPrompt() {
        return this.inputPrompt;
    }

    public void setInputPrompt(String text) {
        if (!CompareUtils.equals((Object)text, (Object[])new Object[]{this.inputPrompt})) {
            this.inputPrompt = text;
            this.textPane.repaint();
        }
    }

    @Override
    protected void paintSafely(Graphics g) {
        if (this.painter != null) {
            ReflectUtils.setFieldValueSafely((Object)this, (String)"painted", (Object)true);
            JTextComponent c = this.getComponent();
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c), this.painter);
    }
}

