/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.api.jdk.Predicate;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.tree.TreeEventMethods;
import com.alee.laf.tree.TreeEventUtils;
import com.alee.laf.tree.TreeNodeEventRunnable;
import com.alee.laf.tree.TreeSelectionStyle;
import com.alee.laf.tree.TreeState;
import com.alee.laf.tree.TreeUtils;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTreeModel;
import com.alee.laf.tree.WebTreeUI;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.log.Log;
import com.alee.managers.settings.DefaultValue;
import com.alee.managers.settings.SettingsManager;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.Skin;
import com.alee.managers.style.Skinnable;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.managers.tooltip.ToolTipProvider;
import com.alee.painter.Paintable;
import com.alee.painter.Painter;
import com.alee.utils.EventUtils;
import com.alee.utils.GeometryUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SizeUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.compare.Filter;
import com.alee.utils.swing.AutoExpandSingleChildNodeListener;
import com.alee.utils.swing.EventMethods;
import com.alee.utils.swing.FocusEventRunnable;
import com.alee.utils.swing.FontMethods;
import com.alee.utils.swing.HoverListener;
import com.alee.utils.swing.KeyEventRunnable;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.MouseEventRunnable;
import com.alee.utils.swing.SizeMethods;
import com.alee.utils.swing.StateProvider;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class WebTree<E extends DefaultMutableTreeNode>
extends JTree
implements Styleable,
Skinnable,
Paintable,
ShapeProvider,
MarginSupport,
PaddingSupport,
TreeEventMethods<E>,
EventMethods,
SettingsMethods,
FontMethods<WebTree<E>>,
SizeMethods<WebTree<E>> {
    public static final String TREE_DATA_PROVIDER_PROPERTY = "dataProvider";
    public static final String TREE_FILTER_PROPERTY = "filter";
    public static final String TREE_COMPARATOR_PROPERTY = "comparator";
    public static final int SINGLE_TREE_SELECTION = 1;
    public static final int CONTIGUOUS_TREE_SELECTION = 2;
    public static final int DISCONTIGUOUS_TREE_SELECTION = 4;
    protected TreeSelectionListener scrollToSelectionListener = null;
    protected StateProvider<E> editableStateProvider = null;
    protected ToolTipProvider<? extends WebTree> toolTipProvider = null;

    public WebTree() {
        this(WebTree.getDefaultTreeModel());
    }

    public WebTree(Object[] value) {
        this(WebTree.createTreeModel(value));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRoot();
    }

    public WebTree(Vector<?> value) {
        this(WebTree.createTreeModel(value));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRoot();
    }

    public WebTree(Hashtable<?, ?> value) {
        this(WebTree.createTreeModel(value));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRoot();
    }

    public WebTree(E root) {
        this(new WebTreeModel<E>(root));
    }

    public WebTree(E root, boolean asksAllowsChildren) {
        this(new WebTreeModel<E>(root, asksAllowsChildren));
    }

    public WebTree(TreeModel newModel) {
        super(newModel);
        this.init();
    }

    public WebTree(StyleId id) {
        this(id, WebTree.getDefaultTreeModel());
    }

    public WebTree(StyleId id, Object[] value) {
        this(id, WebTree.createTreeModel(value));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRoot();
    }

    public WebTree(StyleId id, Vector<?> value) {
        this(id, WebTree.createTreeModel(value));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRoot();
    }

    public WebTree(StyleId id, Hashtable<?, ?> value) {
        this(id, WebTree.createTreeModel(value));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRoot();
    }

    public WebTree(StyleId id, E root) {
        this(id, new WebTreeModel<E>(root));
    }

    public WebTree(StyleId id, E root, boolean asksAllowsChildren) {
        this(id, new WebTreeModel<E>(root, asksAllowsChildren));
    }

    public WebTree(StyleId id, TreeModel newModel) {
        super(newModel);
        this.setStyleId(id);
        this.init();
    }

    protected void init() {
    }

    @Override
    public void setCellEditor(TreeCellEditor cellEditor) {
        for (CellEditorListener listener : (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class)) {
            this.cellEditor.removeCellEditorListener(listener);
        }
        super.setCellEditor(cellEditor);
        for (CellEditorListener listener : (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class)) {
            this.cellEditor.addCellEditorListener(listener);
        }
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this.listenerList.add(CellEditorListener.class, listener);
        if (this.cellEditor != null) {
            this.cellEditor.addCellEditorListener(listener);
        }
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this.listenerList.remove(CellEditorListener.class, listener);
        if (this.cellEditor != null) {
            this.cellEditor.removeCellEditorListener(listener);
        }
    }

    public StateProvider<E> getEditableStateProvider() {
        return this.editableStateProvider;
    }

    public void setEditableStateProvider(StateProvider<E> stateProvider) {
        this.editableStateProvider = stateProvider;
    }

    @Override
    public boolean isPathEditable(TreePath path) {
        return super.isPathEditable(path) && this.isNodeEditable((DefaultMutableTreeNode)path.getLastPathComponent());
    }

    public boolean isNodeEditable(E node) {
        return this.editableStateProvider == null || this.editableStateProvider.provide(node);
    }

    public ToolTipProvider<? extends WebTree> getToolTipProvider() {
        return this.toolTipProvider;
    }

    public void setToolTipProvider(ToolTipProvider<? extends WebTree> provider) {
        this.toolTipProvider = provider;
    }

    public void expandRoot() {
        this.expandNode(this.getRootNode());
    }

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public void expandAll(Filter<E> shouldExpand) {
        if (shouldExpand == null) {
            this.expandAll();
        } else {
            E rootNode = this.getRootNode();
            this.expandAll(rootNode, shouldExpand);
        }
    }

    public void expandAll(E node) {
        this.expandAll(node, null);
    }

    public void expandAll(E node, Filter<E> shouldExpand) {
        if (shouldExpand == null || shouldExpand.accept(node)) {
            this.expandNode(node);
            for (int i = 0; i < ((DefaultMutableTreeNode)node).getChildCount(); ++i) {
                this.expandAll((DefaultMutableTreeNode)((DefaultMutableTreeNode)node).getChildAt(i), shouldExpand);
            }
        }
    }

    public void expandAll(int depth) {
        this.expandAllImpl(this.getRootNode(), 0, depth);
    }

    private void expandAllImpl(E node, int currentDepth, int maxDepth) {
        int depth = currentDepth + 1;
        for (int i = 0; i < ((DefaultMutableTreeNode)node).getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)((DefaultMutableTreeNode)node).getChildAt(i);
            this.expandNode(child);
            if (depth >= maxDepth) continue;
            this.expandAllImpl(child, depth, maxDepth);
        }
    }

    public void expandNode(E node) {
        this.expandPath(this.getPathForNode(node));
    }

    public boolean isExpanded(E node) {
        return this.isExpanded((E)this.getPathForNode(node));
    }

    public Rectangle getSelectedNodeBounds() {
        return this.getNodeBounds(this.getSelectedNode());
    }

    public Rectangle getNodeBounds(E node) {
        return this.getPathBounds(this.getPathForNode(node));
    }

    public Rectangle getNodeBounds(List<E> nodes) {
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        Rectangle combined = null;
        for (DefaultMutableTreeNode node : nodes) {
            combined = GeometryUtils.getContainingRect(combined, (Rectangle)this.getNodeBounds(node));
        }
        return combined;
    }

    public Rectangle getFullRowBounds(E node) {
        return this.getFullRowBounds(this.getRowForNode(node));
    }

    public Rectangle getFullRowBounds(int row) {
        return this.getWebUI().getFullRowBounds(row);
    }

    public int getRowForNode(E node) {
        return this.getRowForPath(this.getPathForNode(node));
    }

    public E getNodeForRow(int row) {
        return this.getNodeForPath(this.getPathForRow(row));
    }

    public TreePath getPathForNode(E node) {
        return node != null ? new TreePath(((DefaultMutableTreeNode)node).getPath()) : null;
    }

    public E getNodeForPath(TreePath path) {
        return (E)(path != null ? (DefaultMutableTreeNode)path.getLastPathComponent() : null);
    }

    public E getNodeForLocation(Point location) {
        return this.getNodeForLocation(location.x, location.y);
    }

    public E getNodeForLocation(int x, int y) {
        return this.getNodeForPath(this.getPathForLocation(x, y));
    }

    public TreePath getPathForLocation(Point location) {
        return this.getPathForLocation(location.x, location.y);
    }

    public E getClosestNodeForLocation(Point location) {
        return this.getClosestNodeForLocation(location.x, location.y);
    }

    public E getClosestNodeForLocation(int x, int y) {
        return this.getNodeForPath(this.getClosestPathForLocation(x, y));
    }

    public TreePath getClosestPathForLocation(Point location) {
        return this.getClosestPathForLocation(location.x, location.y);
    }

    public boolean isSelected(E node) {
        return this.isPathSelected(this.getPathForNode(node));
    }

    public E getSelectedNode() {
        return this.getNodeForPath(this.getSelectionPath());
    }

    public List<E> getSelectedNodes() {
        ArrayList<E> selectedNodes = new ArrayList<E>();
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath path : selectionPaths) {
                selectedNodes.add(this.getNodeForPath(path));
            }
        }
        return selectedNodes;
    }

    public List<E> getVisibleSelectedNodes() {
        List<E> selectedNodes = this.getSelectedNodes();
        Rectangle vr = this.getVisibleRect();
        Iterator<E> iterator = selectedNodes.iterator();
        while (iterator.hasNext()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)iterator.next();
            if (vr.intersects(this.getNodeBounds(node))) continue;
            iterator.remove();
        }
        return selectedNodes;
    }

    public void selectNodeUnderPoint(Point point) {
        this.selectNodeUnderPoint(point.x, point.y);
    }

    public void selectNodeUnderPoint(int x, int y) {
        this.setSelectionPath(this.getPathForLocation(x, y));
    }

    public void setSelectedNode(E node) {
        TreePath path = this.getPathForNode(node);
        if (path != null) {
            this.setSelectionPath(path);
        }
    }

    public void setSelectedNodes(List<E> nodes) {
        TreePath[] paths = new TreePath[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            paths[i] = this.getPathForNode((DefaultMutableTreeNode)nodes.get(i));
        }
        this.setSelectionPaths(paths);
    }

    public void setSelectedNodes(E[] nodes) {
        TreePath[] paths = new TreePath[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            paths[i] = this.getPathForNode(nodes[i]);
        }
        this.setSelectionPaths(paths);
    }

    public E getFirstVisibleLeafNode() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            E node = this.getNodeForRow(i);
            if (!this.getModel().isLeaf(node)) continue;
            return node;
        }
        return null;
    }

    public void selectFirstVisibleLeafNode() {
        E node = this.getFirstVisibleLeafNode();
        if (node != null) {
            this.setSelectedNode(node);
        }
    }

    public void selectNextRow() {
        this.selectNextRow(true);
    }

    public void selectNextRow(boolean cycle) {
        int row = this.getLeadSelectionRow();
        if (row != -1) {
            if (row < this.getRowCount() - 1) {
                this.setSelectionRow(row + 1);
            } else if (cycle) {
                this.setSelectionRow(0);
            }
        } else {
            this.setSelectionRow(0);
        }
    }

    public void selectPreviousRow() {
        this.selectPreviousRow(true);
    }

    public void selectPreviousRow(boolean cycle) {
        int row = this.getLeadSelectionRow();
        if (row != -1) {
            if (row > 0) {
                this.setSelectionRow(row - 1);
            } else if (cycle) {
                this.setSelectionRow(this.getRowCount() - 1);
            }
        } else {
            this.setSelectionRow(this.getRowCount() - 1);
        }
    }

    public E getRootNode() {
        return (E)((DefaultMutableTreeNode)this.getModel().getRoot());
    }

    public List<E> getAllNodes() {
        ArrayList nodes = new ArrayList();
        this.getAllNodesImpl(nodes, this.getRootNode());
        return nodes;
    }

    private void getAllNodesImpl(List<E> nodes, E node) {
        nodes.add(node);
        for (int i = 0; i < ((DefaultMutableTreeNode)node).getChildCount(); ++i) {
            this.getAllNodesImpl(nodes, (DefaultMutableTreeNode)((DefaultMutableTreeNode)node).getChildAt(i));
        }
    }

    public void setSelectionMode(int mode) {
        this.getSelectionModel().setSelectionMode(mode);
    }

    public void setMultiplySelectionAllowed(boolean allowed) {
        this.setSelectionMode(allowed ? 4 : 1);
    }

    public boolean isScrollToSelection() {
        return this.scrollToSelectionListener != null;
    }

    public void setScrollToSelection(boolean scroll) {
        if (scroll) {
            if (!this.isScrollToSelection()) {
                this.scrollToSelectionListener = new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent e) {
                        WebTree.this.scrollToSelection();
                    }
                };
                this.addTreeSelectionListener(this.scrollToSelectionListener);
            }
        } else if (this.isScrollToSelection()) {
            this.removeTreeSelectionListener(this.scrollToSelectionListener);
            this.scrollToSelectionListener = null;
        }
    }

    public void scrollToStart() {
        this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
    }

    public void scrollToSelection() {
        Rectangle vr;
        Rectangle bounds = this.getPathBounds(this.getSelectionPath());
        if (bounds != null && !(vr = this.getVisibleRect()).contains(bounds)) {
            bounds.y = bounds.y + bounds.height / 2 - vr.height / 2;
            if (vr.width > bounds.width) {
                bounds.x = bounds.x + bounds.width / 2 - vr.width / 2;
            }
            bounds.width = vr.width;
            bounds.height = vr.height;
            this.scrollRectToVisible(bounds);
        }
    }

    public void scrollToNode(E node) {
        Rectangle bounds = this.getNodeBounds(node);
        if (bounds != null) {
            this.scrollRectToVisible(bounds);
        }
    }

    public void startEditingSelectedNode() {
        this.startEditingNode(this.getSelectedNode());
    }

    public void startEditingNode(E node) {
        TreePath path;
        if (node != null && (path = this.getPathForNode(node)) != null) {
            if (!this.isVisible(path)) {
                this.expandPath(path);
            }
            this.startEditingAtPath(path);
        }
    }

    public void updateAllVisibleNodes() {
        this.revalidate();
        this.repaint();
    }

    public TreeState getTreeState() {
        return TreeUtils.getTreeState(this);
    }

    public TreeState getTreeState(boolean saveSelection) {
        return TreeUtils.getTreeState(this, saveSelection);
    }

    public void setTreeState(TreeState treeState) {
        TreeUtils.setTreeState(this, treeState);
    }

    public void setTreeState(TreeState treeState, boolean restoreSelection) {
        TreeUtils.setTreeState(this, treeState, restoreSelection);
    }

    public boolean isAutoExpandSelectedNode() {
        return this.getWebUI().isExpandSelected();
    }

    public void setAutoExpandSelectedNode(boolean autoExpand) {
        this.getWebUI().setExpandSelected(autoExpand);
    }

    public boolean isAutoExpandSingleChildNode() {
        return AutoExpandSingleChildNodeListener.isInstalled(this);
    }

    public void setAutoExpandSingleChildNode(boolean autoExpand) {
        if (autoExpand) {
            if (!this.isAutoExpandSingleChildNode()) {
                AutoExpandSingleChildNodeListener.install(this);
            }
        } else if (this.isAutoExpandSingleChildNode()) {
            AutoExpandSingleChildNodeListener.uninstall(this);
        }
    }

    public int getHoverRow() {
        return this.getWebUI().getHoverRow();
    }

    public TreeSelectionStyle getSelectionStyle() {
        return this.getWebUI().getSelectionStyle();
    }

    public void setSelectionStyle(TreeSelectionStyle style) {
        this.getWebUI().setSelectionStyle(style);
    }

    public boolean isSelectOnHover() {
        return this.getWebUI().isSelectOnHover();
    }

    public void setSelectOnHover(boolean select) {
        this.getWebUI().setSelectOnHover(select);
    }

    @Override
    public StyleId getStyleId() {
        return this.getWebUI().getStyleId();
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return this.getWebUI().setStyleId(id);
    }

    @Override
    public Skin getSkin() {
        return StyleManager.getSkin(this);
    }

    @Override
    public Skin setSkin(Skin skin) {
        return StyleManager.setSkin(this, skin);
    }

    @Override
    public Skin setSkin(Skin skin, boolean recursively) {
        return StyleManager.setSkin(this, skin, recursively);
    }

    @Override
    public Skin restoreSkin() {
        return StyleManager.restoreSkin(this);
    }

    @Override
    public void addStyleListener(StyleListener listener) {
        StyleManager.addStyleListener(this, listener);
    }

    @Override
    public void removeStyleListener(StyleListener listener) {
        StyleManager.removeStyleListener(this, listener);
    }

    @Override
    public Map<String, Painter> getCustomPainters() {
        return StyleManager.getCustomPainters(this);
    }

    @Override
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this);
    }

    @Override
    public Painter getCustomPainter(String id) {
        return StyleManager.getCustomPainter(this, id);
    }

    @Override
    public Painter setCustomPainter(Painter painter) {
        return StyleManager.setCustomPainter(this, painter);
    }

    @Override
    public Painter setCustomPainter(String id, Painter painter) {
        return StyleManager.setCustomPainter(this, id, painter);
    }

    @Override
    public boolean restoreDefaultPainters() {
        return StyleManager.restoreDefaultPainters(this);
    }

    @Override
    public Shape provideShape() {
        return this.getWebUI().provideShape();
    }

    @Override
    public Insets getMargin() {
        return this.getWebUI().getMargin();
    }

    public void setMargin(int margin) {
        this.setMargin(margin, margin, margin, margin);
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
    }

    @Override
    public void setMargin(Insets margin) {
        this.getWebUI().setMargin(margin);
    }

    @Override
    public Insets getPadding() {
        return this.getWebUI().getPadding();
    }

    public void setPadding(int padding) {
        this.setPadding(padding, padding, padding, padding);
    }

    public void setPadding(int top, int left, int bottom, int right) {
        this.setPadding(new Insets(top, left, bottom, right));
    }

    @Override
    public void setPadding(Insets padding) {
        this.getWebUI().setPadding(padding);
    }

    public void addHoverListener(HoverListener<E> listener) {
        this.listenerList.add(HoverListener.class, listener);
    }

    public void removeHoverListener(HoverListener<E> listener) {
        this.listenerList.remove(HoverListener.class, listener);
    }

    public void fireHoverChanged(E previous, E current) {
        for (HoverListener listener : (HoverListener[])this.listenerList.getListeners(HoverListener.class)) {
            listener.hoverChanged(previous, current);
        }
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int increment = super.getScrollableUnitIncrement(visibleRect, orientation, direction);
        if (orientation == 1 && direction < 0) {
            Insets i = this.getInsets();
            if (visibleRect.y - increment == i.top) {
                increment += i.top;
            }
        }
        return increment;
    }

    public WebTreeUI getWebUI() {
        return (WebTreeUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebTreeUI)) {
            try {
                this.setUI((WebTreeUI)ReflectUtils.createInstance((String)WebLookAndFeel.treeUI, (Object[])new Object[0]));
            }
            catch (Throwable e) {
                Log.error((Object)this, (Throwable)e);
                this.setUI(new WebTreeUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    public void repaint(int row) {
        this.repaint((E)this.getWebUI().getRowBounds(row));
    }

    public void repaint(int from, int to) {
        Rectangle toBounds;
        WebTreeUI webUI = this.getWebUI();
        Rectangle fromBounds = webUI.getRowBounds(from);
        Rectangle rect = GeometryUtils.getContainingRect((Rectangle)fromBounds, (Rectangle)(toBounds = webUI.getRowBounds(to)));
        if (rect != null) {
            this.repaint((E)rect);
        }
    }

    public void repaint(E node) {
        Rectangle bounds;
        if (node != null && (bounds = this.getNodeBounds(node)) != null) {
            this.repaint((E)bounds);
        }
    }

    public void repaint(List<E> nodes) {
        if (nodes != null && nodes.size() > 0) {
            Rectangle summ = null;
            for (DefaultMutableTreeNode node : nodes) {
                summ = GeometryUtils.getContainingRect(summ, (Rectangle)this.getNodeBounds(node));
            }
            if (summ != null) {
                this.repaint((E)summ);
            }
        }
    }

    public CellRendererPane getCellRendererPane() {
        return this.getWebUI().getCellRendererPane();
    }

    @Override
    public MouseAdapter onNodeDoubleClick(TreeNodeEventRunnable<E> runnable) {
        return TreeEventUtils.onNodeDoubleClick(this, runnable);
    }

    @Override
    public MouseAdapter onNodeDoubleClick(Predicate<E> condition, TreeNodeEventRunnable<E> runnable) {
        return TreeEventUtils.onNodeDoubleClick(this, condition, runnable);
    }

    @Override
    public MouseAdapter onMousePress(MouseEventRunnable runnable) {
        return EventUtils.onMousePress(this, runnable);
    }

    @Override
    public MouseAdapter onMousePress(MouseButton mouseButton, MouseEventRunnable runnable) {
        return EventUtils.onMousePress(this, mouseButton, runnable);
    }

    @Override
    public MouseAdapter onMouseEnter(MouseEventRunnable runnable) {
        return EventUtils.onMouseEnter(this, runnable);
    }

    @Override
    public MouseAdapter onMouseExit(MouseEventRunnable runnable) {
        return EventUtils.onMouseExit(this, runnable);
    }

    @Override
    public MouseAdapter onMouseDrag(MouseEventRunnable runnable) {
        return EventUtils.onMouseDrag(this, runnable);
    }

    @Override
    public MouseAdapter onMouseDrag(MouseButton mouseButton, MouseEventRunnable runnable) {
        return EventUtils.onMouseDrag(this, mouseButton, runnable);
    }

    @Override
    public MouseAdapter onMouseClick(MouseEventRunnable runnable) {
        return EventUtils.onMouseClick(this, runnable);
    }

    @Override
    public MouseAdapter onMouseClick(MouseButton mouseButton, MouseEventRunnable runnable) {
        return EventUtils.onMouseClick(this, mouseButton, runnable);
    }

    @Override
    public MouseAdapter onDoubleClick(MouseEventRunnable runnable) {
        return EventUtils.onDoubleClick(this, runnable);
    }

    @Override
    public MouseAdapter onMenuTrigger(MouseEventRunnable runnable) {
        return EventUtils.onMenuTrigger(this, runnable);
    }

    @Override
    public KeyAdapter onKeyType(KeyEventRunnable runnable) {
        return EventUtils.onKeyType(this, runnable);
    }

    @Override
    public KeyAdapter onKeyType(HotkeyData hotkey, KeyEventRunnable runnable) {
        return EventUtils.onKeyType(this, hotkey, runnable);
    }

    @Override
    public KeyAdapter onKeyPress(KeyEventRunnable runnable) {
        return EventUtils.onKeyPress(this, runnable);
    }

    @Override
    public KeyAdapter onKeyPress(HotkeyData hotkey, KeyEventRunnable runnable) {
        return EventUtils.onKeyPress(this, hotkey, runnable);
    }

    @Override
    public KeyAdapter onKeyRelease(KeyEventRunnable runnable) {
        return EventUtils.onKeyRelease(this, runnable);
    }

    @Override
    public KeyAdapter onKeyRelease(HotkeyData hotkey, KeyEventRunnable runnable) {
        return EventUtils.onKeyRelease(this, hotkey, runnable);
    }

    @Override
    public FocusAdapter onFocusGain(FocusEventRunnable runnable) {
        return EventUtils.onFocusGain(this, runnable);
    }

    @Override
    public FocusAdapter onFocusLoss(FocusEventRunnable runnable) {
        return EventUtils.onFocusLoss(this, runnable);
    }

    public void registerSettings(String key) {
        SettingsManager.registerComponent((JComponent)this, (String)key);
    }

    public <V extends DefaultValue> void registerSettings(String key, Class<V> defaultValueClass) {
        SettingsManager.registerComponent((JComponent)this, (String)key, defaultValueClass);
    }

    public void registerSettings(String key, Object defaultValue) {
        SettingsManager.registerComponent((JComponent)this, (String)key, (Object)defaultValue);
    }

    public void registerSettings(String group, String key) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key);
    }

    public <V extends DefaultValue> void registerSettings(String group, String key, Class<V> defaultValueClass) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key, defaultValueClass);
    }

    public void registerSettings(String group, String key, Object defaultValue) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key, (Object)defaultValue);
    }

    public void registerSettings(String key, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)key, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public <V extends DefaultValue> void registerSettings(String key, Class<V> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)key, defaultValueClass, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)key, (Object)defaultValue, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public <V extends DefaultValue> void registerSettings(String group, String key, Class<V> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key, defaultValueClass, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(String group, String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key, (Object)defaultValue, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(SettingsProcessor settingsProcessor) {
        SettingsManager.registerComponent((JComponent)this, (SettingsProcessor)settingsProcessor);
    }

    public void unregisterSettings() {
        SettingsManager.unregisterComponent((JComponent)this);
    }

    public void loadSettings() {
        SettingsManager.loadComponentSettings((JComponent)this);
    }

    public void saveSettings() {
        SettingsManager.saveComponentSettings((JComponent)this);
    }

    @Override
    public WebTree<E> setPlainFont() {
        return SwingUtils.setPlainFont(this);
    }

    @Override
    public WebTree<E> setPlainFont(boolean apply) {
        return SwingUtils.setPlainFont(this, apply);
    }

    @Override
    public boolean isPlainFont() {
        return SwingUtils.isPlainFont(this);
    }

    @Override
    public WebTree<E> setBoldFont() {
        return SwingUtils.setBoldFont(this);
    }

    @Override
    public WebTree<E> setBoldFont(boolean apply) {
        return SwingUtils.setBoldFont(this, apply);
    }

    @Override
    public boolean isBoldFont() {
        return SwingUtils.isBoldFont(this);
    }

    @Override
    public WebTree<E> setItalicFont() {
        return SwingUtils.setItalicFont(this);
    }

    @Override
    public WebTree<E> setItalicFont(boolean apply) {
        return SwingUtils.setItalicFont(this, apply);
    }

    @Override
    public boolean isItalicFont() {
        return SwingUtils.isItalicFont(this);
    }

    @Override
    public WebTree<E> setFontStyle(boolean bold, boolean italic) {
        return SwingUtils.setFontStyle(this, bold, italic);
    }

    @Override
    public WebTree<E> setFontStyle(int style) {
        return SwingUtils.setFontStyle(this, style);
    }

    @Override
    public WebTree<E> setFontSize(int fontSize) {
        return SwingUtils.setFontSize(this, fontSize);
    }

    @Override
    public WebTree<E> changeFontSize(int change) {
        return SwingUtils.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return SwingUtils.getFontSize(this);
    }

    @Override
    public WebTree<E> setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebTree<E> setFontSizeAndStyle(int fontSize, int style) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebTree<E> setFontName(String fontName) {
        return SwingUtils.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return SwingUtils.getFontName(this);
    }

    @Override
    public int getPreferredWidth() {
        return SizeUtils.getPreferredWidth(this);
    }

    @Override
    public WebTree<E> setPreferredWidth(int preferredWidth) {
        return SizeUtils.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeUtils.getPreferredHeight(this);
    }

    @Override
    public WebTree<E> setPreferredHeight(int preferredHeight) {
        return SizeUtils.setPreferredHeight(this, preferredHeight);
    }

    @Override
    public int getMinimumWidth() {
        return SizeUtils.getMinimumWidth(this);
    }

    @Override
    public WebTree<E> setMinimumWidth(int minimumWidth) {
        return SizeUtils.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeUtils.getMinimumHeight(this);
    }

    @Override
    public WebTree<E> setMinimumHeight(int minimumHeight) {
        return SizeUtils.setMinimumHeight(this, minimumHeight);
    }

    @Override
    public int getMaximumWidth() {
        return SizeUtils.getMaximumWidth(this);
    }

    @Override
    public WebTree<E> setMaximumWidth(int maximumWidth) {
        return SizeUtils.setMaximumWidth(this, maximumWidth);
    }

    @Override
    public int getMaximumHeight() {
        return SizeUtils.getMaximumHeight(this);
    }

    @Override
    public WebTree<E> setMaximumHeight(int maximumHeight) {
        return SizeUtils.setMaximumHeight(this, maximumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return SizeUtils.getPreferredSize(this, super.getPreferredSize());
    }

    @Override
    public WebTree<E> setPreferredSize(int width, int height) {
        return SizeUtils.setPreferredSize(this, width, height);
    }

    protected static TreeModel createTreeModel(Object value) {
        DefaultMutableTreeNode root;
        if (value instanceof Object[] || value instanceof Hashtable || value instanceof Vector) {
            root = new DefaultMutableTreeNode("root");
            JTree.DynamicUtilTreeNode.createChildren(root, value);
        } else {
            root = new JTree.DynamicUtilTreeNode((Object)"root", value);
        }
        return new WebTreeModel<DefaultMutableTreeNode>(root, false);
    }

    public static TreeModel getDefaultTreeModel() {
        UniqueNode root = new UniqueNode("JTree");
        UniqueNode parent = new UniqueNode("colors");
        parent.add(new UniqueNode("blue"));
        parent.add(new UniqueNode("violet"));
        parent.add(new UniqueNode("red"));
        parent.add(new UniqueNode("yellow"));
        root.add(parent);
        parent = new UniqueNode("sports");
        parent.add(new UniqueNode("basketball"));
        parent.add(new UniqueNode("soccer"));
        parent.add(new UniqueNode("football"));
        parent.add(new UniqueNode("hockey"));
        root.add(parent);
        parent = new UniqueNode("food");
        parent.add(new UniqueNode("hot dogs"));
        parent.add(new UniqueNode("pizza"));
        parent.add(new UniqueNode("ravioli"));
        parent.add(new UniqueNode("bananas"));
        root.add(parent);
        return new WebTreeModel<UniqueNode>(root);
    }
}

