/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language;

import com.alee.managers.language.LanguageAdapter;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.TooltipLanguageSupport;
import com.alee.managers.language.WeblafTooltipLanguageSupport;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.managers.language.updaters.WebAbstractButtonLU;
import com.alee.managers.language.updaters.WebCollapsiblePaneLU;
import com.alee.managers.language.updaters.WebDockableFrameLU;
import com.alee.managers.language.updaters.WebFileDropLU;
import com.alee.managers.language.updaters.WebFormattedTextFieldLU;
import com.alee.managers.language.updaters.WebPasswordFieldLU;
import com.alee.managers.language.updaters.WebRootPaneLU;
import com.alee.managers.language.updaters.WebTextFieldLU;
import com.alee.utils.SwingUtils;
import java.awt.ComponentOrientation;

public class WebLanguageManager {
    protected static boolean initialized = false;

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            LanguageManager.initialize();
            LanguageManager.registerLanguageUpdater((LanguageUpdater)new WebAbstractButtonLU());
            LanguageManager.registerLanguageUpdater((LanguageUpdater)new WebTextFieldLU());
            LanguageManager.registerLanguageUpdater((LanguageUpdater)new WebFormattedTextFieldLU());
            LanguageManager.registerLanguageUpdater((LanguageUpdater)new WebPasswordFieldLU());
            LanguageManager.registerLanguageUpdater((LanguageUpdater)new WebFileDropLU());
            LanguageManager.registerLanguageUpdater((LanguageUpdater)new WebCollapsiblePaneLU());
            LanguageManager.registerLanguageUpdater((LanguageUpdater)new WebDockableFrameLU());
            LanguageManager.registerLanguageUpdater((LanguageUpdater)new WebRootPaneLU());
            LanguageManager.setTooltipLanguageSupport((TooltipLanguageSupport)new WeblafTooltipLanguageSupport());
            LanguageManager.addLanguageListener((LanguageListener)new LanguageAdapter(){

                public void languageChanged(String oldLang, String newLang) {
                    ComponentOrientation oo = ComponentOrientation.getOrientation(LanguageManager.getLocale((String)oldLang));
                    ComponentOrientation no = ComponentOrientation.getOrientation(LanguageManager.getLocale((String)newLang));
                    if (oo.isLeftToRight() != no.isLeftToRight()) {
                        SwingUtils.updateGlobalOrientations();
                    }
                }
            });
        }
    }
}

