/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language;

import com.alee.managers.language.TooltipLanguageSupport;
import com.alee.managers.language.data.Tooltip;
import com.alee.managers.language.data.TooltipType;
import com.alee.managers.language.data.Value;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.WebCustomTooltip;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;

public class WeblafTooltipLanguageSupport
implements TooltipLanguageSupport {
    protected final Map<Component, List<WebCustomTooltip>> tooltipsCache = new WeakHashMap<Component, List<WebCustomTooltip>>();

    public void setupTooltip(Component component, Value value) {
        boolean swingComponent = component instanceof JComponent;
        if (this.tooltipsCache.containsKey(component)) {
            if (swingComponent) {
                ((JComponent)component).setToolTipText(null);
            }
            TooltipManager.removeTooltips(component, this.tooltipsCache.get(component));
            this.tooltipsCache.get(component).clear();
        }
        if (value != null && value.getTooltips() != null && value.getTooltips().size() > 0) {
            for (Tooltip tooltip : value.getTooltips()) {
                if (tooltip.getType().equals((Object)TooltipType.swing)) {
                    if (!swingComponent) continue;
                    ((JComponent)component).setToolTipText(tooltip.getText());
                    continue;
                }
                if (tooltip.getDelay() != null) {
                    this.cacheTip(TooltipManager.setTooltip(component, tooltip.getText(), tooltip.getWay(), (int)tooltip.getDelay()));
                    continue;
                }
                this.cacheTip(TooltipManager.setTooltip(component, tooltip.getText()));
            }
        }
    }

    protected void cacheTip(WebCustomTooltip tooltip) {
        Component component = tooltip.getComponent();
        if (!this.tooltipsCache.containsKey(component)) {
            this.tooltipsCache.put(component, new ArrayList());
        }
        this.tooltipsCache.get(component).add(tooltip);
    }
}

