/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style;

import com.alee.painter.decoration.IDecoration;
import com.alee.utils.LafUtils;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;

public enum Bounds {
    component,
    margin,
    border,
    padding;


    public Rectangle of(Component c) {
        return this.of(c, new Rectangle(0, 0, c.getWidth(), c.getHeight()));
    }

    public Rectangle of(Component c, Rectangle b) {
        switch (this) {
            case padding: {
                Insets i = LafUtils.getInsets(c);
                if (i != null) {
                    return new Rectangle(b.x + i.left, b.y + i.top, b.width - i.left - i.right, b.height - i.top - i.bottom);
                }
                return component.of(c, b);
            }
            case border: {
                Insets i = LafUtils.getInsets(c);
                if (i != null) {
                    Insets p = LafUtils.getPadding(c);
                    if (p != null) {
                        return new Rectangle(b.x + i.left - p.left, b.y + i.top - p.top, b.width - i.left - i.right + p.left + p.right, b.height - i.top - i.bottom + p.top + p.bottom);
                    }
                    return padding.of(c, b);
                }
                return component.of(c, b);
            }
            case margin: {
                Insets m = LafUtils.getMargin(c);
                if (m != null) {
                    return new Rectangle(b.x + m.left, b.y + m.top, b.width - m.left - m.right, b.height - m.top - m.bottom);
                }
                return component.of(c, b);
            }
        }
        return b;
    }

    public Rectangle of(JComponent c, IDecoration d, Rectangle b) {
        switch (this) {
            case padding: 
            case border: {
                Insets i = d.getBorderInsets(c);
                return new Rectangle(b.x + i.left, b.y + i.top, b.width - i.left - i.right, b.height - i.top - i.bottom);
            }
        }
        return b;
    }
}

