/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.data;

import com.alee.managers.style.StyleException;
import com.alee.managers.style.data.IgnoredValue;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.utils.ReflectUtils;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;

public final class StyleConverterUtils {
    public static final String IGNORED_ATTRIBUTE = "ignored";

    public static void readProperties(HierarchicalStreamReader reader, UnmarshallingContext context, Map<String, Object> properties, Class clazz, String styleId) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            StyleConverterUtils.readProperty(reader, context, styleId, properties, clazz, reader.getNodeName());
            reader.moveUp();
        }
    }

    public static void readProperty(HierarchicalStreamReader reader, UnmarshallingContext context, String styleId, Map<String, Object> properties, Class propertyClass, String propertyName) {
        String ignored = reader.getAttribute(IGNORED_ATTRIBUTE);
        if (ignored != null && Boolean.parseBoolean(ignored)) {
            properties.put(propertyName, IgnoredValue.VALUE);
        } else {
            Class fieldClass = ReflectUtils.getFieldTypeSafely((Class)propertyClass, (String)propertyName);
            if (fieldClass != null) {
                try {
                    properties.put(propertyName, context.convertAnother(properties, fieldClass));
                }
                catch (Throwable e) {
                    throw new StyleException("Component property \"" + propertyName + "\" value from style \"" + styleId + "\" cannot be read", e);
                }
            } else {
                Method getter = ReflectUtils.getFieldGetter((Class)propertyClass, (String)propertyName);
                if (getter != null) {
                    try {
                        Class<?> rClass = getter.getReturnType();
                        properties.put(propertyName, context.convertAnother(properties, rClass));
                    }
                    catch (Throwable e) {
                        throw new StyleException("Component property \"" + propertyName + "\" value from style \"" + styleId + "\" cannot be read", e);
                    }
                } else {
                    throw new StyleException("Component property \"" + propertyName + "\" type from style \"" + styleId + "\" cannot be determined! Make sure it points to existing field or getter method");
                }
            }
        }
    }

    public static Class<? extends Painter> getDefaultPainter(Class inClass, String field) {
        if (inClass != null) {
            Field painterField = ReflectUtils.getFieldSafely((Class)inClass, (String)field);
            painterField.setAccessible(true);
            if (painterField != null) {
                DefaultPainter defaultPainter = painterField.getAnnotation(DefaultPainter.class);
                if (defaultPainter != null) {
                    return defaultPainter.value();
                }
            } else {
                throw new StyleException("Unable to find painter field \"" + field + "\" in class \"" + inClass + "\" for default painter class retrieval");
            }
        }
        return null;
    }
}

