/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter;

import com.alee.managers.style.Bounds;
import com.alee.managers.style.PainterShapeProvider;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.data.ComponentStyle;
import com.alee.painter.AdaptivePainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterListener;
import com.alee.painter.SectionPainter;
import com.alee.painter.SpecificPainter;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.AbstractSectionDecorationPainter;
import com.alee.utils.LafUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.BorderMethods;
import com.alee.utils.swing.DataRunnable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Shape;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;

public final class PainterSupport {
    private static final Map<JComponent, Map<Painter, PainterListener>> installedPainters = new WeakHashMap<JComponent, Map<Painter, PainterListener>>();

    public static <T extends SpecificPainter> T getProperPainter(Painter painter, Class<T> properClass, Class<? extends T> adapterClass) {
        return (T)(painter == null ? null : (ReflectUtils.isAssignable(properClass, painter.getClass()) ? (SpecificPainter)painter : (SpecificPainter)ReflectUtils.createInstanceSafely(adapterClass, (Object[])new Object[]{painter})));
    }

    public static <T extends Painter> T getAdaptedPainter(Painter painter) {
        return (T)(painter != null && painter instanceof AdaptivePainter ? ((AdaptivePainter)painter).getPainter() : painter);
    }

    public static <P extends SpecificPainter> void setPainter(JComponent component, DataRunnable<P> setter, P oldPainter, Painter painter, Class<P> specificClass, Class<? extends P> specificAdapterClass) {
        P properPainter = PainterSupport.getProperPainter(painter, specificClass, specificAdapterClass);
        PainterSupport.uninstallPainter(component, oldPainter);
        setter.run(properPainter);
        PainterSupport.installPainter(component, properPainter);
        SwingUtils.firePropertyChanged(component, "painter", oldPainter, properPainter);
    }

    public static void installPainter(JComponent component, Painter painter) {
        if (component == null || painter == null) {
            return;
        }
        Map<Painter, PainterListener> listeners = installedPainters.get(component);
        if (listeners == null) {
            listeners = new WeakHashMap<Painter, PainterListener>(1);
            installedPainters.put(component, listeners);
        }
        if (!installedPainters.containsKey(painter)) {
            painter.install(component, LafUtils.getUI(component));
            Boolean opaque = painter.isOpaque();
            if (opaque != null) {
                LookAndFeel.installProperty(component, "opaque", opaque != false ? Boolean.TRUE : Boolean.FALSE);
            }
            final WeakReference<JComponent> c = new WeakReference<JComponent>(component);
            final WeakReference<Painter> p = new WeakReference<Painter>(painter);
            PainterListener listener = new PainterListener(){

                @Override
                public void repaint() {
                    ((JComponent)c.get()).repaint();
                }

                @Override
                public void repaint(int x, int y, int width, int height) {
                    ((JComponent)c.get()).repaint(x, y, width, height);
                }

                @Override
                public void revalidate() {
                    ((JComponent)c.get()).revalidate();
                }

                @Override
                public void updateOpacity() {
                    Boolean opaque;
                    Painter painter = (Painter)p.get();
                    if (painter != null && (opaque = painter.isOpaque()) != null) {
                        ((JComponent)c.get()).setOpaque(opaque);
                    }
                }
            };
            painter.addPainterListener(listener);
            listeners.put(painter, listener);
        }
    }

    public static void uninstallPainter(JComponent component, Painter painter) {
        if (component == null || painter == null) {
            return;
        }
        Map<Painter, PainterListener> listeners = installedPainters.get(component);
        if (listeners != null) {
            painter.uninstall(component, LafUtils.getUI(component));
            listeners.remove(painter);
        }
    }

    public static <T extends SectionPainter> T installSectionPainter(Painter origin, T painter, Painter old, JComponent component, ComponentUI ui) {
        if (component != null && ui != null) {
            if (old != null) {
                old.uninstall(component, ui);
                if (old instanceof AbstractSectionDecorationPainter) {
                    ((AbstractSectionDecorationPainter)old).setOrigin(null);
                }
            }
            if (painter != null) {
                if (painter instanceof AbstractSectionDecorationPainter) {
                    ((AbstractSectionDecorationPainter)painter).setOrigin(origin);
                }
                painter.install((JComponent)component, (ComponentUI)ui);
            }
        }
        return painter;
    }

    public static <T extends SectionPainter> T uninstallSectionPainter(T painter, JComponent component, ComponentUI ui) {
        if (component != null && ui != null && painter != null) {
            painter.uninstall((JComponent)component, (ComponentUI)ui);
            if (painter instanceof AbstractSectionDecorationPainter) {
                ((AbstractSectionDecorationPainter)painter).clearOrigin();
            }
        }
        return null;
    }

    public static void updateBorder(Painter painter) {
        if (painter instanceof BorderMethods) {
            ((BorderMethods)((Object)painter)).updateBorder();
        }
    }

    public static Shape getShape(JComponent component, Painter painter) {
        if (painter != null && painter instanceof PainterShapeProvider) {
            return ((PainterShapeProvider)((Object)painter)).provideShape(component, Bounds.margin.of(component));
        }
        return Bounds.margin.of(component);
    }

    public static Dimension getPreferredSize(JComponent component, Painter painter) {
        return PainterSupport.getPreferredSize(component, null, painter);
    }

    public static Dimension getPreferredSize(JComponent component, Dimension preferred, Painter painter) {
        return PainterSupport.getPreferredSize(component, preferred, painter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getPreferredSize(JComponent component, Dimension preferred, Painter painter, boolean ignoreLayoutSize) {
        Dimension ps = SwingUtils.max(preferred, painter != null ? painter.getPreferredSize() : null);
        if (!ignoreLayoutSize) {
            Object object = component.getTreeLock();
            synchronized (object) {
                LayoutManager layout = component.getLayout();
                if (layout != null) {
                    ps = SwingUtils.max(ps, layout.preferredLayoutSize(component));
                }
            }
        }
        return ps;
    }

    public static boolean isDecoratable(Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            ComponentStyle style = StyleManager.getSkin(jComponent).getComponentStyle(jComponent);
            Object painter = style != null ? style.getPainter(jComponent) : null;
            return painter != null && painter instanceof AbstractDecorationPainter;
        }
        return false;
    }
}

