/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration;

import com.alee.painter.decoration.background.GradientColor;
import com.alee.painter.decoration.background.GradientType;
import com.alee.utils.MathUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.util.List;
import javax.swing.JComponent;

public final class DecorationUtils {
    public static Paint getPaint(GradientType type, List<GradientColor> colors, int x1, int y1, int x2, int y2) {
        boolean fits;
        if (colors.size() == 1) {
            return colors.get(0).getColor();
        }
        float[] f = new float[colors.size()];
        Color[] c = new Color[colors.size()];
        boolean even = colors.get(0).getFraction() == null;
        for (int i = 0; i < colors.size(); ++i) {
            GradientColor color = colors.get(i);
            if (even) {
                f[i] = (float)i * 1.0f / (float)(colors.size() - 1);
            } else if (color.getFraction().floatValue() > 1.0f) {
                int length = MathUtils.sqrt((double)(MathUtils.sqr((int)(x2 - x1)) + MathUtils.sqr((int)(y2 - y1))));
                f[i] = MathUtils.limit((float)0.0f, (float)color.getFraction().floatValue(), (float)length) / (float)length;
            } else {
                f[i] = color.getFraction().floatValue();
            }
            c[i] = color.getColor();
        }
        boolean bl = fits = x1 != x2 || y1 != y2;
        if (type == GradientType.linear) {
            if (fits) {
                return new LinearGradientPaint(x1, y1, x2, y2, f, c);
            }
            return colors.get(0).getColor();
        }
        if (type == GradientType.radial) {
            if (fits) {
                float r = (float)Point.distance(x1, y1, x2, y2);
                return new RadialGradientPaint(x1, (float)y1, r, f, c);
            }
            return colors.get(0).getColor();
        }
        throw new RuntimeException("Unknown gradient type provided");
    }

    public static String toString(boolean top, boolean left, boolean bottom, boolean right) {
        return (top ? 1 : 0) + "," + (left ? 1 : 0) + "," + (bottom ? 1 : 0) + "," + (right ? 1 : 0);
    }

    public static void fireStatesChanged(JComponent component) {
        SwingUtils.firePropertyChanged(component, "decorationStates", null, null);
    }
}

