/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.background;

import com.alee.painter.decoration.DecorationUtils;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.AbstractBackground;
import com.alee.painter.decoration.background.GradientColor;
import com.alee.painter.decoration.background.GradientType;
import com.alee.utils.CollectionUtils;
import com.alee.utils.GraphicsUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JComponent;

@XStreamAlias(value="GradientBackground")
public class GradientBackground<E extends JComponent, D extends IDecoration<E, D>, I extends GradientBackground<E, D, I>>
extends AbstractBackground<E, D, I> {
    @XStreamAsAttribute
    protected GradientType type;
    @XStreamAsAttribute
    protected Point2D.Float from;
    @XStreamAsAttribute
    protected Point2D.Float to;
    @XStreamImplicit(itemFieldName="color")
    protected List<GradientColor> colors;

    public GradientType getType() {
        return this.type != null ? this.type : GradientType.linear;
    }

    public Point2D.Float getFrom() {
        return this.from != null ? this.from : new Point2D.Float(0.0f, 0.0f);
    }

    public Point2D.Float getTo() {
        return this.to != null ? this.to : new Point2D.Float(0.0f, 1.0f);
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, D d, Shape shape) {
        float opacity = this.getOpacity();
        if (opacity > 0.0f) {
            Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(opacity), (opacity < 1.0f ? 1 : 0) != 0);
            Rectangle b = shape.getBounds();
            Point2D.Float from = this.getFrom();
            Point2D.Float to = this.getTo();
            int x1 = (int)Math.round((double)b.x + (double)b.width * from.getX());
            int y1 = (int)Math.round((double)b.y + (double)b.height * from.getY());
            int x2 = (int)Math.round((double)b.x + (double)b.width * to.getX());
            int y2 = (int)Math.round((double)b.y + (double)b.height * to.getY());
            Paint paint = DecorationUtils.getPaint(this.getType(), this.colors, x1, y1, x2, y2);
            Paint op = GraphicsUtils.setupPaint((Graphics2D)g2d, (Paint)paint);
            g2d.fill(shape);
            GraphicsUtils.restorePaint((Graphics2D)g2d, (Paint)op);
            GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc, (opacity < 1.0f ? 1 : 0) != 0);
        }
    }

    @Override
    public I merge(I background) {
        super.merge(background);
        if (((GradientBackground)background).type != null) {
            this.type = ((GradientBackground)background).type;
        }
        if (((GradientBackground)background).from != null) {
            this.from = ((GradientBackground)background).from;
        }
        if (((GradientBackground)background).to != null) {
            this.to = ((GradientBackground)background).to;
        }
        if (((GradientBackground)background).colors != null) {
            this.colors = CollectionUtils.copy(((GradientBackground)background).colors);
        }
        return (I)this;
    }
}

