/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.background;

import com.alee.painter.common.TextureType;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.AbstractTextureBackground;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

@XStreamAlias(value="PresetTextureBackground")
public class PresetTextureBackground<E extends JComponent, D extends IDecoration<E, D>, I extends PresetTextureBackground<E, D, I>>
extends AbstractTextureBackground<E, D, I> {
    @XStreamAsAttribute
    protected TextureType preset = null;

    @Override
    protected boolean isPaintable() {
        return this.preset != null && this.preset != TextureType.none;
    }

    @Override
    protected TexturePaint getTexturePaint(Rectangle bounds) {
        BufferedImage image = this.preset.getTexture();
        return new TexturePaint(image, new Rectangle(bounds.x, bounds.y, image.getWidth(), image.getHeight()));
    }

    @Override
    public I merge(I background) {
        super.merge(background);
        if (((PresetTextureBackground)background).preset != null) {
            this.preset = ((PresetTextureBackground)background).preset;
        }
        return (I)this;
    }
}

