/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.border;

import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.border.IBorder;
import com.alee.utils.MergeUtils;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import javax.swing.JComponent;

public abstract class AbstractBorder<E extends JComponent, D extends IDecoration<E, D>, I extends AbstractBorder<E, D, I>>
implements IBorder<E, D, I> {
    private static final String defaultId = "border";
    private static final Color defaultColor = new Color(210, 210, 210);
    @XStreamAsAttribute
    protected String id;
    @XStreamAsAttribute
    protected Float opacity;
    @XStreamAsAttribute
    protected Stroke stroke;
    @XStreamAsAttribute
    protected Color color;

    public String getId() {
        return this.id != null ? this.id : defaultId;
    }

    @Override
    public float getOpacity() {
        return this.opacity != null ? this.opacity.floatValue() : 1.0f;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public float getWidth() {
        float t = this.getOpacity();
        Stroke s = this.getStroke();
        return t > 0.0f ? (s != null && s instanceof BasicStroke ? ((BasicStroke)s).getLineWidth() : 1.0f) : 0.0f;
    }

    @Override
    public Color getColor() {
        return this.color != null ? this.color : defaultColor;
    }

    public I merge(I border) {
        if (((AbstractBorder)border).opacity != null) {
            this.opacity = ((AbstractBorder)border).opacity;
        }
        if (((AbstractBorder)border).stroke != null) {
            this.stroke = ((AbstractBorder)border).stroke;
        }
        if (((AbstractBorder)border).color != null) {
            this.color = ((AbstractBorder)border).color;
        }
        return (I)this;
    }

    public I clone() {
        return (I)((AbstractBorder)MergeUtils.cloneByFieldsSafely((Object)this, (Object[])new Object[0]));
    }
}

