/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.shape;

import com.alee.painter.decoration.WebDecoration;
import com.alee.painter.decoration.shadow.ShadowType;
import com.alee.painter.decoration.shape.AbstractShape;
import com.alee.painter.decoration.shape.ShapeType;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import javax.swing.JComponent;

@XStreamAlias(value="EllipseShape")
public class EllipseShape<E extends JComponent, D extends WebDecoration<E, D>, I extends EllipseShape<E, D, I>>
extends AbstractShape<E, D, I> {
    @Override
    public Insets getBorderInsets(E c, D d) {
        int borderWidth = (int)Math.round(Math.floor(((WebDecoration)d).getBorderWidth()));
        int shadowWidth = ((WebDecoration)d).getShadeWidth(ShadowType.outer);
        int spacing = shadowWidth + borderWidth;
        return new Insets(spacing, spacing, spacing, spacing);
    }

    @Override
    public Shape getShape(ShapeType type, Rectangle bounds, E c, D d) {
        int sw = ((WebDecoration)d).getShadeWidth(ShadowType.outer);
        int bgShear = type.isBorder() ? -1 : 0;
        return new Ellipse2D.Double(bounds.x + sw, bounds.y + sw, bounds.width - sw * 2 + bgShear, bounds.height - sw * 2 + bgShear);
    }
}

