/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.shape;

import com.alee.managers.log.Log;
import com.alee.painter.decoration.shape.Round;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.util.StringTokenizer;

public class RoundConverter
extends AbstractSingleValueConverter {
    public static final String separator = ",";

    public boolean canConvert(Class type) {
        return Round.class.isAssignableFrom(type);
    }

    public Object fromString(String insets) {
        return RoundConverter.roundFromString(insets);
    }

    public String toString(Object object) {
        return RoundConverter.roundToString((Round)object);
    }

    public static Round roundFromString(String insets) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(insets, separator, false);
            if (tokenizer.hasMoreTokens()) {
                int topLeft = Integer.parseInt(tokenizer.nextToken().trim());
                if (tokenizer.hasMoreTokens()) {
                    int topRight = Integer.parseInt(tokenizer.nextToken().trim());
                    if (tokenizer.hasMoreTokens()) {
                        int bottomRight = Integer.parseInt(tokenizer.nextToken().trim());
                        if (tokenizer.hasMoreTokens()) {
                            int bottomLeft = Integer.parseInt(tokenizer.nextToken().trim());
                            return new Round(topLeft, topRight, bottomRight, bottomLeft);
                        }
                        return new Round(topLeft, topRight, bottomRight, topRight);
                    }
                    return new Round(topLeft, topRight, topLeft, topRight);
                }
                return new Round(topLeft, topLeft, topLeft, topLeft);
            }
            return new Round();
        }
        catch (Throwable e) {
            Log.get().error("Unable to parse Round: " + insets, e);
            return new Round();
        }
    }

    public static String roundToString(Round round) {
        if (round.topLeft == round.topRight && round.bottomLeft == round.bottomRight && round.topLeft == round.bottomLeft) {
            return Integer.toString(round.topLeft);
        }
        if (round.topLeft == round.bottomRight && round.topRight == round.bottomLeft) {
            return round.topLeft + separator + round.topRight;
        }
        if (round.topRight == round.bottomLeft) {
            return round.topLeft + separator + round.topRight + separator + round.bottomRight;
        }
        return round.topLeft + separator + round.topRight + separator + round.bottomRight + separator + round.bottomLeft;
    }
}

