/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing.menu;

import com.alee.laf.menu.WebCheckBoxMenuItem;
import com.alee.laf.menu.WebMenu;
import com.alee.laf.menu.WebMenuItem;
import com.alee.laf.menu.WebPopupMenu;
import com.alee.laf.menu.WebRadioButtonMenuItem;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.language.LM;
import com.alee.managers.log.Log;
import com.alee.utils.swing.UnselectableButtonGroup;
import com.alee.utils.swing.menu.MenuGenerator;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public abstract class AbstractMenuGenerator<E extends JComponent> {
    protected static final Object defaultIcon = null;
    protected static final HotkeyData defaultHotkey = null;
    protected static final boolean defaultEnabled = true;
    protected static final boolean defaultSelected = false;
    protected static final ActionListener defaultAction = null;
    protected static final String defaultIconFormat = ".png";
    protected Class nearClass;
    protected String path;
    protected String extension;
    protected String languagePrefix;
    protected UnselectableButtonGroup group;
    protected E menu;

    public AbstractMenuGenerator(E menu) {
        this.menu = menu;
    }

    public Class getNearClass() {
        return this.nearClass;
    }

    public void setNearClass(Class nearClass) {
        this.nearClass = nearClass;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension == null ? null : (extension.startsWith(".") ? extension : "." + extension);
    }

    public void setIconSettings(String path, String extension) {
        this.nearClass = null;
        this.path = path;
        this.extension = extension;
    }

    public void setIconSettings(Class nearClass, String path, String extension) {
        this.nearClass = nearClass;
        this.path = path;
        this.extension = extension;
    }

    public String getLanguagePrefix() {
        return this.languagePrefix;
    }

    public void setLanguagePrefix(String prefix) {
        this.languagePrefix = prefix;
    }

    public String getLanguageKey(String text) {
        if (this.languagePrefix == null) {
            return text;
        }
        String key = this.languagePrefix + "." + text;
        return LM.contains((String)key) ? key : text;
    }

    public void addSeparator() {
        E menuComponent = this.getMenu();
        if (menuComponent instanceof WebMenu) {
            ((WebMenu)menuComponent).addSeparator();
        } else if (menuComponent instanceof WebPopupMenu) {
            ((WebPopupMenu)menuComponent).addSeparator();
        }
    }

    public WebMenuItem addItem(String text, ActionListener actionListener) {
        return this.addItem(defaultIcon, text, defaultHotkey, true, actionListener);
    }

    public WebMenuItem addItem(String text, HotkeyData hotkey, ActionListener actionListener) {
        return this.addItem(defaultIcon, text, hotkey, true, actionListener);
    }

    public WebMenuItem addItem(String text, boolean enabled, ActionListener actionListener) {
        return this.addItem(defaultIcon, text, defaultHotkey, enabled, actionListener);
    }

    public WebMenuItem addItem(String text, HotkeyData hotkey, boolean enabled, ActionListener actionListener) {
        return this.addItem(defaultIcon, text, hotkey, enabled, actionListener);
    }

    public WebMenuItem addItem(Object icon, String text, ActionListener actionListener) {
        return this.addItem(icon, text, defaultHotkey, true, actionListener);
    }

    public WebMenuItem addItem(Object icon, String text, HotkeyData hotkey, ActionListener actionListener) {
        return this.addItem(icon, text, hotkey, true, actionListener);
    }

    public WebMenuItem addItem(Object icon, String text, boolean enabled, ActionListener actionListener) {
        return this.addItem(icon, text, defaultHotkey, enabled, actionListener);
    }

    public WebMenuItem addItem(Object icon, String text, HotkeyData hotkey, boolean enabled, ActionListener actionListener) {
        WebMenuItem item = this.createItem(icon, text, hotkey, enabled, actionListener);
        ((Container)this.getMenu()).add(item);
        return item;
    }

    protected WebMenuItem createItem(Object icon, String text, HotkeyData hotkey, boolean enabled, ActionListener actionListener) {
        WebMenuItem item = new WebMenuItem();
        item.setIcon(this.getIcon(icon));
        item.setLanguage(this.getLanguageKey(text), new Object[0]);
        item.setAccelerator(hotkey);
        item.setEnabled(enabled);
        if (actionListener != null) {
            item.addActionListener(actionListener);
        }
        return item;
    }

    public WebCheckBoxMenuItem addCheckItem(String text, boolean selected, ActionListener actionListener) {
        return this.addCheckItem(defaultIcon, text, defaultHotkey, true, selected, actionListener);
    }

    public WebCheckBoxMenuItem addCheckItem(String text, HotkeyData hotkey, boolean selected, ActionListener actionListener) {
        return this.addCheckItem(defaultIcon, text, hotkey, true, selected, actionListener);
    }

    public WebCheckBoxMenuItem addCheckItem(String text, boolean enabled, boolean selected, ActionListener actionListener) {
        return this.addCheckItem(defaultIcon, text, defaultHotkey, enabled, selected, actionListener);
    }

    public WebCheckBoxMenuItem addCheckItem(String text, HotkeyData hotkey, boolean enabled, boolean selected, ActionListener actionListener) {
        return this.addCheckItem(defaultIcon, text, hotkey, enabled, selected, actionListener);
    }

    public WebCheckBoxMenuItem addCheckItem(Object icon, String text, boolean selected, ActionListener actionListener) {
        return this.addCheckItem(icon, text, defaultHotkey, true, selected, actionListener);
    }

    public WebCheckBoxMenuItem addCheckItem(Object icon, String text, HotkeyData hotkey, boolean selected, ActionListener actionListener) {
        return this.addCheckItem(icon, text, hotkey, true, selected, actionListener);
    }

    public WebCheckBoxMenuItem addCheckItem(Object icon, String text, boolean enabled, boolean selected, ActionListener actionListener) {
        return this.addCheckItem(icon, text, defaultHotkey, enabled, selected, actionListener);
    }

    public WebCheckBoxMenuItem addCheckItem(Object icon, String text, HotkeyData hotkey, boolean enabled, boolean selected, ActionListener actionListener) {
        WebCheckBoxMenuItem item = this.createCheckItem(icon, text, hotkey, enabled, selected, actionListener);
        ((Container)this.getMenu()).add(item);
        return item;
    }

    protected WebCheckBoxMenuItem createCheckItem(Object icon, String text, HotkeyData hotkey, boolean enabled, boolean selected, ActionListener actionListener) {
        WebCheckBoxMenuItem item = new WebCheckBoxMenuItem();
        item.setIcon(this.getIcon(icon));
        item.setLanguage(this.getLanguageKey(text), new Object[0]);
        item.setAccelerator(hotkey);
        item.setEnabled(enabled);
        item.setSelected(selected);
        if (actionListener != null) {
            item.addActionListener(actionListener);
        }
        this.group(item);
        return item;
    }

    public WebRadioButtonMenuItem addRadioItem(String text, boolean selected, ActionListener actionListener) {
        return this.addRadioItem(defaultIcon, text, defaultHotkey, true, selected, actionListener);
    }

    public WebRadioButtonMenuItem addRadioItem(String text, HotkeyData hotkey, boolean selected, ActionListener actionListener) {
        return this.addRadioItem(defaultIcon, text, hotkey, true, selected, actionListener);
    }

    public WebRadioButtonMenuItem addRadioItem(String text, boolean enabled, boolean selected, ActionListener actionListener) {
        return this.addRadioItem(defaultIcon, text, defaultHotkey, enabled, selected, actionListener);
    }

    public WebRadioButtonMenuItem addRadioItem(String text, HotkeyData hotkey, boolean enabled, boolean selected, ActionListener actionListener) {
        return this.addRadioItem(defaultIcon, text, hotkey, enabled, selected, actionListener);
    }

    public WebRadioButtonMenuItem addRadioItem(Object icon, String text, boolean selected, ActionListener actionListener) {
        return this.addRadioItem(icon, text, defaultHotkey, true, selected, actionListener);
    }

    public WebRadioButtonMenuItem addRadioItem(Object icon, String text, HotkeyData hotkey, boolean selected, ActionListener actionListener) {
        return this.addRadioItem(icon, text, hotkey, true, selected, actionListener);
    }

    public WebRadioButtonMenuItem addRadioItem(Object icon, String text, boolean enabled, boolean selected, ActionListener actionListener) {
        return this.addRadioItem(icon, text, defaultHotkey, enabled, selected, actionListener);
    }

    public WebRadioButtonMenuItem addRadioItem(Object icon, String text, HotkeyData hotkey, boolean enabled, boolean selected, ActionListener actionListener) {
        WebRadioButtonMenuItem item = this.createRadioItem(icon, text, hotkey, enabled, selected, actionListener);
        ((Container)this.getMenu()).add(item);
        return item;
    }

    protected WebRadioButtonMenuItem createRadioItem(Object icon, String text, HotkeyData hotkey, boolean enabled, boolean selected, ActionListener actionListener) {
        WebRadioButtonMenuItem item = new WebRadioButtonMenuItem();
        item.setIcon(this.getIcon(icon));
        item.setLanguage(this.getLanguageKey(text), new Object[0]);
        item.setAccelerator(hotkey);
        item.setEnabled(enabled);
        item.setSelected(selected);
        if (actionListener != null) {
            item.addActionListener(actionListener);
        }
        this.group(item);
        return item;
    }

    public MenuGenerator addSubMenu(String text) {
        return this.addSubMenu(defaultIcon, text, true, defaultAction);
    }

    public MenuGenerator addSubMenu(String text, boolean enabled) {
        return this.addSubMenu(defaultIcon, text, enabled, defaultAction);
    }

    public MenuGenerator addSubMenu(String text, ActionListener actionListener) {
        return this.addSubMenu(defaultIcon, text, true, actionListener);
    }

    public MenuGenerator addSubMenu(String text, boolean enabled, ActionListener actionListener) {
        return this.addSubMenu(defaultIcon, text, enabled, actionListener);
    }

    public MenuGenerator addSubMenu(Object icon, String text) {
        return this.addSubMenu(icon, text, true, defaultAction);
    }

    public MenuGenerator addSubMenu(Object icon, String text, boolean enabled) {
        return this.addSubMenu(icon, text, enabled, defaultAction);
    }

    public MenuGenerator addSubMenu(Object icon, String text, ActionListener actionListener) {
        return this.addSubMenu(icon, text, true, actionListener);
    }

    public MenuGenerator addSubMenu(Object icon, String text, boolean enabled, ActionListener actionListener) {
        WebMenu menu = this.createSubMenu(icon, text, enabled, actionListener);
        ((Container)this.getMenu()).add(menu);
        MenuGenerator menuGenerator = new MenuGenerator(menu);
        menuGenerator.setNearClass(this.nearClass);
        menuGenerator.setPath(this.path);
        menuGenerator.setExtension(this.extension);
        menuGenerator.setLanguagePrefix(this.languagePrefix);
        return menuGenerator;
    }

    protected WebMenu createSubMenu(Object icon, String text, boolean enabled, ActionListener actionListener) {
        WebMenu menu = new WebMenu();
        menu.setIcon(this.getIcon(icon));
        menu.setLanguage(this.getLanguageKey(text), new Object[0]);
        menu.setEnabled(enabled);
        if (actionListener != null) {
            menu.addActionListener(actionListener);
        }
        return menu;
    }

    public UnselectableButtonGroup openGroup() {
        return this.openGroup(false);
    }

    public UnselectableButtonGroup openGroup(boolean unselectable) {
        this.group = new UnselectableButtonGroup(unselectable);
        return this.group;
    }

    public UnselectableButtonGroup group(AbstractButton button) {
        if (this.group != null) {
            this.group.add(button);
        }
        return this.group;
    }

    public UnselectableButtonGroup closeGroup() {
        UnselectableButtonGroup group = this.group;
        this.group = null;
        return group;
    }

    public Icon getIcon(Object icon) {
        if (icon != null) {
            if (icon instanceof String) {
                try {
                    if (this.nearClass != null) {
                        return new ImageIcon(this.nearClass.getResource(this.path + icon + this.extension));
                    }
                    return new ImageIcon(new File(this.path, icon + this.extension).getAbsolutePath());
                }
                catch (Throwable e) {
                    Log.warn((String)("Unable to find menu icon for path: " + this.path + icon + this.extension), (Throwable)e);
                    return null;
                }
            }
            if (icon instanceof Icon) {
                return (Icon)icon;
            }
            if (icon instanceof Image) {
                return new ImageIcon((Image)icon);
            }
            if (icon instanceof File) {
                return new ImageIcon(((File)icon).getAbsolutePath());
            }
            if (icon instanceof URL) {
                return new ImageIcon((URL)icon);
            }
            Log.warn((String)("Unknown icon object type provided: " + icon));
            return null;
        }
        return null;
    }

    public E getMenu() {
        return this.menu;
    }

    public boolean isEmpty() {
        return ((Container)this.menu).getComponentCount() == 0;
    }
}

