/*
 * Decompiled with CFR 0.152.
 */
package org.pegdown;

import org.pegdown.FastEncoder;

public class Printer {
    public final StringBuilder sb;
    public int indent;

    public Printer() {
        this(new StringBuilder());
    }

    public Printer(StringBuilder sb) {
        this.sb = sb;
    }

    public Printer indent(int delta) {
        this.indent += delta;
        return this;
    }

    public Printer print(String string) {
        this.sb.append(string);
        return this;
    }

    public Printer printEncoded(String string) {
        FastEncoder.encode(string, this.sb);
        return this;
    }

    public Printer print(char c) {
        this.sb.append(c);
        return this;
    }

    public Printer println() {
        if (this.sb.length() > 0) {
            this.print('\n');
        }
        for (int i = 0; i < this.indent; ++i) {
            this.print(' ');
        }
        return this;
    }

    public Printer printchkln() {
        if (!this.endsWithNewLine()) {
            if (this.sb.length() > 0) {
                this.print('\n');
            }
            for (int i = 0; i < this.indent; ++i) {
                this.print(' ');
            }
        }
        return this;
    }

    public Printer printchkln(boolean printNewLine) {
        if (printNewLine) {
            if (this.sb.length() > 0) {
                this.print('\n');
            }
            for (int i = 0; i < this.indent; ++i) {
                this.print(' ');
            }
        }
        return this;
    }

    public boolean endsWithNewLine() {
        int iMax;
        int i = iMax = this.sb.length();
        while (i-- > 0) {
            if (this.sb.charAt(i) == ' ') continue;
            return this.sb.charAt(i) == '\n';
        }
        return false;
    }

    public String getString() {
        return this.sb.toString();
    }

    public Printer clear() {
        this.sb.setLength(0);
        return this;
    }
}

