/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.app;

import de.sciss.app.AbstractApplication;
import de.sciss.app.Application;
import de.sciss.app.PerformableEdit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.CompoundEdit;

public abstract class AbstractCompoundEdit
extends CompoundEdit
implements PerformableEdit {
    private final String presentationName;
    private List collToPerform = null;

    protected AbstractCompoundEdit() {
        this(null);
    }

    protected AbstractCompoundEdit(String string) {
        this.presentationName = string;
    }

    @Override
    public void undo() {
        super.undo();
        this.undoDone();
    }

    @Override
    public void redo() {
        super.redo();
        this.redoDone();
    }

    public void cancel() {
        if (this.collToPerform != null) {
            for (int i = 0; i < this.collToPerform.size(); ++i) {
                ((PerformableEdit)this.collToPerform.get(i)).die();
            }
            this.collToPerform = null;
        }
        this.end();
        super.undo();
        super.die();
        this.cancelDone();
    }

    protected abstract void undoDone();

    protected abstract void redoDone();

    protected abstract void cancelDone();

    @Override
    public String getPresentationName() {
        if (this.presentationName != null) {
            return this.presentationName;
        }
        return super.getPresentationName();
    }

    @Override
    public String getUndoPresentationName() {
        if (this.presentationName != null) {
            return this.getResourceString("menuUndo") + " " + this.presentationName;
        }
        return super.getUndoPresentationName();
    }

    @Override
    public String getRedoPresentationName() {
        if (this.presentationName != null) {
            return this.getResourceString("menuRedo") + " " + this.presentationName;
        }
        return super.getRedoPresentationName();
    }

    protected String getResourceString(String string) {
        Application application = AbstractApplication.getApplication();
        return application != null ? application.getResourceString(string) : string;
    }

    public void addPerform(PerformableEdit performableEdit) {
        if (this.collToPerform == null) {
            this.collToPerform = new ArrayList();
        }
        this.collToPerform.add(performableEdit);
    }

    @Override
    public PerformableEdit perform() {
        if (this.collToPerform == null) {
            return this;
        }
        for (int i = 0; i < this.collToPerform.size(); ++i) {
            PerformableEdit performableEdit = (PerformableEdit)this.collToPerform.get(i);
            performableEdit.perform();
            this.addEdit(performableEdit);
        }
        this.collToPerform = null;
        return this;
    }

    @Override
    public void debugDump(int n) {
        PerformableEdit performableEdit;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(n << 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        String string = stringBuffer.toString();
        ++n;
        System.err.println(string + "Edits : " + this.edits.size());
        for (n2 = 0; n2 < this.edits.size(); ++n2) {
            performableEdit = (PerformableEdit)this.edits.get(n2);
            System.err.print(string + " edit #" + n2 + " = ");
            performableEdit.debugDump(n);
        }
        System.err.println(string + "To perform : " + (this.collToPerform != null ? this.collToPerform.size() : 0));
        if (this.collToPerform != null) {
            for (n2 = 0; n2 < this.collToPerform.size(); ++n2) {
                performableEdit = (PerformableEdit)this.collToPerform.get(n2);
                System.err.print(string + " perf #" + n2 + " = ");
                performableEdit.debugDump(n);
            }
        }
    }
}

