/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.app;

import de.sciss.app.Document;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class UndoManager
extends javax.swing.undo.UndoManager {
    private final AbstractAction undoAction;
    private final AbstractAction redoAction;
    private AbstractAction debugAction = null;
    private final Document doc;
    protected final String undoText;
    protected final String redoText;
    private CompoundEdit pendingEdits;
    private int pendingEditCount = 0;

    public UndoManager(Document document) {
        this.setLimit(1000);
        this.doc = document;
        this.undoText = document.getApplication().getResourceString("menuUndo");
        this.redoText = document.getApplication().getResourceString("menuRedo");
        this.undoAction = this.createUndoAction();
        this.redoAction = this.createRedoAction();
        this.pendingEdits = new CompoundEdit();
        this.updateStates();
    }

    protected AbstractAction createUndoAction() {
        return new ActionUndo();
    }

    protected AbstractAction createRedoAction() {
        return new ActionRedo();
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    public Action getDebugDumpAction() {
        if (this.debugAction == null) {
            this.debugAction = new ActionDebugDump();
        }
        return this.debugAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        if (undoableEdit.isSignificant()) {
            CompoundEdit compoundEdit = this.pendingEdits;
            synchronized (compoundEdit) {
                if (this.pendingEditCount > 0) {
                    this.pendingEdits.end();
                    super.addEdit(this.pendingEdits);
                    this.pendingEdits = new CompoundEdit();
                    this.pendingEditCount = 0;
                }
            }
            boolean bl = super.addEdit(undoableEdit);
            this.updateStates();
            return bl;
        }
        CompoundEdit compoundEdit = this.pendingEdits;
        synchronized (compoundEdit) {
            ++this.pendingEditCount;
            return this.pendingEdits.addEdit(undoableEdit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redo() throws CannotRedoException {
        try {
            this.undoPending();
            super.redo();
        }
        finally {
            this.updateStates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo() throws CannotUndoException {
        try {
            this.undoPending();
            super.undo();
        }
        finally {
            this.updateStates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undoPending() {
        CompoundEdit compoundEdit = this.pendingEdits;
        synchronized (compoundEdit) {
            if (this.pendingEditCount > 0) {
                this.pendingEdits.end();
                this.pendingEdits.undo();
                this.pendingEdits = new CompoundEdit();
                this.pendingEditCount = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discardAllEdits() {
        CompoundEdit compoundEdit = this.pendingEdits;
        synchronized (compoundEdit) {
            this.pendingEdits.die();
            this.pendingEdits = new CompoundEdit();
            this.pendingEditCount = 0;
        }
        super.discardAllEdits();
        this.updateStates();
    }

    private void updateStates() {
        String string;
        if (this.undoAction.isEnabled() != this.canUndo()) {
            this.undoAction.setEnabled(this.canUndo());
            this.doc.setDirty(this.canUndo());
        }
        if (this.redoAction.isEnabled() != this.canRedo()) {
            this.redoAction.setEnabled(this.canRedo());
        }
        if (!(string = this.getUndoPresentationName()).equals(this.undoAction.getValue("Name"))) {
            this.undoAction.putValue("Name", string);
        }
        if (!(string = this.getRedoPresentationName()).equals(this.redoAction.getValue("Name"))) {
            this.redoAction.putValue("Name", string);
        }
    }

    @Override
    protected UndoableEdit editToBeRedone() {
        return super.editToBeRedone();
    }

    @Override
    protected UndoableEdit editToBeUndone() {
        return super.editToBeUndone();
    }

    public Document getDocument() {
        return this.doc;
    }

    protected List getEdits() {
        return this.edits;
    }

    private class ActionDebugDump
    extends AbstractAction {
        protected ActionDebugDump() {
            super("Dump Undo History");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = UndoManager.this.getEdits().size();
            UndoableEdit undoableEdit = UndoManager.this.editToBeRedone();
            UndoableEdit undoableEdit2 = UndoManager.this.editToBeUndone();
            System.err.println("Undo buffer contains " + n + " edits.");
            for (int i = 0; i < n; ++i) {
                UndoableEdit undoableEdit3 = (UndoableEdit)UndoManager.this.getEdits().get(i);
                if (undoableEdit3 == undoableEdit) {
                    System.err.print("R");
                } else if (undoableEdit3 == undoableEdit2) {
                    System.err.print("U");
                } else {
                    System.err.print(" ");
                }
                System.err.println(" edit #" + i + " = " + undoableEdit3.getPresentationName());
            }
        }
    }

    protected class ActionRedo
    extends AbstractAction {
        protected ActionRedo() {
            super(UndoManager.this.redoText);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                UndoManager.this.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                System.err.println(cannotRedoException.getLocalizedMessage());
            }
        }
    }

    protected class ActionUndo
    extends AbstractAction {
        protected ActionUndo() {
            super(UndoManager.this.undoText);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                UndoManager.this.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                System.err.println(cannotUndoException.getLocalizedMessage());
            }
        }
    }
}

